/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.layout;

import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.SettingCardLayout;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class EvalSettingLayout
extends SettingCardLayout {
    private static final long serialVersionUID = 2487697091282233813L;
    private JComboBox<String> targetVesionBox;
    private JComponent toVersion;

    public EvalSettingLayout(JComboBox<String> targetVesionBox) {
        this.targetVesionBox = targetVesionBox;
        this.setLayout(new BorderLayout());
        JComponent box = this.initUI();
        this.add((Component)box, "North");
    }

    private JComponent initUI() {
        JComponent topComponent = this.initTopComponent();
        JComponent resultDirSelector = this.initResultDirSaveComponent();
        JComponent clusterInfo = this.initClusterInfo();
        JComponent targetVersion = this.initTargetVersionComponent();
        this.setComponentSize();
        return UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{topComponent}), UCD.buildHBoxLeft((Component[])new Component[]{clusterInfo}), UCD.buildHBoxLeft((Component[])new Component[]{targetVersion}), UCD.buildHBoxLeft((Component[])new Component[]{resultDirSelector}), Box.createVerticalStrut(10)});
    }

    private JComponent initTargetVersionComponent() {
        this.toVersion = UiMethod.createRequiredLabel((String)(ResourceUtil.getString((String)"cluster.software.target.version") + ":"), (boolean)true);
        Dimension dimension = new Dimension(300, 20);
        this.targetVesionBox.setSize(dimension);
        this.targetVesionBox.setPreferredSize(dimension);
        this.targetVesionBox.setMaximumSize(dimension);
        this.initSupportedPath();
        return UCD.buildHBoxLeft((Component[])new Component[]{this.toVersion, this.targetVesionBox});
    }

    @Override
    protected void setComponentSize() {
        if (this.clusterEvalInfo.getMode().equals((Object)ClusterMode.DOUBLE)) {
            UCD.setSameWidth((JComponent[])new JComponent[]{secndNodeIpLabel, priNodeIpLabel, fsmOriginalVerLabel, evalResPathLabel, this.clutserDetailLable, this.toVersion});
        } else {
            UCD.setSameWidth((JComponent[])new JComponent[]{priNodeIpLabel, fsmOriginalVerLabel, evalResPathLabel, this.clutserDetailLable, this.toVersion});
        }
    }

    @Override
    protected JComponent initTopComponent() {
        return new JLabel(ResourceUtil.getString((String)"please.select.destination.ver"));
    }

    private void initSupportedPath() {
        String[] targetVersionArray;
        if (this.targetVesionBox == null) {
            return;
        }
        this.targetVesionBox.removeAllItems();
        for (String targetVersion : targetVersionArray = this.getTargetVersion()) {
            this.targetVesionBox.addItem(targetVersion);
        }
        String inputManually = ResourceUtil.getString((String)"input.destination.version.manually");
        this.targetVesionBox.addItem(inputManually);
        String placeholder = ResourceUtil.getString((String)"please.select");
        this.targetVesionBox.addItem(placeholder);
        this.targetVesionBox.setSelectedItem(placeholder);
    }

    private String[] getTargetVersion() {
        return FusionStorageEvalContext.getInstance().getSupportedEvalPathMap().get(FusionStorageEvalContext.getInstance().getTaskInfo().getShowVersion()).getToVersions().split(",");
    }

    public JComboBox<String> getTargetVesionBox() {
        return this.targetVesionBox;
    }
}

