/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener;

import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.DetailRecord;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs.EvalDetailDialog;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs.ItemDetailInfoDialog;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.IsmListModel;
import com.huawei.ism.ui.swing.plaf.armor.ArmorListUI;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Locale;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ListUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailListListener
extends MouseAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DetailListListener.class);
    private PerformCardLayout layout = null;

    public DetailListListener(PerformCardLayout layout) {
        this.layout = layout;
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (SwingUtilities.isRightMouseButton(event) || event.getClickCount() > 1) {
            return;
        }
        int index = this.getListIndex(event.getPoint(), this.layout.getDetailList());
        if (-1 == index) {
            return;
        }
        IsmListModel model = (IsmListModel)this.layout.getDetailList().getModel();
        DetailRecord rec = (DetailRecord)model.getElementAt(index);
        String itemId = rec.getItemId();
        String nodeId = rec.getNodeId();
        if (!StringUtils.isNULLStr((String)itemId)) {
            LOGGER.info(String.format(Locale.ENGLISH, "Click item detail,node id is %s item id is %s", nodeId, itemId));
            EvalDetailDialog detail = new EvalDetailDialog(FusionStorageEvalContext.getInstance().getMainDialog(), nodeId, itemId);
            detail.setVisible(true);
        } else if (rec.isError()) {
            ItemDetailInfoDialog detailInfoDialog = new ItemDetailInfoDialog(rec.getErrorInfo(), FusionStorageEvalContext.getInstance().getMainDialog(), ResourceUtil.getString((String)"perform.eval.detail.errmsg"));
            detailInfoDialog.setVisible(true);
        }
    }

    private int getListIndex(Point point, JList detailList) {
        int index = -1;
        ListUI obj = detailList.getUI();
        if (obj instanceof ArmorListUI) {
            ArmorListUI ui = (ArmorListUI)detailList.getUI();
            index = ui.locationToRow(point);
        } else {
            index = detailList.getSelectedIndex();
        }
        return index;
    }
}

