/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener;

import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.CheckNode;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.dialogs.ReEvalDailog;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.PerformCard;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReEvalListener
implements ToolHyperLinkLabel.ClickListener {
    private static final long serialVersionUID = 7265720543808255602L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ReEvalListener.class);
    volatile boolean click = false;
    private PerformCard card = null;

    public ReEvalListener(PerformCard card) {
        this.card = card;
    }

    public void clickLink(MouseEvent me) {
        if (this.click) {
            return;
        }
        LOGGER.info("Click re-eval function.");
        this.click = true;
        if (FusionStorageEvalContext.getInstance().getTaskInfo().isPartPassed()) {
            ReEvalDailog dailog = new ReEvalDailog(FusionStorageEvalContext.getInstance().getMainDialog(), false);
            dailog.setVisible(true);
            if ("ALL".equals(dailog.getSelectRadio())) {
                LOGGER.info("Re-eval all nodes.");
                this.reEvalAllNode();
            } else if ("fail".equals(dailog.getSelectRadio())) {
                LOGGER.info("Re-eval faild nodes.");
                this.reEvalFailNode();
            }
        } else {
            WarningDialog warningDiag = DialogUtils.showYesNoDialog((Window)FusionStorageEvalContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"are.you.sure.about.to.rerun.all"), (boolean)true);
            if (0 == warningDiag.getValue()) {
                LOGGER.info("All nodes fail and re-eval all nodes.");
                this.reEvalAllNode();
            }
        }
        this.click = false;
    }

    public void reEvalAllNode() {
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        LinkedList<String> fsaIps = taskInfo.getExecuteNodes("Agent");
        LinkedList<String> fsmIps = taskInfo.getExecuteNodes("Manager");
        fsaIps.clear();
        fsmIps.clear();
        Collection<CheckNode> nodes = taskInfo.getCheckNodes().values();
        for (CheckNode checkNode : nodes) {
            if ("Manager".equals(checkNode.getType())) {
                fsmIps.add(checkNode.getIp());
                continue;
            }
            fsaIps.add(checkNode.getIp());
        }
        this.card.getEvalTask().setReExecuteType("all");
        new Thread(this.card.getEvalTask()).start();
    }

    public void reEvalFailNode() {
        ClusterEvalInfo taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        LinkedList<String> fsaIps = taskInfo.getExecuteNodes("Agent");
        LinkedList<String> fsmIps = taskInfo.getExecuteNodes("Manager");
        fsaIps.clear();
        fsmIps.clear();
        Collection<CheckNode> nodes = taskInfo.getCheckNodes().values();
        for (CheckNode checkNode : nodes) {
            if (EvalStatus.PASS.equals((Object)checkNode.getStatus())) continue;
            if ("Manager".equals(checkNode.getType())) {
                fsmIps.add(checkNode.getIp());
                continue;
            }
            fsaIps.add(checkNode.getIp());
        }
        this.card.getEvalTask().setReExecuteType("failed");
        new Thread(this.card.getEvalTask()).start();
    }
}

