/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener;

import com.huawei.ism.tool.base.utils.FilePathUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.SettingCardLayout;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.filechooser.ToolFileChooser;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import javax.swing.JDialog;
import javax.swing.JTextField;
import org.slf4j.Logger;
import utils.FilesUtil;

public class SelectPathListener
implements ActionListener {
    private static final Logger LOGGER = ToolLoggerFactory.getLogger(SelectPathListener.class);
    private SettingCardLayout layout;

    public SelectPathListener(SettingCardLayout layout) {
        this.layout = layout;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JDialog mainDialog = InspectContext.getInstance().getMainDialog();
        JTextField pathTextArea = this.layout.getResultPathField();
        Object oldPath = HibernateContainer.getInstance().get((Object)Constants.resultSaveId);
        String title = ResourceUtil.getString((String)"inspsctor.wizard.setresultsave.browspath");
        File defaultFile = new File(FilePathUtils.checkFile((String)pathTextArea.getText()));
        HashMap<String, String> expMap = new HashMap<String, String>();
        expMap.put("PathId", Constants.resultSaveId);
        expMap.put("title", title);
        expMap.put("description", ResourceUtil.getString((String)"systemconfig.logdump.folder"));
        File file = ToolFileChooser.selectFile((Window)mainDialog, (String[])new String[0], (int)1, (boolean)true, expMap);
        if (file == null) {
            return;
        }
        String dirPath = "";
        try {
            dirPath = file.getCanonicalPath();
            if (!FileUtils.isNormalPath((String)dirPath)) {
                DialogUtils.showInfoDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"the.file.path.contains.invalid.character"));
                oldPath = oldPath == null ? "" : oldPath;
                HibernateContainer.getInstance().put(Constants.resultSaveId, oldPath);
                LOGGER.warn(String.format(Locale.ROOT, "Select path %s invalid, reset path to %s", dirPath, oldPath));
                return;
            }
            if (!FileAssistant.checkDiskFreeSpace(file, 200)) {
                LOGGER.warn("The selected directory space is insufficient.");
                DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"setting.result.dir.remind", (Object[])new Object[]{200}));
                oldPath = oldPath == null ? "" : oldPath;
                HibernateContainer.getInstance().put(Constants.resultSaveId, oldPath);
                LOGGER.warn(String.format(Locale.ROOT, "Select path %s invalid, reset path to %s", dirPath, oldPath));
                return;
            }
            pathTextArea.setText(dirPath);
            File fileDestDir = new File(dirPath + File.separator + Constants.resultDirPrefix + this.getCurDateMills());
            if (!fileDestDir.exists() && !fileDestDir.mkdirs()) {
                String logStr = String.format(Locale.ENGLISH, "Make dir faild. dir is : %s", FilesUtil.getCanonicalPath((File)fileDestDir));
                LOGGER.warn(logStr);
            }
            FusionStorageEvalContext.getInstance().getTaskInfo().setResultDir(fileDestDir.getCanonicalPath());
        }
        catch (IOException e1) {
            LOGGER.error("file Canonical path error.", (Throwable)e1);
        }
        String logStr = String.format(Locale.ENGLISH, "Change inspection directory >> [ %s -> %s ] success.", FilesUtil.getCanonicalPath((File)defaultFile), dirPath);
        LOGGER.info(logStr);
    }

    private String getCurDateMills() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return dateFormat.format(new Date());
    }
}

