/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.ui.wizard.renderer;

import com.huawei.ism.tool.fusionstorage.common.FusionConstants;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.entity.DetailRecord;
import com.huawei.ism.tool.fusionstorage.eval.entity.EvalStatus;
import com.huawei.ism.tool.inspect.ui.componet.jlist.InspectListCellRenderer;
import com.huawei.ism.tool.inspect.ui.componet.jlist.ProgressBar;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.obase.utils.UiMethod;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DetailListRenderer
extends InspectListCellRenderer {
    private static final long serialVersionUID = 1930652707328128613L;

    @Override
    protected void handleRecord(Object value, JPanel viewPan) {
        DetailRecord rec = null;
        if (value instanceof DetailRecord) {
            rec = (DetailRecord)value;
        }
        if (rec == null) {
            return;
        }
        String date = StringUtils.formatDate((Object)rec.getDate(), (String)"yyyy-MM-dd HH:mm:ss");
        JLabel descLabel = new JLabel(rec.getMessage());
        JLabel statusLabel = this.initstatusLabel(rec);
        viewPan.setToolTipText(InspectContext.getInstance().getToolTip(rec.getMessage()));
        UiMethod.setComponentSize((Dimension)DESC_LABEL_SIZE, (Component[])new Component[]{descLabel});
        JComponent dateComp = UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{Box.createHorizontalStrut(5), new JLabel(date)});
        JComponent view = null;
        if (EvalStatus.EXECUTING.equals((Object)rec.getEvalStatus())) {
            ProgressBar bar = new ProgressBar(null, rec.getProgress(), dateComp, descLabel, statusLabel, Box.createGlue());
            if (0 != rec.getProgress()) {
                statusLabel.setText(statusLabel.getText() + " " + rec.getProgress() + "%");
            }
            view = bar;
        } else {
            statusLabel.setForeground(COLOR_BEFORE_CLICK);
            view = UCD.buildHorizotalBox(null, (Component[])new Component[]{dateComp, descLabel, statusLabel, Box.createGlue()});
        }
        viewPan.setLayout(new BorderLayout());
        viewPan.add((Component)view, "North");
    }

    private JLabel initstatusLabel(DetailRecord record) {
        JLabel statusLabel = new JLabel("");
        EvalStatus status = record.getEvalStatus();
        if (EvalStatus.EXECUTING.equals((Object)status)) {
            statusLabel.setText(ResourceUtil.getString((String)"perform.eval.execute"));
            statusLabel.setIcon(Constants.EVAL_RUNNING_IMGE);
        } else if (EvalStatus.PASS.equals((Object)status)) {
            statusLabel.setText(ResourceUtil.getString((String)"perform.eval.pass"));
            statusLabel.setIcon(Constants.PASS_IAMGE);
        } else if (EvalStatus.NOTPASS.equals((Object)status)) {
            statusLabel.setText(ResourceUtil.getString((String)"perform.eval.notpass"));
            statusLabel.setIcon(Constants.NOT_PASS_IAMGE);
        } else if (EvalStatus.FAILED.equals((Object)status)) {
            statusLabel.setText(ResourceUtil.getString((String)"perform.eval.node.failed"));
            statusLabel.setIcon(Constants.NOT_PASS_IAMGE);
        } else if (EvalStatus.OPTIMIZATION.equals((Object)status)) {
            statusLabel.setText(status.toString());
            statusLabel.setIcon(FusionConstants.OPTIMIZATION_IAMGE);
        } else if (EvalStatus.WAITING.equals((Object)status)) {
            statusLabel.setText(ResourceUtil.getString((String)"perform.eval.waiting"));
            statusLabel.setIcon(Constants.WAITING_IMGE);
        } else {
            statusLabel.setText("");
            statusLabel.setIcon(null);
        }
        return statusLabel;
    }
}

