/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.eval.utils;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EvalResourceUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EvalResourceUtil.class);
    private static final LanguageManager LANMAN = LanguageManager.getInstance();
    private static final String DEFAULT_STR = "--";
    private static final String RES_KEY_ERRORCODE = "errorcode_" + EvalResourceUtil.getResKeySuffix();
    private static final String RES_KEY_ITEM = "resource_" + EvalResourceUtil.getResKeySuffix();
    private static Map<String, Properties> propMap = new HashMap<String, Properties>();
    private static boolean topoInconsistentIgnoringSwitch = false;

    private static String getResKeySuffix() {
        return (Locale.ENGLISH.equals(LANMAN.getCurrentLanguage()) ? "en" : "zh") + ".properties";
    }

    public static String getItemDes(String key) {
        return EvalResourceUtil.getItemDes(key, LANMAN.getCurrentLanguage());
    }

    public static String getItemDesWithParams(String key, Object ... params) {
        String des = EvalResourceUtil.getItemDes(key, LANMAN.getCurrentLanguage());
        return MessageFormat.format(des, params);
    }

    private static String getItemDes(String key, Locale loc) {
        String resKey = RES_KEY_ITEM;
        Properties pr = EvalResourceUtil.getProperties(resKey);
        if (pr == null) {
            return DEFAULT_STR;
        }
        String des = pr.getProperty(key);
        if (StringUtils.isNULLStr((String)des)) {
            des = DEFAULT_STR;
        }
        return des;
    }

    public static String getErrorDes(String key) {
        return EvalResourceUtil.getErrorDes(key, LANMAN.getCurrentLanguage());
    }

    public static String getErrorDesWithParams(String key, Object ... params) {
        String des = EvalResourceUtil.getErrorDes(key, LANMAN.getCurrentLanguage());
        return MessageFormat.format(des, params);
    }

    private static String getErrorDes(String key, Locale loc) {
        String resLanKey = RES_KEY_ERRORCODE;
        Properties pr = EvalResourceUtil.getProperties(resLanKey);
        if (pr == null) {
            return DEFAULT_STR;
        }
        String des = pr.getProperty(key);
        if (StringUtils.isNULLStr((String)des)) {
            des = DEFAULT_STR;
        }
        return des;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getProperties(String key) {
        Properties properties = propMap.get(key);
        if (properties == null) {
            String propCfg = EvalResourceUtil.getPropertiesPath(key);
            FileInputStream in = null;
            Properties pr = new Properties();
            try {
                in = new FileInputStream(propCfg);
                pr.load(in);
            }
            catch (IOException e) {
                LOGGER.error(String.format(Locale.ENGLISH, "can not find resource : %s", propCfg));
            }
            finally {
                StreamUtils.closeStream(null, (InputStream)in);
            }
            propMap.put(key, pr);
        }
        return propMap.get(key);
    }

    private static String getPropertiesPath(String key) {
        return FusionStoragePackingService.getCurPackageRootDir() + "res" + File.separator + key;
    }

    public static boolean isTopoInconsistentIgnoringSwitch() {
        return topoInconsistentIgnoringSwitch;
    }

    static {
        try {
            ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
            topoInconsistentIgnoringSwitch = Boolean.valueOf(sysBundle.getString("topoInconsistentIgnoringSwitch"));
        }
        catch (Exception e) {
            LOGGER.warn("Init block error.", (Throwable)e);
        }
    }
}

