/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.inspect.ui.wizard.card;

import com.huawei.ism.tool.fusionstorage.entity.Product;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.inspect.ui.dialog.ShowSupportDialog;
import com.huawei.ism.tool.fusionstorage.inspect.ui.wizard.layout.InspectConnCardLayout;
import com.huawei.ism.tool.fusionstorage.inspect.util.FusionInspectUtil;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.ConnClusterCard;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.ConnClusterCardLayout;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.io.Serializable;
import java.util.Locale;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectConnCard
extends ConnClusterCard {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnClusterCard.class);
    private static final CardModelEnum CARD_MODE = CardModelEnum.FUSIONINSPECTCONNCLUSTER;

    public InspectConnCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.layout = new InspectConnCardLayout();
        this.addLayout(this.layout);
        this.bindListener();
    }

    @Override
    public void initData() {
        try {
            FusionInspectUtil.initSupportVersion();
        }
        catch (ToolException e) {
            DialogUtils.showInfoDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)e.getErrorLocaleDescription());
            Runtime.getRuntime().halt(-1);
        }
    }

    @Override
    protected void bindListener() {
        super.bindListener();
        ConnClusterCardLayout.getShowSupportLink().addClickListener((ToolHyperLinkLabel.ClickListener & Serializable)e -> new ShowSupportDialog(FusionStorageEvalContext.getInstance().getMainDialog()).setVisible(true));
    }

    public String getTitle() {
        return CARD_MODE.getTittle();
    }

    public int getStep() {
        return super.getStep(CARD_MODE);
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (this.verifyInput()) {
            this.initTaskInfo();
            if (this.queryDeviceInfo() && this.checkVersion()) {
                FusionStorageEvalContext.getInstance().getNodeResultMap().clear();
                return InspectUIUtil.getNextCard(CARD_MODE, this);
            }
        }
        return null;
    }

    private boolean checkVersion() {
        FusionStorageEvalContext context = FusionStorageEvalContext.getInstance();
        Product product = context.getSupportPorduct().get(this.taskInfo.getOriginalVersion());
        if (product == null) {
            LOGGER.error(String.format(Locale.ENGLISH, "Current version %s is not suppoerted.", this.taskInfo.getOriginalVersion()));
            DialogUtils.showInfoDialog((JDialog)context.getMainDialog(), (String)ResourceUtil.getStringWithParams((String)"added.fusionstorage.is.not.supported", (Object[])new Object[]{this.taskInfo.getOriginalVersion()}));
            return false;
        }
        try {
            FusionInspectUtil.initCheckItem(context.getSupportPorduct().get(this.taskInfo.getOriginalVersion()));
        }
        catch (ToolException e) {
            DialogUtils.showInfoDialog((JDialog)context.getMainDialog(), (String)e.getErrorLocaleDescription());
            return false;
        }
        this.taskInfo.setPackagePath(product.getPackagePath());
        this.taskInfo.setFsmUploadPath(product.getUploadPath());
        return true;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }
}

