/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.inspect.ui.wizard.card;

import com.huawei.ism.tool.base.utils.StreamUtils;
import com.huawei.ism.tool.fusionstorage.entity.FusionCheckItem;
import com.huawei.ism.tool.fusionstorage.entity.Product;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.fusionstorage.inspect.ui.wizard.layout.InspectSettingCardLayout;
import com.huawei.ism.tool.fusionstorage.ui.wizard.card.SettingCard;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.TreePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InspectSettingCard
extends SettingCard {
    private static final Logger LOGGER = LoggerFactory.getLogger(InspectSettingCard.class);
    private static final CardModelEnum CARD_MODE = CardModelEnum.FUSIONINSPECTSETTING;

    public InspectSettingCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.layout = new InspectSettingCardLayout();
        this.addLayout(this.layout);
        this.taskInfo = FusionStorageEvalContext.getInstance().getTaskInfo();
        this.setDefaultResultSavePath();
        this.bindListener();
    }

    protected void bindListener() {
        super.bindLisenter();
        final InspectSettingCardLayout settingCardLayout = (InspectSettingCardLayout)this.layout;
        settingCardLayout.getNodeTypeTree().addTreeSelectionListener(e -> {
            TreePath treePath = e.getPath();
            CheckTreeNode typeNode = (CheckTreeNode)treePath.getLastPathComponent();
            if ("FusionStorage".equals(typeNode.getUserObject().toString())) {
                return;
            }
            settingCardLayout.initItem(typeNode.getUserObject().toString());
        });
        settingCardLayout.getNodeTypeTree().setSelectionPath(new TreePath(settingCardLayout.getFsmNode().getPath()));
        settingCardLayout.getItemTree().getCellEditor().addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                this.syncSelectItem();
            }

            private void syncSelectItem() {
                Set selectNodes = settingCardLayout.getItemTree().getAllSelectedNodes(settingCardLayout.getItemRootNode());
                Set allNodes = settingCardLayout.getItemTree().getAllNodes(settingCardLayout.getItemRootNode());
                for (CheckTreeNode node : allNodes) {
                    Object userObj = node.getUserObject();
                    if (userObj instanceof FusionCheckItem) {
                        FusionCheckItem item = (FusionCheckItem)userObj;
                        item.setSelect(selectNodes.contains(node) || !node.isCheckEnable());
                    }
                    if (node.isCheckEnable()) continue;
                    node.setSelected(true);
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
                this.syncSelectItem();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void modifyFileContent() {
        FusionStorageEvalContext context = FusionStorageEvalContext.getInstance();
        Product product = context.getSupportPorduct().get(this.taskInfo.getOriginalVersion());
        Set<FusionCheckItem> fsmItems = product.getCheckItems().get("Manager");
        Set<FusionCheckItem> fsaItems = product.getCheckItems().get("Agent");
        HashSet<String> selectFsmItems = new HashSet<String>();
        HashSet<String> selectFsaItems = new HashSet<String>();
        for (FusionCheckItem item : fsmItems) {
            if (!item.isSelect()) continue;
            selectFsmItems.add(item.getId());
        }
        for (FusionCheckItem item : fsaItems) {
            if (!item.isSelect()) continue;
            selectFsaItems.add(item.getId());
        }
        HashMap<String, Set<String>> selectItems = new HashMap<String, Set<String>>();
        selectItems.put("Manager", selectFsmItems);
        selectItems.put("Agent", selectFsaItems);
        context.setCheckItemsNodeMapper(selectItems);
        String filePath = FusionStoragePackingService.getCurPackageRootDir() + File.separator + product.getPackagePath() + File.separator + FusionStoragePackingService.zipBallRootDir + File.separator + "package.cfg";
        Properties config = new Properties();
        FileReader reader = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                LOGGER.error("package.conf is not exsit.");
            }
            reader = new FileReader(file);
            config.load(reader);
            config.setProperty("ManagerCheckItems", String.join((CharSequence)",", selectFsmItems));
            config.setProperty("AgentCheckItems", String.join((CharSequence)",", selectFsaItems));
            this.taskInfo.setConfig(config);
            StreamUtils.closeResource(null, (Closeable)reader);
        }
        catch (Exception e) {
            LOGGER.error("modify conf failed.", (Throwable)e);
        }
        finally {
            StreamUtils.closeResource(null, reader);
        }
    }

    public String getTitle() {
        return CARD_MODE.getTittle();
    }

    public int getStep() {
        return super.getStep(CARD_MODE);
    }

    protected ToolWizardDialog.Card getNextCard() {
        if (!this.checkSelectItem()) {
            return null;
        }
        if (!this.resultDirCheck()) {
            return null;
        }
        this.modifyFileContent();
        this.taskInfo.initExecuteNodes();
        return InspectUIUtil.getNextCard(CARD_MODE, this);
    }

    private boolean checkSelectItem() {
        Product product = FusionStorageEvalContext.getInstance().getSupportPorduct().get(this.taskInfo.getOriginalVersion());
        Set<FusionCheckItem> fsmItems = product.getCheckItems().get("Manager");
        Set<FusionCheckItem> fsaItems = product.getCheckItems().get("Agent");
        JDialog mainDialog = FusionStorageEvalContext.getInstance().getMainDialog();
        boolean fsmItemEmpty = true;
        for (FusionCheckItem item : fsmItems) {
            if (!item.isSelect()) continue;
            fsmItemEmpty = false;
            break;
        }
        if (fsmItemEmpty) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"fusionstorage.inspect.item.manager.empty"));
            return false;
        }
        boolean fsaItemEmpty = true;
        for (FusionCheckItem item : fsaItems) {
            if (!item.isSelect()) continue;
            fsaItemEmpty = false;
            break;
        }
        if (fsaItemEmpty) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"fusionstorage.inspect.item.agent.empty"));
            return false;
        }
        return true;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        return true;
    }
}

