/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.inspect.ui.wizard.layout;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.fusionstorage.entity.FusionCheckItem;
import com.huawei.ism.tool.fusionstorage.entity.Product;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.SettingCardLayout;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckBoxTree;
import com.huawei.ism.tool.obase.ui.component.checkboxtree.CheckTreeNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class InspectSettingCardLayout
extends SettingCardLayout {
    private static final int NODE_PAN_WIDTH = 255;
    private static final int PAN_HEIGHT_SINGLE = 360;
    private static final int PAN_HEIGHT_DOUBLE = 330;
    private static final int ITEM_PAN_WIDTH = 370;
    private static final List<String> DEFAULT_CHOSE_ITEMS = Arrays.asList(ResourceBundle.getBundle("config.inspect").getString("fusion.storage.block.default.chosen.items").split(","));
    private JComponent rightPan;
    private JComponent leftPan;
    private CheckTreeNode itemRootFather = new CheckTreeNode();
    private CheckTreeNode itemRootNode;
    private CheckTreeNode nodeTypeRootNode;
    private CheckBoxTree itemTree;
    private JTree nodeTypeTree;
    private JScrollPane itemScroll;
    private JScrollPane nodeScroll;
    private CheckTreeNode fsmNode;
    private JLabel itemTypeLabel = new JLabel(ResourceUtil.getStringWithParams((String)"fusionstorage.inspect.item.select", (Object[])new Object[]{"Manager"}));
    private String lastType = "";

    public void initData() {
        this.initTree();
        this.itemScroll.setBorder(BorderFactory.createEtchedBorder());
        this.nodeScroll.setBorder(BorderFactory.createEtchedBorder());
    }

    public InspectSettingCardLayout() {
        this.setLayout(new BorderLayout());
        JComponent box = this.initUI();
        this.add((Component)box, "North");
    }

    public JComponent initUI() {
        JComponent resultDirSelector = this.initResultDirSaveComponent();
        JComponent clusterInfo = this.initClusterInfo();
        JComponent treePan = this.initTree();
        this.setComponentSize();
        return UCD.buildVerticalBox(null, (int)12, (Component[])new Component[]{UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHBoxLeft((Component[])new Component[]{clusterInfo}), treePan}), UCD.buildHBoxLeft((Component[])new Component[]{resultDirSelector}), Box.createVerticalStrut(10)});
    }

    public JComponent initTree() {
        this.initLeftTree();
        this.nodeScroll = new JScrollPane();
        int panHeight = ClusterMode.SINGLE.equals((Object)this.clusterEvalInfo.getMode()) ? 360 : 330;
        UiMethod.setComponentSize((Dimension)new Dimension(255, panHeight), (Component[])new Component[]{this.nodeScroll});
        this.leftPan = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)this.nodeScroll, (int)4)});
        this.leftPan = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)new JLabel(ResourceUtil.getString((String)"fusionstorage.inspect.nodetype.desc"))), this.leftPan});
        this.nodeScroll.setViewportView(this.nodeTypeTree);
        this.initRightTree();
        this.itemScroll = new JScrollPane();
        UiMethod.setComponentSize((Dimension)new Dimension(370, panHeight), (Component[])new Component[]{this.itemScroll});
        this.rightPan = UCD.buildVerticalBox(null, (Component[])new Component[]{UiMethod.buildFrameSpace((JComponent)this.itemScroll, (int)4)});
        this.rightPan = UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)this.itemTypeLabel), this.rightPan});
        this.itemScroll.setViewportView((Component)this.itemTree);
        return UCD.buildHorizotalBox(null, (int)8, (Component[])new Component[]{this.leftPan, this.rightPan});
    }

    public void initLeftTree() {
        this.nodeTypeRootNode = new CheckTreeNode((Object)"FusionStorage", true, false);
        this.fsmNode = new CheckTreeNode((Object)"Manager", false, false);
        this.nodeTypeRootNode.add((MutableTreeNode)this.fsmNode);
        this.nodeTypeRootNode.add((MutableTreeNode)new CheckTreeNode((Object)"Agent", false, false));
        CheckTreeNode nodeRoot = new CheckTreeNode();
        nodeRoot.add((MutableTreeNode)this.nodeTypeRootNode);
        DefaultTreeModel nodeModel = new DefaultTreeModel((TreeNode)nodeRoot, true);
        this.nodeTypeTree = new CheckBoxTree(nodeRoot, false);
        this.nodeTypeTree.setModel(nodeModel);
        this.nodeTypeTree.setShowsRootHandles(true);
        this.nodeTypeTree.expandPath(new TreePath(this.nodeTypeRootNode.getPath()));
    }

    public void initRightTree() {
        this.itemRootNode = new CheckTreeNode();
        this.itemTree = new CheckBoxTree(this.itemRootFather, true);
        this.initItem("Manager");
        this.itemTree.setShowsRootHandles(true);
    }

    public void initItem(String type) {
        if (!"Manager".equals(type) && !"Agent".equals(type)) {
            return;
        }
        if (this.lastType == type) {
            return;
        }
        this.lastType = type;
        this.itemTypeLabel.setText(ResourceUtil.getStringWithParams((String)"fusionstorage.inspect.item.select", (Object[])new Object[]{type}));
        this.itemRootFather.removeAllChildren();
        this.itemRootNode.removeAllChildren();
        this.itemRootNode.setUserObject((Object)ResourceUtil.getString((String)"fusionstorage.inspect.item.root.desc"));
        this.itemRootNode.setAllowsChildren(true);
        this.itemRootFather.add((MutableTreeNode)this.itemRootNode);
        Product p = FusionStorageEvalContext.getInstance().getSupportPorduct().get(FusionStorageEvalContext.getInstance().getTaskInfo().getOriginalVersion());
        Set<String> keySet = p.getCheckItems().keySet();
        for (String key : keySet) {
            if (type != key) continue;
            Set<FusionCheckItem> items = p.getCheckItems().get(key);
            for (FusionCheckItem item : items) {
                CheckTreeNode node = new CheckTreeNode();
                this.itemRootNode.add((MutableTreeNode)node);
                node.setUserObject((Object)item);
                node.setHasCheckBox(true);
                node.setCheckEnable(!DEFAULT_CHOSE_ITEMS.contains(item.getId()));
                node.setSelected(item.isSelect() || DEFAULT_CHOSE_ITEMS.contains(item.getId()));
                node.setAllowsChildren(false);
            }
        }
        DefaultTreeModel itemModel = new DefaultTreeModel((TreeNode)this.itemRootFather, true);
        this.itemTree.setModel((TreeModel)itemModel);
        this.itemTree.expandPath(new TreePath(this.itemRootNode.getPath()));
    }

    @Override
    protected void setComponentSize() {
        if (this.clusterEvalInfo.getMode().equals((Object)ClusterMode.DOUBLE)) {
            UCD.setSameWidth((JComponent[])new JComponent[]{secndNodeIpLabel, priNodeIpLabel, fsmOriginalVerLabel, this.clutserDetailLable});
        } else {
            UCD.setSameWidth((JComponent[])new JComponent[]{priNodeIpLabel, fsmOriginalVerLabel, this.clutserDetailLable});
        }
    }

    @Override
    protected JComponent initTopComponent() {
        return null;
    }

    public CheckBoxTree getItemTree() {
        return this.itemTree;
    }

    public JTree getNodeTypeTree() {
        return this.nodeTypeTree;
    }

    public CheckTreeNode getItemRootNode() {
        return this.itemRootNode;
    }

    public String getLastType() {
        return this.lastType;
    }

    public CheckTreeNode getFsmNode() {
        return this.fsmNode;
    }
}

