/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.inspect.util;

import com.huawei.ism.tool.fusionstorage.entity.FusionCheckItem;
import com.huawei.ism.tool.fusionstorage.entity.Product;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.service.impl.FusionStoragePackingService;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.StreamUtils;
import com.huawei.ism.tool.obase.utils.XmlUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FusionInspectUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FusionInspectUtil.class);

    public static void initSupportVersion() throws ToolException {
        File suppertConfig = new File(FusionStoragePackingService.getCurPackageRootDir() + File.separator + "FusionSysConf.xml");
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(suppertConfig);
            Document doc = XmlUtils.parseDocument((InputStream)inputStream);
            NodeList list = XmlUtils.searchNodeByExp((Document)doc, (String)"products/product");
            FusionInspectUtil.initProduct(list);
        }
        catch (Exception e) {
            LOGGER.error("Parse sysconf error.", (Throwable)e);
            throw new ToolException("fusionstorage.inspect.version.parse.error");
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
    }

    private static void initProduct(NodeList nodeList) throws ToolException {
        if (nodeList == null) {
            LOGGER.warn("Node List is empty");
            throw new ToolException("fusionstorage.inspect.version.parse.error");
        }
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String[] vers;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element productEle = (Element)node;
            Product product = new Product();
            Element productModelEle = XmlUtils.getChild((Element)productEle, (String)"productmodel");
            product.setProductModel(productModelEle.getTextContent().trim());
            Element packagePathEle = XmlUtils.getChild((Element)productEle, (String)"packagePath");
            product.setPackagePath(packagePathEle.getTextContent().trim());
            Element supportVersionsEle = XmlUtils.getChild((Element)productEle, (String)"supportversions");
            product.setSuppoertversions(supportVersionsEle.getTextContent().trim());
            for (String ver : vers = product.getSuppoertversions().split(",")) {
                FusionStorageEvalContext.getInstance().getSupportPorduct().put(ver.trim(), product);
            }
            Element uploadPathEle = XmlUtils.getChild((Element)productEle, (String)"uploadpath");
            product.setUploadPath(uploadPathEle.getTextContent().trim());
            Element checkListEle = XmlUtils.getChild((Element)productEle, (String)"checklist");
            product.setCheckList(checkListEle.getTextContent().trim());
        }
    }

    public static void initCheckItem(Product pro) throws ToolException {
        File checkItemXml = new File(FusionStoragePackingService.getCurPackageRootDir() + File.separator + pro.getPackagePath() + File.separator + pro.getCheckList());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(checkItemXml);
            Document doc = XmlUtils.parseDocument((InputStream)inputStream);
            NodeList list = XmlUtils.searchNodeByExp((Document)doc, (String)"checkItems/checkItem");
            FusionInspectUtil.initCheckItem(list, pro);
        }
        catch (Exception e) {
            throw new ToolException("fusion.storage.business.package.broken");
        }
        finally {
            StreamUtils.closeStream(null, (InputStream)inputStream);
        }
    }

    private static void initCheckItem(NodeList nodeList, Product pro) throws ToolException {
        if (nodeList == null) {
            LOGGER.warn("Checkitem node list is empty");
            throw new ToolException("fusionstorage.inspect.version.parse.error");
        }
        Map<String, Set<FusionCheckItem>> checkItems = pro.getCheckItems();
        HashSet<FusionCheckItem> managerCheckItems = new HashSet<FusionCheckItem>();
        HashSet<FusionCheckItem> agentCheckItems = new HashSet<FusionCheckItem>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            FusionCheckItem item;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element checkItem = (Element)node;
            String id = checkItem.getAttribute("id");
            String supportNodeTypes = checkItem.getAttribute("supportNodeTypes");
            if (supportNodeTypes.contains("Manager")) {
                item = new FusionCheckItem();
                item.setId(id);
                managerCheckItems.add(item);
            }
            if (!supportNodeTypes.contains("Agent")) continue;
            item = new FusionCheckItem();
            item.setId(id);
            agentCheckItems.add(item);
        }
        pro.getCheckItems().put("Manager", managerCheckItems);
        pro.getCheckItems().put("Agent", agentCheckItems);
    }
}

