/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.ui.wizard.card;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.service.deviceadd.DeviceAddService;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.layout.EvalSelectDeviceLayout;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.ClusterModeChangeListener;
import com.huawei.ism.tool.fusionstorage.eval.utils.EvalResourceUtil;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.ConnClusterCardLayout;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.ErrorDialog;
import com.huawei.ism.ui.swing.dialog.ProgressDialog;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.util.SwingUtil;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConnClusterCard
extends InspectCard {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnClusterCard.class);
    protected ClusterEvalInfo taskInfo = null;
    protected ConnClusterCardLayout layout;

    public ConnClusterCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
    }

    protected void bindListener() {
        ConnClusterCardLayout.getMode().addItemListener(new ClusterModeChangeListener(this.layout));
    }

    protected boolean verifyInput() {
        this.layout.initChcekInput();
        JDialog main = FusionStorageEvalContext.getInstance().getMainDialog();
        if (!SwingUtil.validateInput(this.layout.getTextCheckedInput(), (Window)main)) {
            return false;
        }
        return SwingUtil.validatePwdInput(this.layout.getPwdCheckedInput(), (Window)main);
    }

    protected boolean queryDeviceInfo() {
        DeviceAddService addService = new DeviceAddService(this.taskInfo);
        List resluts = AsyncExcutor.execute((ProgressDialog)addService.getProgressDialog(), (boolean)true, (long)0L, (Callable[])new Callable[]{addService});
        for (Object result : resluts) {
            if (result instanceof TaskResult) {
                TaskResult taskResult = (TaskResult)result;
                if ("No trusted certificate found".equals(taskResult.getErrorId())) {
                    ErrorDialog errorDialog = DialogUtils.showErrorDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"fusionstorage.eval.conn.cert.verify.faled.tips"));
                    errorDialog.setAlwaysOnTop(true);
                }
                if (!TaskResult.Result.FAILED.equals((Object)taskResult.getResult())) continue;
                DialogUtils.showInfoDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)taskResult.getErrorLocaleDescription());
                return false;
            }
            LOGGER.error("query device info unknow error.", result);
            return false;
        }
        Set<String> topoNotExis = FusionStorageEvalContext.getInstance().getTopoNotExistNodes();
        Set<String> detailNotExistNodes = FusionStorageEvalContext.getInstance().getDetailsNotExistNodes();
        if (topoNotExis.isEmpty() && detailNotExistNodes.isEmpty()) {
            return true;
        }
        if (InspectUtils.isFusionInspect() || EvalResourceUtil.isTopoInconsistentIgnoringSwitch()) {
            WarningDialog warn;
            String nodeInfoStr;
            ArrayList<String> erroMsgList = new ArrayList<String>();
            String splitStr = ResourceUtil.getString((String)"splitStr");
            if (!topoNotExis.isEmpty()) {
                nodeInfoStr = this.getNodeInfoStr(topoNotExis, splitStr);
                erroMsgList.add(ResourceUtil.getStringWithParams((String)"fsa.node.detail.notmatch.topo", (Object[])new Object[]{nodeInfoStr, topoNotExis.size()}));
            }
            if (!detailNotExistNodes.isEmpty()) {
                nodeInfoStr = this.getNodeInfoStr(detailNotExistNodes, splitStr);
                erroMsgList.add(ResourceUtil.getStringWithParams((String)"fsa.node.detail.notmatch.topo2", (Object[])new Object[]{nodeInfoStr, detailNotExistNodes.size()}));
            }
            return 0 == (warn = DialogUtils.showYesNoDialog((Window)FusionStorageEvalContext.getInstance().getMainDialog(), (String)(String.join((CharSequence)"\r\n", erroMsgList) + ResourceUtil.getString((String)"fsa.node.detail.notmatch.topo.continue.msg")))).getValue();
        }
        this.showErroDialog(topoNotExis, detailNotExistNodes);
        return false;
    }

    private String getNodeInfoStr(Set<String> topoNotExis, String splitStr) {
        String nodeInfoStr = String.join((CharSequence)splitStr, topoNotExis);
        if (nodeInfoStr.length() > 100) {
            nodeInfoStr = nodeInfoStr.substring(0, 100) + "......";
        }
        return nodeInfoStr;
    }

    private void showErroDialog(Set<String> topoNotExis, Set<String> detailNotExistNodes) {
        ArrayList<String> erroMsgList = new ArrayList<String>();
        String splitStr = ",";
        if (!topoNotExis.isEmpty()) {
            erroMsgList.add(ResourceUtil.getStringWithParams((String)"fsa.node.detail.notmatch.topo", (Object[])new Object[]{String.join((CharSequence)splitStr, topoNotExis), topoNotExis.size()}));
        }
        if (!detailNotExistNodes.isEmpty()) {
            erroMsgList.add(ResourceUtil.getStringWithParams((String)"fsa.node.detail.notmatch.topo2", (Object[])new Object[]{String.join((CharSequence)splitStr, detailNotExistNodes), detailNotExistNodes.size()}));
        }
        DialogUtils.showInfoDialog((JDialog)FusionStorageEvalContext.getInstance().getMainDialog(), (String)(String.join((CharSequence)"\r\n", erroMsgList) + ResourceUtil.getString((String)"fsa.node.detail.notmatch.topo.error.msg")));
    }

    protected void initTaskInfo() {
        this.taskInfo = new ClusterEvalInfo();
        FusionStorageEvalContext.getInstance().setTaskInfo(this.taskInfo);
        this.taskInfo.setMode((ClusterMode)((Object)EvalSelectDeviceLayout.getMode().getSelectedItem()));
        this.taskInfo.setFloatIp(this.layout.getFloatIpAddrField().getText());
        this.taskInfo.setGatewayUserName(this.layout.getFloatUserNameField().getText());
        this.taskInfo.setGatewayPasswd(new String(this.layout.getFloatPwdField().getPassword()));
        this.taskInfo.setRestPort(this.layout.getFloatPortField().getText());
        this.taskInfo.setVerifyCertificate(this.layout.getYesAndNoButtonPanel().isSelectedYes());
        this.initPriNodeInfo();
        if (ClusterMode.DOUBLE.equals((Object)this.taskInfo.getMode())) {
            this.initStandbyNodeInfo();
        }
    }

    protected void initPriNodeInfo() {
        DevNode primaryNode = new DevNode();
        this.taskInfo.setPrimaryNode(primaryNode);
        User user = new User(this.layout.getPriUserNameField().getText(), new String(this.layout.getPriPwdField().getPassword()));
        primaryNode.setLoginUser(user);
        User rootUser = new User("root", Base64EncodeUtils.encode((String)new String(this.layout.getPriRootPwdField().getPassword())));
        primaryNode.setRootUser(rootUser);
        primaryNode.setPort(Integer.parseInt(this.layout.getPriPortField().getText()));
    }

    protected void initStandbyNodeInfo() {
        DevNode standbyNode = new DevNode();
        this.taskInfo.setStandbyNode(standbyNode);
        User user = new User(this.layout.getStandbyUserNameField().getText(), new String(this.layout.getStandbyPwdField().getPassword()));
        standbyNode.setLoginUser(user);
        User rootUser = new User("root", Base64EncodeUtils.encode((String)new String(this.layout.getStandbyRootPwdField().getPassword())));
        standbyNode.setRootUser(rootUser);
        standbyNode.setPort(Integer.parseInt(this.layout.getStandbyPortField().getText()));
    }
}

