/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.ui.wizard.card;

import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterMode;
import com.huawei.ism.tool.fusionstorage.eval.entity.FsaNode;
import com.huawei.ism.tool.fusionstorage.eval.service.PerformCardUiUpdateService;
import com.huawei.ism.tool.fusionstorage.eval.service.evaltask.ExecuteTask;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.DetailListListener;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.OpenFileListener;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.PerformTableSelectionListener;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.ReEvalListener;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.PerformCardLayout;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.ui.swing.dialog.WarningDialog;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.DefaultTableRow;
import com.huawei.ism.ui.swing.table.IsmTableCell;
import com.huawei.ism.ui.swing.table.TableRow;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.event.ListSelectionListener;

public class PerformCard
extends InspectCard {
    private static final CardModelEnum CARD_MODE_EVAL = CardModelEnum.EVALPERFORM;
    private static final CardModelEnum CARD_MODE_INSPECT = CardModelEnum.FUSIONINSPECTPERFORM;
    private PerformCardLayout layout = new PerformCardLayout();
    private FusionStorageEvalContext context = FusionStorageEvalContext.getInstance();
    private PerformCardUiUpdateService uiService = null;
    private ExecuteTask evalTask = null;
    private static final long serialVersionUID = 3296900593770212337L;

    public PerformCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
        this.addLayout(this.layout);
    }

    @Override
    public void initData() {
        this.updateDeviceTable();
        this.uiService = new PerformCardUiUpdateService(this);
        this.bindListener();
        this.evalTask = new ExecuteTask(this.uiService, this.context.getTaskInfo());
        new Thread(this.evalTask).start();
    }

    private void bindListener() {
        this.layout.getTable().addListSelectionListener((ListSelectionListener)new PerformTableSelectionListener(this));
        this.layout.getDetailList().addMouseListener(new DetailListListener(this.layout));
        this.layout.getReEvalLink().addClickListener((ToolHyperLinkLabel.ClickListener)new ReEvalListener(this));
        this.layout.getViewReport().addClickListener((ToolHyperLinkLabel.ClickListener)new OpenFileListener(Constants.REPORT_TEMP_DIR + File.separator + "index.html"));
        this.layout.getOpenResultLink().addClickListener((ToolHyperLinkLabel.ClickListener)new OpenFileListener(this.context.getTaskInfo().getResultDir()));
    }

    public void updateDeviceTable() {
        DefaultTableModel tableModel = this.layout.getTableModel();
        ClusterEvalInfo evalInfo = this.context.getTaskInfo();
        List<TableRow> rows = this.createRow(evalInfo);
        tableModel.addRow(rows);
        this.layout.getTable().selectFirstRow();
    }

    public void initNodeStatus(Object[] nodeIds) {
        List rows = null;
        rows = nodeIds == null ? this.layout.getTableModel().getAllRows() : this.layout.getTableModel().getTableRows(nodeIds);
        for (TableRow row : rows) {
            IsmTableCell.IconCell statCell = (IsmTableCell.IconCell)row.getValueAt(3);
            statCell.setIcon((Icon)Constants.WAITING_IMGE);
            statCell.setDescription(ResourceUtil.getString((String)"perform.node.stat"));
        }
    }

    private List<TableRow> createRow(ClusterEvalInfo evalInfo) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        DevNode primaryNode = evalInfo.getPrimaryNode();
        rows.add(this.createFsmRow(primaryNode));
        if (ClusterMode.DOUBLE.equals((Object)evalInfo.getMode())) {
            rows.add(this.createFsmRow(evalInfo.getStandbyNode()));
        }
        Collection<FsaNode> fsaNodes = evalInfo.getFsaNodes().values();
        for (FsaNode fsaNode : fsaNodes) {
            DefaultTableRow row = new DefaultTableRow(this.layout.getTableHeader().length, (Object)fsaNode, (Object)fsaNode.getSn());
            IsmTableCell.IconCell statCell = new IsmTableCell.IconCell((Icon)Constants.WAITING_IMGE, ResourceUtil.getString((String)"perform.node.stat"));
            row.setValueAt(0, (Object)fsaNode.getName());
            row.setValueAt(1, (Object)"Agent");
            row.setValueAt(2, (Object)fsaNode.getIp());
            row.setValueAt(3, (Object)statCell);
            rows.add((TableRow)row);
        }
        return rows;
    }

    private TableRow createFsmRow(DevNode node) {
        DefaultTableRow row = new DefaultTableRow(this.layout.getTableHeader().length, (Object)node, (Object)node.getDeviceSerialNumber());
        IsmTableCell.IconCell statCell = new IsmTableCell.IconCell((Icon)Constants.WAITING_IMGE, ResourceUtil.getString((String)"perform.node.stat"));
        row.setValueAt(0, (Object)node.getDeviceName());
        row.setValueAt(1, (Object)"Manager");
        row.setValueAt(2, (Object)node.getIp());
        row.setValueAt(3, (Object)statCell);
        return row;
    }

    public PerformCardUiUpdateService getUiService() {
        return this.uiService;
    }

    public ExecuteTask getEvalTask() {
        return this.evalTask;
    }

    public PerformCardLayout getCardLayout() {
        return this.layout;
    }

    public String getTitle() {
        if (InspectUtils.isFusionEval() || InspectUtils.isFusionCubeEval()) {
            return CARD_MODE_EVAL.getTittle();
        }
        return CARD_MODE_INSPECT.getTittle();
    }

    public int getStep() {
        if (InspectUtils.isFusionEval() || InspectUtils.isFusionCubeEval()) {
            return super.getStep(CARD_MODE_EVAL);
        }
        return super.getStep(CARD_MODE_INSPECT);
    }

    protected ToolWizardDialog.Card getNextCard() {
        return null;
    }

    protected boolean isValid(ToolWizardDialog.Navigation navigation) {
        if (ToolWizardDialog.Navigation.Previous.equals((Object)navigation) || ToolWizardDialog.Navigation.Complete.equals((Object)navigation)) {
            if (this.evalTask == null) {
                return false;
            }
            return this.evalTask.isFinish();
        }
        return true;
    }

    protected boolean process(ToolWizardDialog.Navigation navigation) {
        WarningDialog dialog = null;
        if (ToolWizardDialog.Navigation.Complete.equals((Object)navigation) && 0 != (dialog = DialogUtils.showYesNoDialog((Window)FusionStorageEvalContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"perform.close.tip"))).getValue()) {
            FusionStorageEvalContext.getInstance().getMainDialog().setDefaultCloseOperation(0);
            return false;
        }
        return true;
    }

    public void scrollDetailListBottoms() {
        this.uiService.scrollDetailListBottoms();
    }
}

