/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.ui.wizard.card;

import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.common.FusionStorageEvalContext;
import com.huawei.ism.tool.fusionstorage.eval.common.SceneDataFetcher;
import com.huawei.ism.tool.fusionstorage.eval.entity.ClusterEvalInfo;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.SelectPathListener;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.listener.ShowNodeTopoListener;
import com.huawei.ism.tool.fusionstorage.ui.wizard.layout.SettingCardLayout;
import com.huawei.ism.tool.inspect.entity.CardModelEnum;
import com.huawei.ism.tool.inspect.ui.wizard.InspectCard;
import com.huawei.ism.tool.inspect.utils.FileAssistant;
import com.huawei.ism.tool.obase.filechooser.HibernateContainer;
import com.huawei.ism.tool.obase.ui.component.wizard.ToolWizardDialog;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.obase.utils.FileUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SettingCard
extends InspectCard {
    protected static final long serialVersionUID = -7592951366783632289L;
    protected static final CardModelEnum CARDMODE = CardModelEnum.EVALSETTING;
    private static final Logger LOGGER = LoggerFactory.getLogger(SettingCard.class);
    protected ClusterEvalInfo taskInfo;
    protected SettingCardLayout layout;

    public SettingCard(ToolWizardDialog.Card arg0, ToolWizardDialog.Navigation[] arg1) {
        super(arg0, arg1);
    }

    protected void bindLisenter() {
        this.layout.getSavePathButton().addActionListener(new SelectPathListener(this.layout));
        this.layout.getShowMoreLink().addMouseListener((MouseListener)new ShowNodeTopoListener());
    }

    protected void setDefaultResultSavePath() {
        String defaultPath;
        Object defaultPathObj = HibernateContainer.getInstance().get((Object)Constants.resultSaveId);
        String string = defaultPath = defaultPathObj != null ? defaultPathObj.toString() : null;
        if (!StringUtils.isNULLStr((String)defaultPath)) {
            File filePath = new File(defaultPath);
            String deepistDir = null;
            deepistDir = filePath.getParent() == null ? defaultPath : defaultPath.substring(filePath.getParent().length());
            boolean isMatched = Pattern.compile(Constants.resultDirPrefix).matcher(deepistDir).find();
            if (isMatched) {
                defaultPath = filePath.getParent();
                filePath = new File(defaultPath);
            }
            if (!filePath.exists()) {
                filePath.mkdirs();
            }
            String dirPath = "";
            try {
                dirPath = filePath.getCanonicalPath();
                this.layout.getResultPathField().setText(dirPath);
            }
            catch (IOException e) {
                dirPath = defaultPath;
                this.layout.getResultPathField().setText(defaultPath);
            }
            this.layout.getResultPathField().setToolTipText(defaultPath);
            this.layout.getResultPathField().setCaretPosition(0);
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
            String dateSuffix = dateFormat.format(new Date());
            String destPath = dirPath + File.separator + Constants.resultDirPrefix + dateSuffix;
            File fileDestDir = new File(destPath);
            if (!fileDestDir.exists()) {
                fileDestDir.mkdirs();
            }
            FusionStorageEvalContext.getInstance().getTaskInfo().setResultDir(destPath);
            return;
        }
        this.setFusionStorageEvalContext();
    }

    private void setFusionStorageEvalContext() {
        String scenePath = SceneDataFetcher.getSceneResultPath();
        if (!StringUtils.isNULLStr((String)scenePath) && !FileUtils.isNormalPath((String)scenePath)) {
            scenePath = ApplicationContext.getInstance().getUserDataPath();
        }
        if (!StringUtils.isNULLStr((String)scenePath)) {
            this.layout.getResultPathField().setText(scenePath);
            this.layout.getResultPathField().setToolTipText(scenePath);
            this.layout.getResultPathField().setCaretPosition(0);
            File fileDestDir = new File(scenePath);
            if (!fileDestDir.exists()) {
                fileDestDir.mkdirs();
            }
            FusionStorageEvalContext.getInstance().getTaskInfo().setResultDir(scenePath);
            return;
        }
    }

    protected boolean resultDirCheck() {
        JDialog mainDialog = FusionStorageEvalContext.getInstance().getMainDialog();
        String resultDir = FusionStorageEvalContext.getInstance().getTaskInfo().getResultDir();
        if (StringUtils.isNULLStr((String)resultDir)) {
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"target.dir.not.valid"));
            return false;
        }
        File file = new File(resultDir);
        if (!file.exists() && !file.mkdirs() || !file.canWrite()) {
            LOGGER.error(String.format(Locale.ENGLISH, "Result dir not exists or can not write. dir : %s", resultDir));
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getString((String)"setting.result.dir.permission.check"));
            return false;
        }
        if (!FileAssistant.checkDiskFreeSpace(file, 200)) {
            LOGGER.warn("The selected directory space is insufficient.");
            DialogUtils.showInfoDialog((JDialog)mainDialog, (String)ResourceUtil.getStringWithParams((String)"setting.result.dir.remind", (Object[])new Object[]{200}));
            return false;
        }
        return true;
    }

    protected abstract void modifyFileContent();
}

