/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.fusionstorage.ui.wizard.layout;

import com.huawei.ism.tool.base.ui.UiMethod;
import com.huawei.ism.tool.fusionstorage.eval.common.Constants;
import com.huawei.ism.tool.fusionstorage.eval.ui.wizard.renderer.DetailListRenderer;
import com.huawei.ism.tool.inspect.ui.componet.jlist.ProgressBar;
import com.huawei.ism.tool.obase.ui.component.ToolHyperLinkLabel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.IsmListModel;
import com.huawei.ism.ui.swing.table.DefaultTableModel;
import com.huawei.ism.ui.swing.table.IsmTable;
import com.huawei.ism.ui.swing.table.TableScrollPane;
import com.huawei.ism.util.UCD;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.table.TableModel;

public class PerformCardLayout
extends JPanel {
    private static final long serialVersionUID = 1999337213166562187L;
    private static final int STEP_PANEL_LINE = 2;
    private static final int TABLE_MIN_HEIGHT = 60;
    private static final int TABLE_SPLIT_LOC = 260;
    private static final int LINE_HIGHT = 20;
    private static final int MAX_WIGHT = 640;
    private static final Dimension PRO_BAR_DIMENSION = new Dimension(640, 20);
    private static Map<Integer, ImageIcon> statusIconMap = new HashMap<Integer, ImageIcon>();
    private static LinkedList<Step> topSteps = new LinkedList();
    JSplitPane splitPane = null;
    private ProgressBar progressBar = null;
    private JLabel progressBarDes = new JLabel();
    private JLabel timeDes = new JLabel(ResourceUtil.getStringWithParams((String)"perform.enval.progress.usetime", (Object[])new Object[]{0, 0, 0}));
    private String[] tableHeader = new String[]{ResourceUtil.getString((String)"perform.table.head.name"), ResourceUtil.getString((String)"perform.table.head.type"), ResourceUtil.getString((String)"perform.table.head.ip"), ResourceUtil.getString((String)"perform.table.head.stat")};
    private DefaultTableModel tableModel = new DefaultTableModel(this.tableHeader, new int[0]);
    private IsmTable table = new IsmTable((TableModel)this.tableModel);
    private TableScrollPane tableScrollPane = new TableScrollPane(this.table);
    private JList detailList = new JList(new IsmListModel());
    private JScrollPane detailScrollPane = new JScrollPane(this.detailList);
    private JComponent buttomComponent = null;
    private JLabel buttomDes = new JLabel();
    private ToolHyperLinkLabel openResultLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"perform.result.opendir"));
    private ToolHyperLinkLabel viewReport = new ToolHyperLinkLabel(ResourceUtil.getString((String)"perform.result.viewreport"));
    private ToolHyperLinkLabel reEvalLink = new ToolHyperLinkLabel(ResourceUtil.getString((String)"perform.eval.reeval"));

    public PerformCardLayout() {
        this.setLayout(new BorderLayout());
        JComponent box = this.initUI();
        this.add((Component)box, "Center");
    }

    private JComponent initUI() {
        JComponent view = null;
        view = this.initStepPanel(topSteps);
        this.progressBar = this.initProgressBar();
        this.splitPane = this.initTablePane();
        this.buttomComponent = UCD.buildHorizotalBox(null, (Component[])new Component[]{UCD.buildHorizontalBoxLeft((Component)this.buttomDes), UiMethod.buildCompsRight((int)12, (Component[])new Component[]{this.reEvalLink, this.openResultLink, this.viewReport})});
        view = UCD.buildVerticalBox(null, (int)10, (Component[])new Component[]{view, UCD.buildHBoxLeft((Component[])new Component[]{this.progressBar})});
        view = UCD.buildVerticalBox(null, (Component[])new Component[]{view, UCD.buildHBoxLeft((Component[])new Component[]{this.splitPane}), this.buttomComponent});
        return view;
    }

    private JSplitPane initTablePane() {
        this.tableScrollPane.getFilterFiled().setClearSelection(false);
        this.detailList.setCellRenderer(new DetailListRenderer());
        this.detailList.setSelectionMode(0);
        JSplitPane split = new JSplitPane(0, true);
        split.setTopComponent((Component)this.tableScrollPane);
        split.setBottomComponent(this.detailScrollPane);
        split.setDividerLocation(260);
        this.tableScrollPane.setMinimumSize(new Dimension(this.tableScrollPane.getPreferredSize().width, 60));
        split.setBorder(null);
        return split;
    }

    private JComponent initStepPanel(LinkedList<Step> steps) {
        JPanel panel = new JPanel();
        GridLayout lay = new GridLayout(2, steps.size(), 0, 0);
        panel.setLayout(lay);
        panel.setPreferredSize(new Dimension(640, 50));
        panel.setMaximumSize(new Dimension(640, 50));
        this.initStep();
        for (Step step : steps) {
            if (steps.getLast().equals((Object)step)) {
                panel.add(UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{step.getImg(), UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(8), step.getSubLine(), Box.createVerticalStrut(8)}), Step.FINISH.getImg()}));
                break;
            }
            panel.add(UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{step.getImg(), UCD.buildVerticalBox(null, (int)0, (Component[])new Component[]{Box.createVerticalStrut(8), step.getSubLine(), Box.createVerticalStrut(8)})}));
        }
        for (Step step : steps) {
            if (steps.getLast().equals((Object)step)) {
                panel.add(UCD.buildHorizotalBox(null, (int)0, (Component[])new Component[]{step.getStepDes(), Box.createGlue(), Step.FINISH.getStepDes()}));
                break;
            }
            panel.add(UCD.buildHBoxLeft((int)0, (Component[])new Component[]{step.getStepDes()}));
        }
        return UCD.buildHBoxCentert((int)0, (Component[])new Component[]{panel});
    }

    private ProgressBar initProgressBar() {
        ProgressBar bar = new ProgressBar(Constants.COLOR_DONE, Constants.COLOR_TODO, 0, UCD.buildHBoxLeft((Component[])new Component[]{Box.createHorizontalStrut(4), this.progressBarDes}), UCD.buildHBoxRight((Component[])new Component[]{this.timeDes, Box.createHorizontalStrut(4)}));
        this.timeDes.setForeground(Color.WHITE);
        bar.setPreferredSize(PRO_BAR_DIMENSION);
        return bar;
    }

    public DefaultTableModel getTableModel() {
        return this.tableModel;
    }

    public IsmTable getTable() {
        return this.table;
    }

    public void setTable(IsmTable table) {
        this.table = table;
    }

    public JList getDetailList() {
        return this.detailList;
    }

    public String[] getTableHeader() {
        return this.tableHeader;
    }

    public JLabel getButtomDes() {
        return this.buttomDes;
    }

    public static Map<Integer, ImageIcon> getStatusIconMap() {
        return statusIconMap;
    }

    public ProgressBar getProgressBar() {
        return this.progressBar;
    }

    public ToolHyperLinkLabel getReEvalLink() {
        return this.reEvalLink;
    }

    public JScrollPane getDetailScrollPane() {
        return this.detailScrollPane;
    }

    public void initStep() {
        for (Step step : topSteps) {
            step.setStat(0);
            step.getImg().setIcon(statusIconMap.get(step.getStat()));
            step.getSubLine().setBackground(Constants.COLOR_TODO);
            step.getSubLine().setForeground(Constants.COLOR_TODO);
        }
        Step.FINISH.setStat(0);
        Step.FINISH.getImg().setIcon(statusIconMap.get(Step.FINISH.getStat()));
        Step.FINISH.getSubLine().setBackground(Constants.COLOR_TODO);
        Step.FINISH.getSubLine().setForeground(Constants.COLOR_TODO);
    }

    public ToolHyperLinkLabel getOpenResultLink() {
        return this.openResultLink;
    }

    public ToolHyperLinkLabel getViewReport() {
        return this.viewReport;
    }

    public JLabel getTimeDes() {
        return this.timeDes;
    }

    static {
        statusIconMap.put(0, Constants.TODO_IMGE);
        statusIconMap.put(1, Constants.RUNNING_IAMGE);
        statusIconMap.put(2, Constants.PASS_IAMGE);
        statusIconMap.put(3, Constants.NOT_PASS_IAMGE);
        topSteps.add(Step.UPLOAD);
        topSteps.add(Step.EXECUTE);
        topSteps.add(Step.POST);
    }

    public static enum Step {
        UPLOAD(ResourceUtil.getString((String)"perform.step.upload")),
        EXECUTE(ResourceUtil.getString((String)"perform.step.execute")),
        POST(ResourceUtil.getString((String)"perform.step.post")),
        FINISH(ResourceUtil.getString((String)"perform.step.finish"));

        private int stat = 0;
        JLabel stepDes = new JLabel();
        JLabel img = new JLabel();
        JComponent subLine = this.getLine();

        private Step(String des) {
            this.img.setIcon((Icon)statusIconMap.get(this.stat));
            this.stepDes.setText(des);
        }

        public JLabel getStepDes() {
            return this.stepDes;
        }

        public int getStat() {
            return this.stat;
        }

        public Step setStat(int status) {
            this.stat = status;
            return this;
        }

        private JComponent getLine() {
            JSeparator separator = new JSeparator();
            separator.setForeground(Constants.COLOR_TODO);
            separator.setBackground(Constants.COLOR_TODO);
            return separator;
        }

        public JLabel getImg() {
            return this.img;
        }

        public void setStepDes(String des) {
            this.stepDes.setText(des);
        }

        public JComponent getSubLine() {
            return this.subLine;
        }
    }
}

