/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.bmcconn.redfish;

import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.uMate.common.rest.RedfishConnestion;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class BmcRedfishConnManagement {
    private static ConcurrentHashMap<String, RedfishConnestion> connectionPool = new ConcurrentHashMap();

    private BmcRedfishConnManagement() {
    }

    public static RedfishConnestion getRedFishConnection(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getBmcNode() == null) {
            return null;
        }
        String poolKey = BmcRedfishConnManagement.getPoolKey(clusterNode);
        if (connectionPool.containsKey(poolKey) && connectionPool.get(poolKey) != null) {
            return connectionPool.get(poolKey);
        }
        return BmcRedfishConnManagement.createRedFishConnector(clusterNode);
    }

    public static void releaseConnection(DevNode devNode) {
        if (devNode == null) {
            return;
        }
        List clusterNodes = devNode.getClusterNodes();
        if (clusterNodes == null) {
            return;
        }
        clusterNodes.stream().forEach(node -> BmcRedfishConnManagement.releaseConnection(node));
    }

    public static void releaseConnection(ClusterNode clusterNode) {
        if (clusterNode == null || clusterNode.getBmcNode() == null) {
            return;
        }
        String poolKey = BmcRedfishConnManagement.getPoolKey(clusterNode);
        if (connectionPool.containsKey(poolKey) && connectionPool.get(poolKey) != null) {
            connectionPool.get(poolKey).release();
            connectionPool.remove(poolKey);
        }
    }

    private static RedfishConnestion createRedFishConnector(ClusterNode clusterNode) {
        RedfishConnestion restConn = new RedfishConnestion(clusterNode.getBmcNode().getIp(), clusterNode.getBmcNode().getRedFishPort(), clusterNode.getBmcNode().getLoginUser().getUserName(), clusterNode.getBmcNode().getLoginUser().getPassword());
        restConn.connect();
        connectionPool.put(BmcRedfishConnManagement.getPoolKey(clusterNode), restConn);
        return restConn;
    }

    private static String getPoolKey(ClusterNode clusterNode) {
        return clusterNode.getManagementIp() + "_" + clusterNode.getBmcNode().getIp();
    }
}

