/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.checker;

import com.huawei.ism.tool.inspect.checker.InspectPreChecker;
import com.huawei.ism.tool.inspect.ui.logic.AdanceCompileRemotePyScript;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.PreInspectUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import com.huawei.tool.framwork.util.func.LocalHostUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DpaDevicePreChecker
implements InspectPreChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DpaDevicePreChecker.class);

    @Override
    public void doPreCheck(List<DevNode> selectDevs, List<DevNode> allDevs) throws ToolException {
        List<DevNode> dpaDevices = this.getDpaDevices(selectDevs);
        if (dpaDevices.isEmpty()) {
            return;
        }
        List<Object> result = new ArrayList<Object>();
        try {
            File reuqireCheckPyFile = this.getReuqireCheckPyFile(dpaDevices);
            File scriptFolder = reuqireCheckPyFile.getParentFile();
            JythonExecuter jythonExecuter = this.getJythonExecuter(scriptFolder);
            try {
                jythonExecuter.compileScript(reuqireCheckPyFile);
            }
            catch (Exception e) {
                log.error("compile remote python script error", (Throwable)e);
            }
            result = jythonExecuter.invokeFunction("execute", new Object[]{dpaDevices, selectDevs, allDevs});
        }
        catch (ToolException e) {
            log.error("get py script error.", (Throwable)e);
        }
        this.checkCanContinue(result);
    }

    private JythonExecuter getJythonExecuter(File scriptFolder) {
        JythonExecuter jythonExecuter = PreInspectUtil.getJythonExecuter(scriptFolder);
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("isInSvp", LocalHostUtil.isRunInSvp());
        env.put("allStrgHyprMtrLns", InspectContext.getInstance().getAllStrgHyprMtrLns());
        env.put("objectForPy", InspectContext.getInstance().getObjectForPy());
        env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        env.put("hostLauncherWwnList", InspectContext.getInstance().getHostLauncherWwnList());
        jythonExecuter.set("py_java_env", env);
        return jythonExecuter;
    }

    private File getReuqireCheckPyFile(List<DevNode> dpaDevices) throws ToolException {
        String pyScriptFilePath = InspectContext.getInstance().getProductByDevNode(dpaDevices.get(0)).getRequireCheckFile();
        return new File(AdanceCompileRemotePyScript.BASE_PATH, pyScriptFilePath);
    }

    @NotNull
    private List<DevNode> getDpaDevices(List<DevNode> selectDevs) {
        return selectDevs.stream().filter(devNode -> devNode.getProductModel().toLowerCase(Locale.ENGLISH).contains("cdm")).collect(Collectors.toList());
    }

    private void checkCanContinue(List<Object> result) throws ToolException {
        if (result.size() < 2) {
            return;
        }
        Object resultObject = result.get(0);
        if (resultObject instanceof Boolean && !Boolean.TRUE.equals((Boolean)resultObject)) {
            throw new ToolException(String.valueOf(result.get(1)), false);
        }
    }
}

