/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.checker;

import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.inspect.checker.ProductLoadService;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.InspectPreCheckFailedInfo;
import com.huawei.ism.tool.inspect.ui.componet.observer.ProcessStepObserver;
import com.huawei.ism.tool.inspect.utils.InspectAsyncThreadFactory;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductLoadServiceImpl<T>
implements ProductLoadService<InspectPreCheckFailedInfo> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProductLoadServiceImpl.class);
    private final ProcessStepObserver processStepObserver;
    private final InspectWorktaker workTaker;

    @Override
    public Optional<InspectPreCheckFailedInfo> loadProduct(List<DevNode> allDevs) throws ToolException {
        log.info("start load products.....");
        Future<Object> queryResult = ProductLoadServiceImpl.loadProducts(this.workTaker, allDevs, this.processStepObserver);
        if (this.processStepObserver.isDisplayable()) {
            this.processStepObserver.setVisible(true);
        }
        return this.checkLoadResult(queryResult);
    }

    @NotNull
    private static Future<Object> loadProducts(InspectWorktaker workTaker, List<DevNode> allDevs, ProcessStepObserver progressDialog) {
        return AsyncExcutor.submit(InspectAsyncThreadFactory.buildQueryDevStatusCallable(workTaker, progressDialog, allDevs));
    }

    private boolean judgeIfDevSnChange(DevNode node) {
        return "sn_change_err".equals(node.getErrorDecs());
    }

    private void handleFailedNodes() throws ToolException {
        List<DevNode> preFailRet = this.workTaker.getExceptionNodes();
        if (!CollectionUtil.isEmpty(this.workTaker.getCheckDevNodes()) && preFailRet.isEmpty()) {
            return;
        }
        String snChangeDevIps = preFailRet.stream().filter(this::judgeIfDevSnChange).map(DevNode::getIp).collect(Collectors.joining(", "));
        if (StringUtils.isNULLStr((String)snChangeDevIps)) {
            String errorIps = preFailRet.stream().map(DevNode::getIp).collect(Collectors.joining(","));
            throw new ToolException("inspsctor.wizard.selectdevice.loadconfig.error", new Object[]{errorIps});
        }
        throw new ToolException("inspsctor.wizard.selectdevice.dstoage.sn.change", new Object[]{snChangeDevIps});
    }

    private Optional<InspectPreCheckFailedInfo> checkLoadResult(Future<Object> queryResult) throws ToolException {
        Object result = ProductLoadServiceImpl.getResult(queryResult);
        this.checkResult(result);
        ProductLoadServiceImpl.checkExpansionSceneResult();
        this.handleFailedNodes();
        return result instanceof InspectPreCheckFailedInfo ? Optional.of((InspectPreCheckFailedInfo)result) : Optional.empty();
    }

    private static void checkExpansionSceneResult() throws ToolException {
        if (!InspectUtils.isPreExpEvaluation().booleanValue()) {
            return;
        }
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        if (Objects.isNull(devInfo)) {
            throw new ToolException("inspect.wizard.strategysetting.getinfo.error");
        }
        if (!devInfo.isSuccess()) {
            throw new ToolException(devInfo.getErrMsg(), false);
        }
        String expType = InspectContext.getInstance().getExpScene();
        if ("expCtrl".equals(expType) && CollectionUtil.isEmpty(devInfo.getExpSpec())) {
            throw new ToolException(devInfo.getErrMsg(), false);
        }
    }

    private void checkResult(Object result) throws ToolException {
        if (Objects.isNull(result)) {
            return;
        }
        if (result instanceof ToolException) {
            throw (ToolException)((Object)result);
        }
        if (result instanceof Exception) {
            throw new ToolException("inspsctor.wizard.selectdevice.loadconfigerror");
        }
    }

    private static Object getResult(Future<Object> fu) throws ToolException {
        try {
            return fu.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.error("get load result failed.", (Throwable)e);
            throw new ToolException("inspsctor.wizard.selectdevice.loadconfigerror");
        }
    }

    @Generated
    public ProductLoadServiceImpl(ProcessStepObserver processStepObserver, InspectWorktaker workTaker) {
        this.processStepObserver = processStepObserver;
        this.workTaker = workTaker;
    }
}

