/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.checker;

import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.inspect.checker.InspectPreChecker;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SceneSupportDeviceChecker
implements InspectPreChecker {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SceneSupportDeviceChecker.class);

    @Override
    public void doPreCheck(List<DevNode> selectDevs, List<DevNode> allDevs) throws ToolException {
        this.checkDataValid(selectDevs);
        this.checkWithExpansionScene(selectDevs);
        this.checkSceneSupportDevice(selectDevs);
    }

    private void checkSceneSupportDevice(List<DevNode> selectDevs) throws ToolException {
        boolean isRealTimedCheck;
        String selectScene = InspectContext.getInstance().getSelectSeceneInSecondCard();
        boolean bl = isRealTimedCheck = selectScene.contains("realTimed_check") && this.sceneContainDeviceType(selectScene);
        if (!isRealTimedCheck) {
            return;
        }
        if (selectDevs.stream().anyMatch(node -> !selectScene.contains(node.getItDeviceType().getName()))) {
            throw new ToolException("inspect.wizard.selectScene.fromPage2to1");
        }
    }

    private boolean sceneContainDeviceType(String selectScene) {
        return selectScene.contains(ItDeviceType.Storage.getName()) || selectScene.contains(ItDeviceType.T3000.getName()) || selectScene.contains(ItDeviceType.UltraPath.getName());
    }

    private void checkWithExpansionScene(List<DevNode> selectDevs) throws ToolException {
        if (!InspectUtils.isPreExpEvaluation().booleanValue()) {
            return;
        }
        if (selectDevs.stream().noneMatch(node -> ItDeviceType.Storage.equals((Object)node.getItDeviceType()))) {
            throw new ToolException("inspsctor.wizard.selectdevice.host.check");
        }
    }

    private void checkDataValid(List<DevNode> selectDevs) throws ToolException {
        if (this.isDetachCheckAndHasNotDsStorage(selectDevs)) {
            throw new ToolException("inspsctor.wizard.detach.check.only.distribute.storage");
        }
        if (!this.checkHostHasNoHyperDevice(selectDevs) && !InspectUtils.isDpaInspectScene()) {
            throw new ToolException("inspsctor.wizard.selectdevice.host.check");
        }
    }

    private boolean isDetachCheckAndHasNotDsStorage(List<DevNode> selectDevs) {
        if (!InspectContext.getInstance().isDetachCheck()) {
            return false;
        }
        return !selectDevs.stream().allMatch(DevNode::isDsStorage);
    }

    private boolean checkHostHasNoHyperDevice(List<DevNode> selectDevs) {
        if (selectDevs.size() == 1) {
            return selectDevs.get(0).getItDeviceType() != ItDeviceType.Host;
        }
        for (DevNode devNode : selectDevs) {
            if (!ItDeviceType.Host.equals((Object)devNode.getItDeviceType())) continue;
            return this.checkIsHyperMetro(devNode, selectDevs);
        }
        return true;
    }

    private boolean checkIsHyperMetro(DevNode devNode, List<DevNode> selectDevs) {
        for (DevNode node : selectDevs) {
            if (!node.isHyperMetro() || node == devNode) continue;
            return true;
        }
        return false;
    }
}

