/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.ui.logic.Strategy;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.A800Node;
import com.huawei.ism.tool.obase.entity.AiDevNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DmeNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import java.awt.Window;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class A800ExpansionDiskInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(A800ExpansionDiskInfo.class);
    @ExcelProperty(index=0)
    private String zoneId = "";
    @ExcelProperty(index=1)
    private String engineId;
    @ExcelProperty(index=2)
    private String poolId;
    @ExcelProperty(index=3)
    private String diskBom;
    @ExcelProperty(index=4)
    private String diskNum;
    @ExcelProperty(index=5)
    private String diskType;
    @ExcelProperty(index=6)
    private double diskCapacity;
    @ExcelProperty(index=7)
    private String capacityUnit;
    private int excelRowIndex;
    private String errMsg = "";

    public static List<HashMap<String, String>> getTargetZoneDiskList4PyScript(CheckDevNode checkDevNode, List<A800ExpansionDiskInfo> data) {
        String devZoneId = checkDevNode.getDevNodeSafe().getUuid();
        return A800ExpansionDiskInfo.getTargetZoneDiskList4PyScript(devZoneId, data);
    }

    private static List<HashMap<String, String>> getTargetZoneDiskList4PyScript(String zoneId, List<A800ExpansionDiskInfo> data) {
        return data.stream().filter(expInfo -> expInfo.getZoneId().equals(zoneId)).map(expInfo -> {
            HashMap<String, String> oneRowInfo = new HashMap<String, String>();
            oneRowInfo.put("diskModel", expInfo.getDiskType());
            oneRowInfo.put("eng", expInfo.getEngineId());
            oneRowInfo.put("pool", expInfo.getPoolId());
            oneRowInfo.put("diskCapacity", Double.toString(expInfo.getDiskCapacity()));
            oneRowInfo.put("unit", expInfo.getCapacityUnit());
            oneRowInfo.put("diskNum", expInfo.getDiskNum());
            oneRowInfo.put("diskBom", expInfo.getDiskBom());
            return oneRowInfo;
        }).collect(Collectors.toList());
    }

    @Generated
    public String toString() {
        return "A800ExpansionDiskInfo(zoneId=" + this.getZoneId() + ", engineId=" + this.getEngineId() + ", poolId=" + this.getPoolId() + ", diskBom=" + this.getDiskBom() + ", diskNum=" + this.getDiskNum() + ", diskType=" + this.getDiskType() + ", diskCapacity=" + this.getDiskCapacity() + ", capacityUnit=" + this.getCapacityUnit() + ", excelRowIndex=" + this.getExcelRowIndex() + ", errMsg=" + this.getErrMsg() + ")";
    }

    @Generated
    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    @Generated
    public void setEngineId(String engineId) {
        this.engineId = engineId;
    }

    @Generated
    public void setPoolId(String poolId) {
        this.poolId = poolId;
    }

    @Generated
    public void setDiskBom(String diskBom) {
        this.diskBom = diskBom;
    }

    @Generated
    public void setDiskNum(String diskNum) {
        this.diskNum = diskNum;
    }

    @Generated
    public void setDiskType(String diskType) {
        this.diskType = diskType;
    }

    @Generated
    public void setDiskCapacity(double diskCapacity) {
        this.diskCapacity = diskCapacity;
    }

    @Generated
    public void setCapacityUnit(String capacityUnit) {
        this.capacityUnit = capacityUnit;
    }

    @Generated
    public void setExcelRowIndex(int excelRowIndex) {
        this.excelRowIndex = excelRowIndex;
    }

    @Generated
    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    @Generated
    public String getZoneId() {
        return this.zoneId;
    }

    @Generated
    public String getEngineId() {
        return this.engineId;
    }

    @Generated
    public String getPoolId() {
        return this.poolId;
    }

    @Generated
    public String getDiskBom() {
        return this.diskBom;
    }

    @Generated
    public String getDiskNum() {
        return this.diskNum;
    }

    @Generated
    public String getDiskType() {
        return this.diskType;
    }

    @Generated
    public double getDiskCapacity() {
        return this.diskCapacity;
    }

    @Generated
    public String getCapacityUnit() {
        return this.capacityUnit;
    }

    @Generated
    public int getExcelRowIndex() {
        return this.excelRowIndex;
    }

    @Generated
    public String getErrMsg() {
        return this.errMsg;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof A800ExpansionDiskInfo)) {
            return false;
        }
        A800ExpansionDiskInfo other = (A800ExpansionDiskInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getDiskCapacity(), other.getDiskCapacity()) != 0) {
            return false;
        }
        if (this.getExcelRowIndex() != other.getExcelRowIndex()) {
            return false;
        }
        String this$zoneId = this.getZoneId();
        String other$zoneId = other.getZoneId();
        if (this$zoneId == null ? other$zoneId != null : !this$zoneId.equals(other$zoneId)) {
            return false;
        }
        String this$engineId = this.getEngineId();
        String other$engineId = other.getEngineId();
        if (this$engineId == null ? other$engineId != null : !this$engineId.equals(other$engineId)) {
            return false;
        }
        String this$poolId = this.getPoolId();
        String other$poolId = other.getPoolId();
        if (this$poolId == null ? other$poolId != null : !this$poolId.equals(other$poolId)) {
            return false;
        }
        String this$diskBom = this.getDiskBom();
        String other$diskBom = other.getDiskBom();
        if (this$diskBom == null ? other$diskBom != null : !this$diskBom.equals(other$diskBom)) {
            return false;
        }
        String this$diskNum = this.getDiskNum();
        String other$diskNum = other.getDiskNum();
        if (this$diskNum == null ? other$diskNum != null : !this$diskNum.equals(other$diskNum)) {
            return false;
        }
        String this$diskType = this.getDiskType();
        String other$diskType = other.getDiskType();
        if (this$diskType == null ? other$diskType != null : !this$diskType.equals(other$diskType)) {
            return false;
        }
        String this$capacityUnit = this.getCapacityUnit();
        String other$capacityUnit = other.getCapacityUnit();
        if (this$capacityUnit == null ? other$capacityUnit != null : !this$capacityUnit.equals(other$capacityUnit)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        return !(this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof A800ExpansionDiskInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $diskCapacity = Double.doubleToLongBits(this.getDiskCapacity());
        result = result * 59 + (int)($diskCapacity >>> 32 ^ $diskCapacity);
        result = result * 59 + this.getExcelRowIndex();
        String $zoneId = this.getZoneId();
        result = result * 59 + ($zoneId == null ? 43 : $zoneId.hashCode());
        String $engineId = this.getEngineId();
        result = result * 59 + ($engineId == null ? 43 : $engineId.hashCode());
        String $poolId = this.getPoolId();
        result = result * 59 + ($poolId == null ? 43 : $poolId.hashCode());
        String $diskBom = this.getDiskBom();
        result = result * 59 + ($diskBom == null ? 43 : $diskBom.hashCode());
        String $diskNum = this.getDiskNum();
        result = result * 59 + ($diskNum == null ? 43 : $diskNum.hashCode());
        String $diskType = this.getDiskType();
        result = result * 59 + ($diskType == null ? 43 : $diskType.hashCode());
        String $capacityUnit = this.getCapacityUnit();
        result = result * 59 + ($capacityUnit == null ? 43 : $capacityUnit.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        return result;
    }

    public static class A800ExpansionDiskInfoDataValidator
    extends AnalysisEventListener<A800ExpansionDiskInfo> {
        private final List<A800ExpansionDiskInfo> invalidData = new ArrayList<A800ExpansionDiskInfo>();
        private final List<A800ExpansionDiskInfo> validData = new ArrayList<A800ExpansionDiskInfo>();

        @NonNull
        private static Set<String> getZoneIds() {
            return DefaultNodeProviderImpl.getInstance().getNodeList().stream().filter(AiDevNode.class::isInstance).map(AiDevNode.class::cast).findAny().get().getA800Nodes().stream().filter(DmeNode::isSelect).map(A800Node::getZones).flatMap(Collection::stream).map(DevNode::getUuid).collect(Collectors.toSet());
        }

        private static List<List<String>> transInvalidData2ShowData(A800ExpansionDiskInfoDataValidator listener) {
            return listener.getInvalidData().stream().map(data -> {
                ArrayList<String> rowData = new ArrayList<String>();
                rowData.add(data.getExcelRowIndex() + "");
                rowData.add(data.getErrMsg());
                return rowData;
            }).collect(Collectors.toList());
        }

        private static void checkDiskType(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            if (StringUtils.isNULLStr((String)expansionDiskInfo.getDiskType())) {
                throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.diskUnit.errMsg", new Object[]{expansionDiskInfo.getDiskType()});
            }
        }

        private static void checkDiskNum(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            int diskNumInt;
            String diskNumStr = expansionDiskInfo.getDiskNum();
            if (NumberUtils.isDigits((String)diskNumStr) && (diskNumInt = Integer.parseInt(diskNumStr)) > 0) {
                return;
            }
            throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.diskNum.errMsg", new Object[]{expansionDiskInfo.getDiskNum()});
        }

        private static void checkDiskCapacityUnit(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            if (Arrays.stream(Strategy.Unit.values()).noneMatch(unit -> unit.name().equals(expansionDiskInfo.getCapacityUnit()))) {
                throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.diskUnit.errMsg", new Object[]{expansionDiskInfo.getCapacityUnit()});
            }
        }

        private static void checkCapacity(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            if (expansionDiskInfo.diskCapacity <= 0.0) {
                throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.diskCapacity.errMsg", new Object[]{expansionDiskInfo.getDiskCapacity()});
            }
        }

        private static void checkPoolId(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            int poolIdInt;
            String poolIdStr = expansionDiskInfo.getPoolId();
            if (NumberUtils.isDigits((String)poolIdStr) && (poolIdInt = Integer.parseInt(poolIdStr)) >= 0) {
                return;
            }
            throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.poolId.errMsg", new Object[]{expansionDiskInfo.getPoolId()});
        }

        private static void checkEngineId(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            int engineIdInt;
            String engineIdStr = expansionDiskInfo.getEngineId();
            if (NumberUtils.isDigits((String)engineIdStr) && (engineIdInt = Integer.parseInt(engineIdStr)) >= 0 && engineIdInt <= 15) {
                return;
            }
            throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.engineId.errMsg", new Object[]{expansionDiskInfo.getEngineId()});
        }

        private static void checkZoneId(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            int zoneIdInt;
            String zoneIdStr = expansionDiskInfo.getZoneId();
            if (NumberUtils.isDigits((String)zoneIdStr) && (zoneIdInt = Integer.parseInt(zoneIdStr)) >= 0 && zoneIdInt <= 63) {
                return;
            }
            throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.zoneid.errMsg", new Object[]{expansionDiskInfo.getZoneId()});
        }

        public void invoke(A800ExpansionDiskInfo expansionDiskInfo, AnalysisContext analysisContext) {
            try {
                this.validData(expansionDiskInfo);
            }
            catch (ToolException e) {
                expansionDiskInfo.setErrMsg(e.getErrorLocaleDescription());
                expansionDiskInfo.setExcelRowIndex(analysisContext.readRowHolder().getRowIndex() + 1);
                this.invalidData.add(expansionDiskInfo);
                return;
            }
            this.validData.add(expansionDiskInfo);
        }

        public void doAfterAllAnalysed(AnalysisContext analysisContext) {
            if (this.invalidData.isEmpty()) {
                return;
            }
            log.warn("invalid expansion data {}", this.invalidData);
            DialogUtils.showMultiErrorDialogNoIgnoreButton((Window)InspectContext.getInstance().getMainDialog(), (String)ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfoDataValidator.dialog.desc"), (String[])new String[]{ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfoDataValidator.table.head1"), ResourceUtil.getString((String)"inspsctor.wizard.A800ExpansionDiskInfoDataValidator.table.head2")}, A800ExpansionDiskInfoDataValidator.transInvalidData2ShowData(this));
        }

        private void validData(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            A800ExpansionDiskInfoDataValidator.checkZoneId(expansionDiskInfo);
            A800ExpansionDiskInfoDataValidator.checkEngineId(expansionDiskInfo);
            A800ExpansionDiskInfoDataValidator.checkPoolId(expansionDiskInfo);
            A800ExpansionDiskInfoDataValidator.checkCapacity(expansionDiskInfo);
            this.checkDiskBom(expansionDiskInfo);
            A800ExpansionDiskInfoDataValidator.checkDiskCapacityUnit(expansionDiskInfo);
            A800ExpansionDiskInfoDataValidator.checkDiskNum(expansionDiskInfo);
            A800ExpansionDiskInfoDataValidator.checkDiskType(expansionDiskInfo);
        }

        private void checkDiskBom(A800ExpansionDiskInfo expansionDiskInfo) throws ToolException {
            if (this.isBomInvalid(expansionDiskInfo.getDiskBom())) {
                throw new ToolException("inspsctor.wizard.A800ExpansionDiskInfo.bom.errMsg", new Object[]{expansionDiskInfo.getDiskBom()});
            }
        }

        private boolean isBomInvalid(String bom) {
            if (bom == null) {
                return true;
            }
            String[] bomList = bom.split(",");
            String pattern = "(?![0-9]{8})(?![a-zA-Z]{8})[0-9A-Za-z]{8}";
            for (String bomNum : bomList) {
                if (bomNum.matches(pattern)) continue;
                return true;
            }
            return false;
        }

        @Generated
        public List<A800ExpansionDiskInfo> getInvalidData() {
            return this.invalidData;
        }

        @Generated
        public List<A800ExpansionDiskInfo> getValidData() {
            return this.validData;
        }
    }
}

