/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class BureauDocuConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String COMMA = ",";
    private String name;
    private List<String> types = new ArrayList<String>();
    private List<String> versions = new ArrayList<String>();
    private String url;
    private String defaultName;
    private String localResource;

    public BureauDocuConfig addName(String configName) {
        this.name = configName;
        return this;
    }

    public BureauDocuConfig addTypes(List<String> devTypes) {
        if (devTypes == null || devTypes.isEmpty()) {
            return this;
        }
        this.types.addAll(devTypes);
        return this;
    }

    public BureauDocuConfig addType(String devType) {
        if (StringUtils.isNULLStr((String)devType)) {
            return this;
        }
        this.types.add(devType);
        return this;
    }

    public BureauDocuConfig addVersions(List<String> devVersions) {
        if (devVersions == null || devVersions.isEmpty()) {
            return this;
        }
        this.versions.addAll(devVersions);
        return this;
    }

    public BureauDocuConfig addUrl(String devUrl) {
        if (StringUtils.isNULLStr((String)devUrl)) {
            return this;
        }
        this.url = devUrl;
        return this;
    }

    public BureauDocuConfig addDefaultName(String configDefaultName) {
        this.defaultName = configDefaultName;
        return this;
    }

    public BureauDocuConfig addLocalResource(String configLocalResource) {
        this.localResource = configLocalResource;
        return this;
    }

    public boolean containType(String type) {
        if (StringUtils.isNULLStr((String)type)) {
            return false;
        }
        return this.types.contains(type);
    }

    public boolean containVersion(String version) {
        if (StringUtils.isNULLStr((String)version)) {
            return false;
        }
        return this.versions.contains(version);
    }

    public boolean versionContains(String version) {
        if (StringUtils.isNULLStr((String)version)) {
            return false;
        }
        for (String ver : this.versions) {
            if (!version.contains(ver)) continue;
            return true;
        }
        return false;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public String getUrl() {
        return this.url;
    }

    public List<String> getVersions() {
        return this.versions;
    }

    public String getVersionsString() {
        StringBuilder res = new StringBuilder();
        if (this.versions.isEmpty()) {
            return res.toString();
        }
        res.append(this.versions.get(0));
        for (int index = 1; index < this.versions.size(); ++index) {
            res.append(COMMA);
            res.append(this.versions.get(index));
        }
        return res.toString();
    }

    public String getDefaultName() {
        return this.defaultName;
    }

    public String getLocalResource() {
        return this.localResource;
    }

    public String getName() {
        return this.name;
    }
}

