/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.DiskDomain;
import com.huawei.ism.tool.inspect.entity.DstorageSceneCheckItems;
import com.huawei.ism.tool.inspect.entity.Enclosure;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public class CheckDevNode
implements Serializable {
    private static final long serialVersionUID = 1968712972752857252L;
    private static final int NUM_HUNDRED = 100;
    private static final int NUM_30 = 30;
    private static final float NUM_HUNDRED_FLOAT = 100.0f;
    private transient Map<String, List<CheckItem>> checkItems = new KeyOrderedHashMap();
    private transient List<DstorageSceneCheckItems> dstorageSceneCheckItemsList = new ArrayList<DstorageSceneCheckItems>();
    private transient List<CheckDevNode> childrens = new ArrayList<CheckDevNode>();
    private Product product;
    private transient DevNode devNode;
    private boolean viewAble = true;
    private String nodeName;
    private String targetVersion;
    private File scriptDir;
    private transient ResourceBundle resourceBundle;
    private transient ResourceBundle expansionResource;
    private transient ResourceBundle switchResource;
    private boolean executeSuc;
    private boolean isStop = false;
    private File resuleTmpFile;
    private boolean integration;
    private Calendar startTime;
    private Calendar endTime;
    private String devDes = "";
    private File checkListFile = null;
    private int curNodeFinishedItemNum = 0;
    private static int finishedItem = 0;
    private String riskRating = null;
    private int maxDeductScore = 0;
    private int bureauScore = -1;
    private boolean error = false;
    private boolean supportReentry = false;
    private boolean needCmsSignPath = false;
    private String curPatchName = "";
    private boolean isComputeDev = false;
    private Integer scsiTimeOut;
    private double compressionRatio;
    private boolean isOpeningDelivery = false;
    private DevInfo4Exp devInfo4Exp;
    private List<Enclosure> statisticEncloureList = new ArrayList<Enclosure>();
    private List<DiskDomain> smartPoolShowDiskList = new ArrayList<DiskDomain>();
    private String importPatchErrorMsg = "";

    public boolean isError() {
        return this.error;
    }

    public void setError(boolean iserror) {
        this.error = iserror;
    }

    public String getDevDes() {
        return this.devDes;
    }

    public void setComputeDev(boolean computeDev) {
        this.isComputeDev = computeDev;
    }

    public boolean isComputeDev() {
        return this.isComputeDev;
    }

    public void setDevDes(String devDes) {
        this.devDes = devDes;
    }

    public File getCheckListFile() {
        return this.checkListFile;
    }

    public void setCheckListFile(File checkListFile) {
        this.checkListFile = checkListFile;
    }

    public String getDevNodeHotPatch() {
        DevNode devNodeSafe = this.getDevNodeSafe();
        if (devNodeSafe.getProductVersion().startsWith("V700R001C00") && devNodeSafe.getHotPatchVersion().startsWith("SPH001")) {
            return devNodeSafe.getProductVersion() + devNodeSafe.getHotPatchVersion();
        }
        return devNodeSafe.getHotPatchVersion();
    }

    public Integer getScore() {
        if (this.error) {
            return null;
        }
        return this.calcScore();
    }

    public void setRiskRating(String riskRating) {
        this.riskRating = riskRating;
    }

    public String getRiskRating() {
        Integer score = this.getScore();
        if (score == null) {
            return null;
        }
        if (score > 80) {
            return ResourceUtil.getString((String)"inspect.result.riskRating.low");
        }
        if (score <= 60) {
            return ResourceUtil.getString((String)"inspect.result.riskRating.high");
        }
        return ResourceUtil.getString((String)"inspect.result.riskRating.med");
    }

    public float getPassRate() {
        List<CheckItem> allItems = InspectUtils.getAllCheckItem(this);
        int faultSize = 0;
        int allItemSize = 0;
        for (CheckItem item : allItems) {
            if (!item.isEnable()) continue;
            allItemSize += item.getCheckSize();
            faultSize = this.checkElem(faultSize, item);
        }
        int passedSize = allItemSize - faultSize;
        float percent = (float)passedSize / (float)Math.max(1, allItemSize);
        return (float)Math.floor(percent * 100.0f);
    }

    public float getOpenDeliveryPassRate() {
        this.setIsOpeningDelivery(true);
        float passRate = this.getPassRate();
        this.setIsOpeningDelivery(false);
        return passRate;
    }

    private void setIsOpeningDelivery(boolean isOpeningDelivery) {
        this.isOpeningDelivery = isOpeningDelivery;
    }

    public int getPassedSize() {
        List<CheckItem> allItems = InspectUtils.getAllCheckItem(this);
        int faultSize = 0;
        int allItemSize = 0;
        for (CheckItem item : allItems) {
            if (!item.isEnable()) continue;
            allItemSize += item.getCheckSize();
            faultSize = this.checkElem(faultSize, item);
        }
        int passedSize = allItemSize - faultSize;
        return passedSize;
    }

    public int getAllItemSize() {
        List<CheckItem> allItems = InspectUtils.getAllCheckItem(this);
        int allItemSize = 0;
        for (CheckItem item : allItems) {
            if (!item.isEnable()) continue;
            allItemSize += item.getCheckSize();
        }
        return allItemSize;
    }

    private int checkElem(int faultSize, CheckItem item) {
        ResultItem retItem;
        int tempFaultSize = faultSize;
        tempFaultSize = item.isSingleElement() ? (!this.isOpeningDelivery ? (tempFaultSize += null == item.getCheckResult() || !item.isPassedNotShowSuggest() ? 1 : 0) : (tempFaultSize += item.getCheckResult() == null || !item.isOpeningDeliveryPass() ? 1 : 0)) : (null != (retItem = item.getCheckResult()) && !retItem.getItems().isEmpty() ? (tempFaultSize += this.getFaultItemCount(retItem)) : (tempFaultSize += item.getCheckSize()));
        return tempFaultSize;
    }

    public Integer calcScore() {
        int deductScore = 0;
        List<CheckItem> allItems = InspectUtils.getAllCheckItem(this);
        for (CheckItem item : allItems) {
            if (!"true".equals(item.getEnableMark())) {
                return null;
            }
            Integer itemScore = this.calcItemScore(item);
            if (!item.isEnable() || itemScore == null) {
                ToolLoggerFactory.getLogger(this.getClass()).info("disableItemName=" + item.getName());
                return null;
            }
            ToolLoggerFactory.getLogger(this.getClass()).info("enableItemName=" + item.getName());
            ToolLoggerFactory.getLogger(this.getClass()).info("itemScore=" + itemScore);
            deductScore += itemScore.intValue();
        }
        int realScore = 100 - (deductScore += this.maxDeductScore);
        ToolLoggerFactory.getLogger(this.getClass()).info("realScore=" + realScore);
        if (realScore < 10) {
            realScore = 10;
        }
        return realScore;
    }

    public Integer calcItemScore(CheckItem item) {
        if (!item.isSingleElement()) {
            return null;
        }
        ResultItem ret = item.getCheckResult();
        if (ret == null) {
            return null;
        }
        if (ret.isFailed() || ret.isWarning()) {
            Integer score = item.getRiskScore();
            ToolLoggerFactory.getLogger(this.getClass()).info("scoreWeight=" + score);
            if (score == null) {
                return 0;
            }
            this.setMaxDeductScore(item.getDeductScore());
            return score;
        }
        return 0;
    }

    private void setMaxDeductScore(Integer deductScore) {
        if (deductScore == null) {
            return;
        }
        if (deductScore > this.maxDeductScore) {
            this.maxDeductScore = deductScore;
            ToolLoggerFactory.getLogger(this.getClass()).info("maxDeductScore=" + this.maxDeductScore);
        }
    }

    private int getFaultItemCount(ResultItem retItem) {
        return Math.toIntExact(retItem.getItems().stream().filter(this::isFaultItem).count());
    }

    private boolean isFaultItem(RItem ret) {
        return ret.isFailed() || ret.isNoCheck() || !this.isOpeningDelivery && ret.isWarning();
    }

    public String getInspectTime() {
        if (null != this.startTime && null != this.endTime) {
            this.startTime.set(14, 0);
            this.endTime.set(14, 0);
            return StringUtils.millls2FormatString((long)(this.endTime.getTimeInMillis() - this.startTime.getTimeInMillis()));
        }
        return "--";
    }

    public long getInspectTimeInMillis() {
        if (null != this.startTime && null != this.endTime) {
            this.startTime.set(14, 0);
            this.endTime.set(14, 0);
            return this.endTime.getTimeInMillis() - this.startTime.getTimeInMillis();
        }
        return 0L;
    }

    public void addChildren(CheckDevNode checkDevNode) {
        this.childrens.add(checkDevNode);
    }

    public boolean inspectPassed() {
        Collection<List<CheckItem>> cols = this.checkItems.values();
        for (List<CheckItem> items : cols) {
            for (CheckItem item : items) {
                if (item.isPassed()) continue;
                return false;
            }
        }
        return true;
    }

    public void addCmdItems(String id, List<CheckItem> items) {
        this.checkItems.put(id, items);
    }

    private List<CheckDevNode> getAllCheckNode(CheckDevNode root) {
        ArrayList<CheckDevNode> nodes = new ArrayList<CheckDevNode>();
        if (null != root.devNode) {
            nodes.add(root);
        }
        if (root.childrens.isEmpty()) {
            return nodes;
        }
        for (CheckDevNode child : root.childrens) {
            nodes.addAll(this.getAllCheckNode(child));
        }
        return nodes;
    }

    public List<CheckDevNode> getAllCheckNode() {
        return this.getAllCheckNode(this);
    }

    public Map<String, List<CheckItem>> getDstorageCheckItems() {
        List<DstorageSceneCheckItems> dstorageSceneCheckItems = this.getDstorageSceneCheckItemsList();
        Map<String, List<CheckItem>> items = null;
        for (DstorageSceneCheckItems dsci : dstorageSceneCheckItems) {
            items = dsci.getCheckItems();
            for (List<CheckItem> ciList : dsci.getCheckItems().values()) {
                for (CheckItem ci : ciList) {
                    if (!ci.isEnable()) continue;
                    return dsci.getCheckItems();
                }
            }
        }
        return items;
    }

    @NotNull
    public Map<String, List<CheckItem>> getDstorageCheckItemsByScene(String scene) {
        InspectScene inspectScene = InspectScene.of(scene);
        List<DstorageSceneCheckItems> distributedSceneItems = this.getDstorageSceneCheckItemsList();
        return distributedSceneItems.stream().filter(distributedSceneItem -> this.isRightScene(inspectScene, (DstorageSceneCheckItems)distributedSceneItem)).findFirst().orElseGet(DstorageSceneCheckItems::new).getCheckItems();
    }

    private boolean isRightScene(InspectScene inspectScene, DstorageSceneCheckItems dstorageSceneCheckItem) {
        if (inspectScene.getSceneId() == null || dstorageSceneCheckItem.getSceneId() == null) {
            return false;
        }
        return inspectScene.getItemScene().equals(dstorageSceneCheckItem.getSceneId());
    }

    public DstorageSceneCheckItems getDstorageSceneCheckItem() {
        if (!this.devNode.isDsStorage()) {
            return null;
        }
        return this.dstorageSceneCheckItemsList.stream().filter(this::hasItemEnable).findFirst().orElse(null);
    }

    private boolean hasItemEnable(DstorageSceneCheckItems dstorageSceneCheckItems) {
        return dstorageSceneCheckItems.getCheckItems().values().stream().flatMap(Collection::stream).anyMatch(CheckItem::isEnable);
    }

    public String getCurrentSceneDesc() {
        DstorageSceneCheckItems dstorageSceneCheckItem = this.getDstorageSceneCheckItem();
        if (Objects.isNull(dstorageSceneCheckItem)) {
            return "";
        }
        if (StringUtils.isNULLStr((String)dstorageSceneCheckItem.getSceneDesc())) {
            dstorageSceneCheckItem.setSceneDesc(ResourceUtil.getString((String)dstorageSceneCheckItem.getSceneId()));
        }
        return dstorageSceneCheckItem.getSceneDesc();
    }

    public String getTargetVersion() {
        if (this.targetVersion != null) {
            return ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.show.version", (Object[])new Object[]{this.targetVersion});
        }
        return "";
    }

    public Map<String, List<CheckItem>> getCheckItems() {
        if (null != this.getDevNode() && this.getDevNode().isLikeDsStorage()) {
            this.setCheckItems(this.getDstorageCheckItems());
        }
        return this.checkItems;
    }

    public int getAllItemSize(List<CheckItem> items) {
        int count = 0;
        for (CheckItem checkItem : items) {
            count += checkItem.getItems().size();
        }
        return count;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }

    public DevNode getDevNode() {
        return this.devNode;
    }

    public DevNode getDevNodeSafe() {
        if (null != this.devNode) {
            return this.devNode;
        }
        return new DevNode();
    }

    public void setDevNode(DevNode devNode) {
        this.devNode = devNode;
    }

    public boolean isViewAble() {
        return this.viewAble;
    }

    public void setViewAble(boolean viewAble) {
        this.viewAble = viewAble;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public List<CheckDevNode> getChildrens() {
        return this.childrens;
    }

    public File getScriptDir() {
        return this.scriptDir;
    }

    public void setScriptDir(File scriptDir) {
        this.scriptDir = scriptDir;
    }

    public void setCheckItems(Map<String, List<CheckItem>> checkItems) {
        this.checkItems = checkItems;
    }

    public boolean isExecuteSuc() {
        return this.executeSuc;
    }

    public void setExecuteSuc(boolean suc) {
        this.executeSuc = suc;
    }

    public File getResuleTmpFile() {
        return this.resuleTmpFile;
    }

    public void setResuleTmpFile(File resuleTmpFile) {
        this.resuleTmpFile = resuleTmpFile;
    }

    public String toString() {
        if (null != this.devNode) {
            return this.devNode.getIp();
        }
        return this.nodeName;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public boolean isIntegration() {
        return this.integration;
    }

    public void setIntegration(boolean integration) {
        this.integration = integration;
    }

    public String getNameByRes(String id) {
        String name = "--";
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        try {
            name = ResourceUtil.getString((ResourceBundle)this.getResourceBundle(), (ResourceBundle)dftResBundle, (String)(id + ".name"));
            if (null != this.getExpansionResource() && name.equals("--")) {
                name = ResourceUtil.getString((ResourceBundle)this.getExpansionResource(), (ResourceBundle)dftResBundle, (String)(id + ".name"));
            }
            if (this.getSwitchResource() != null && name.equals("--")) {
                name = ResourceUtil.getString((ResourceBundle)this.getSwitchResource(), (ResourceBundle)dftResBundle, (String)(id + ".name"));
            }
        }
        catch (RuntimeException e) {
            ToolLoggerFactory.getLogger(this.getClass()).error("", (Throwable)e);
        }
        return name.trim();
    }

    public String getAdditionDesc() {
        String additionDesc = this.getDevDes();
        String type = "";
        if (null != this.devNode && null != this.devNode.getDeviceType()) {
            String string = type = InspectContext.DEVNODE_TYPE.get(this.devNode) == null ? this.devNode.getDeviceType().toString() : InspectContext.DEVNODE_TYPE.get(this.devNode);
        }
        if (null != this.devNode && null != this.devNode.getOemModel() && InspectContext.getInstance().isOemOutTool()) {
            type = this.devNode.getOemModel();
        }
        if (this.devNode != null && !StringUtils.isNULLStr((String)this.devNode.getProductSubModel())) {
            type = this.devNode.getProductSubModel();
        }
        if (StringUtils.isNULLStr((String)additionDesc)) {
            return type;
        }
        return type + "(" + additionDesc + ")";
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
    }

    public int getCurNodeFinishedItemNum() {
        return this.curNodeFinishedItemNum;
    }

    public void setCurNodeFinishedItemNum(int curNodeFinishedItemNum) {
        this.curNodeFinishedItemNum = curNodeFinishedItemNum;
    }

    public static int getFinishedItem() {
        return finishedItem;
    }

    public static void setFinishedItem(int finishedItem) {
        CheckDevNode.finishedItem = finishedItem;
    }

    public String getBureauScore() {
        return this.bureauScore >= 0 ? String.valueOf(this.bureauScore) : null;
    }

    public void setBureauScore(int bureauScore) {
        this.bureauScore = this.getPassRate() == 100.0f ? bureauScore : Math.max(0, bureauScore - 30);
    }

    public List<DstorageSceneCheckItems> getDstorageSceneCheckItemsList() {
        return this.dstorageSceneCheckItemsList;
    }

    public void setDstorageSceneCheckItemsList(List<DstorageSceneCheckItems> dstorageSceneCheckItemsList) {
        this.dstorageSceneCheckItemsList = dstorageSceneCheckItemsList;
    }

    public void reset() {
        this.executeSuc = false;
        this.error = false;
    }

    public ResourceBundle getExpansionResource() {
        return this.expansionResource;
    }

    public void setExpansionResource(ResourceBundle expansionResource) {
        this.expansionResource = expansionResource;
    }

    public String showImpact() {
        if (null != this.product) {
            return this.product.getShowImpact();
        }
        return null;
    }

    public boolean isSupportReentry() {
        return this.supportReentry;
    }

    public void setSupportReentry(boolean supportReentry) {
        this.supportReentry = supportReentry;
    }

    public String getCurPatchName() {
        return this.curPatchName;
    }

    public void setCurPatchName(String curPatchName) {
        this.curPatchName = curPatchName;
    }

    public boolean isErrorRedView() {
        return this.product == null ? false : this.product.isErrorRedView();
    }

    public boolean isNeedCmsSignPath() {
        return this.needCmsSignPath;
    }

    public void setNeedCmsSignPath(boolean needCmsSignPath) {
        this.needCmsSignPath = needCmsSignPath;
    }

    public DevNode getFirstNode() {
        return this.getAllCheckNode().stream().findFirst().orElseGet(CheckDevNode::new).getDevNodeSafe();
    }

    public void clearDistributedSelectItems() {
        if (!this.isDistributed()) {
            return;
        }
        this.dstorageSceneCheckItemsList.forEach(distributedItems -> distributedItems.setSelectStatus(false));
    }

    public void selectItems(InspectScene scene, List<String> selectedItemIds) {
        if (this.isDistributed()) {
            this.selectDistributedItems(scene, selectedItemIds);
            return;
        }
        this.selectUnifiedItems(selectedItemIds);
    }

    public boolean isDistributed() {
        return this.getDevNodeSafe().isDsStorage() || this.getDevNode().isFusionCube() || this.getDevNode().isDataTurbo();
    }

    public boolean isNeedBatchInspect() {
        return this.isDistributed() && !this.getDevNode().isA3000() && !this.getDevNode().isMetaVision();
    }

    private void selectUnifiedItems(List<String> selectedItemIds) {
        if (selectedItemIds.isEmpty()) {
            this.getCheckItems().values().stream().flatMap(Collection::stream).forEach(item -> item.setEnable(true));
            return;
        }
        this.getCheckItems().values().stream().flatMap(Collection::stream).forEach(item -> item.setEnable(selectedItemIds.contains(item.getItemId())));
    }

    private void selectDistributedItems(InspectScene scene, List<String> selectedItemIds) {
        this.clearDistributedSelectItems();
        this.dstorageSceneCheckItemsList.stream().filter(distributedItems -> distributedItems.getSceneId().equals(scene.getItemScene())).findFirst().ifPresent(distributedItems -> this.selectDistributedItems(selectedItemIds, (DstorageSceneCheckItems)distributedItems));
    }

    private void selectDistributedItems(List<String> selectedItemIds, DstorageSceneCheckItems distributedItems) {
        if (selectedItemIds.isEmpty()) {
            distributedItems.setSelectStatus(true);
            return;
        }
        distributedItems.selected(selectedItemIds);
    }

    public List<ResourceBundle> getBatchResourceBundle() {
        return Stream.of(this.resourceBundle, this.expansionResource, this.switchResource).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    public void setTargetVersion(String targetVersion) {
        this.targetVersion = targetVersion;
    }

    @Generated
    public ResourceBundle getSwitchResource() {
        return this.switchResource;
    }

    @Generated
    public void setSwitchResource(ResourceBundle switchResource) {
        this.switchResource = switchResource;
    }

    @Generated
    public boolean isStop() {
        return this.isStop;
    }

    @Generated
    public void setStop(boolean isStop) {
        this.isStop = isStop;
    }

    @Generated
    public Integer getScsiTimeOut() {
        return this.scsiTimeOut;
    }

    @Generated
    public void setScsiTimeOut(Integer scsiTimeOut) {
        this.scsiTimeOut = scsiTimeOut;
    }

    @Generated
    public double getCompressionRatio() {
        return this.compressionRatio;
    }

    @Generated
    public void setCompressionRatio(double compressionRatio) {
        this.compressionRatio = compressionRatio;
    }

    @Generated
    public DevInfo4Exp getDevInfo4Exp() {
        return this.devInfo4Exp;
    }

    @Generated
    public void setDevInfo4Exp(DevInfo4Exp devInfo4Exp) {
        this.devInfo4Exp = devInfo4Exp;
    }

    @Generated
    public List<Enclosure> getStatisticEncloureList() {
        return this.statisticEncloureList;
    }

    @Generated
    public void setStatisticEncloureList(List<Enclosure> statisticEncloureList) {
        this.statisticEncloureList = statisticEncloureList;
    }

    @Generated
    public void setSmartPoolShowDiskList(List<DiskDomain> smartPoolShowDiskList) {
        this.smartPoolShowDiskList = smartPoolShowDiskList;
    }

    @Generated
    public List<DiskDomain> getSmartPoolShowDiskList() {
        return this.smartPoolShowDiskList;
    }

    @Generated
    public String getImportPatchErrorMsg() {
        return this.importPatchErrorMsg;
    }

    @Generated
    public void setImportPatchErrorMsg(String importPatchErrorMsg) {
        this.importPatchErrorMsg = importPatchErrorMsg;
    }
}

