/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.Item;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.IniResourceUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.pyengine.psdk.bean.CheckConfigItem;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

public class CheckItem
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CheckItem.class);
    private static final long serialVersionUID = 1L;
    private static final String DUMP_SUFFIX = ".dump";
    private static final String DUMP_KEY = "[ONLY FOR INSPECT CLI ECHO PATH]:";
    public static final int DEFAULT_CMD_TIMEOUT = 1200;
    private static final String FUSIONCUBE_PREFIX = "FusionCube_";
    private static final String CUBE_PREFIX = "Cube_";
    private String itemId;
    private String riskWeight = null;
    private String enableMark = null;
    private String tag = "";
    private Object annex = null;
    private String effectiveScene = "";
    private static final String RISK_HIGH = "high";
    private static final int RISK_HIGH_SCORE = 5;
    private static final String RISK_MEDIUM = "med";
    private static final int RISK_MDEIUM_SCORE = 2;
    private static final String RISK_LOW = "low";
    private static final int RISK_LOW_SCORE = 1;
    private static final int DEDUCT_SCORE_HIGH = 40;
    private static final int DEDUCT_SCORE_MDEIUM = 20;
    private static final int DEDUCT_SCORE_LOW = 0;
    private String dstorageShellPath = "";
    private String extendItemMode = "";
    private String preInspectionScrip = "";
    private String dstorageShellUpdatePath = "";
    private boolean isUserExpansionRes = false;
    private static int itemDumpLimit = 5120;
    private static int itemLoadLimit = 0x500000;
    private boolean dump = false;
    private String dumpDir = "";
    private ItemCheckType itemCheckType;
    private String itemType = "basicCheck";
    private boolean selected = true;
    private CheckConfigItem configItem;
    private String checkScript;
    private String sourceInfoPath;
    private String script;
    private String name;
    private boolean enable = true;
    private boolean isSingleItem = true;
    private List<Item> items = new ArrayList<Item>();
    private ResultItem checkResult;
    private String sourceInfo = "";
    private String errorInfo = "";
    private String suggestionInfo = "NA";
    private boolean depthItem = false;
    private int timeouts = 1200;
    private String expResult;

    public String getEnableMark() {
        return this.enableMark;
    }

    public void setEnableMark(String enableMark) {
        this.enableMark = enableMark;
    }

    public String getSourceInfoPath() {
        return this.sourceInfoPath;
    }

    public void setSourceInfoPath(String sourceInfoPath) {
        this.sourceInfoPath = sourceInfoPath;
    }

    public Integer getRiskScore() {
        if (this.riskWeight == null) {
            return null;
        }
        String riskweight = this.riskWeight.toLowerCase(Locale.US);
        if (riskweight.equals(RISK_HIGH)) {
            return 5;
        }
        if (riskweight.equals(RISK_MEDIUM)) {
            return 2;
        }
        if (riskweight.equals(RISK_LOW)) {
            return 1;
        }
        return null;
    }

    public Integer getDeductScore() {
        if (this.riskWeight == null) {
            return null;
        }
        String riskweight = this.riskWeight.toLowerCase(Locale.US);
        if (riskweight.equals(RISK_HIGH)) {
            return 40;
        }
        if (riskweight.equals(RISK_MEDIUM)) {
            return 20;
        }
        if (riskweight.equals(RISK_LOW)) {
            return 0;
        }
        return null;
    }

    public String getRiskWeight() {
        return this.riskWeight;
    }

    public void setRiskWeight(String riskWeight) {
        this.riskWeight = riskWeight;
    }

    public String getExpResult() {
        return this.expResult;
    }

    public void setExpResult(String expResult) {
        this.expResult = expResult;
    }

    public String getSuggestionInfo() {
        return this.suggestionInfo;
    }

    public void setSuggestionInfo(String suggestionInfo) {
        this.suggestionInfo = suggestionInfo;
    }

    public String getErrorInfo() {
        return this.errorInfo;
    }

    public void setErrorInfo(String errorInfo) {
        this.errorInfo = errorInfo;
    }

    public void setSourceInfo(String sourceInfo, CheckDevNode node) {
        String source = sourceInfo;
        if (InspectContext.getInstance().isOemOutTool() && null != node && null != node.getDevNode() && null != node.getDevNode().getDeviceType() && (StringUtils.isNULLStr((String)node.getDevNode().getOemModel()) || !node.getDevNode().getOemModel().contains(node.getDevNode().getDeviceType().toString()))) {
            source = source.replaceAll(node.getDevNode().getDeviceType().toString(), "******");
        }
        if (!this.dumpSourceInfo(source)) {
            this.sourceInfo = source;
        }
    }

    public String getSourceInfo() {
        String info = "";
        info = !this.dump || StringUtils.isNULLStr((String)this.dumpDir) ? this.sourceInfo : this.loadSourceDumpFile();
        return StringUtils.isNULLStr((String)info) ? "No available information." : info;
    }

    public boolean isPassed() {
        if (!this.isEnable()) {
            return true;
        }
        if (this.checkResult != null) {
            return this.checkResult.isNormal();
        }
        return false;
    }

    public boolean isPassedNotShowSuggest() {
        if (!this.isEnable()) {
            return true;
        }
        if (this.checkResult != null) {
            return this.checkResult.isNormal() || this.checkResult.isNoSupport();
        }
        return false;
    }

    public boolean isOpeningDeliveryPass() {
        if (!this.isEnable()) {
            return true;
        }
        if (this.checkResult != null) {
            return this.checkResult.isNormal() || this.checkResult.isNoSupport() || this.checkResult.isWarning();
        }
        return false;
    }

    public boolean isNoSupport() {
        if (this.checkResult != null) {
            return this.checkResult.isNoSupport();
        }
        return false;
    }

    public boolean isManualConfirmation() {
        if (this.checkResult != null) {
            return this.checkResult.isManualConfirmation();
        }
        return false;
    }

    public int getCheckSize() {
        if (this.items.isEmpty()) {
            return 1;
        }
        return this.items.size();
    }

    public boolean isSingleElement() {
        return this.isSingleItem;
    }

    public void setSingleElement(boolean isSingleElement) {
        this.isSingleItem = isSingleElement;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public boolean isEnable() {
        return this.enable && this.selected;
    }

    public void setEnable(boolean isEnable) {
        this.enable = isEnable;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ResultItem getCheckResult() {
        return this.checkResult;
    }

    public void setCheckResult(ResultItem checkResult) {
        this.checkResult = checkResult;
    }

    public int getTimeouts() {
        return this.timeouts;
    }

    public void setTimeouts(int timeouts) {
        this.timeouts = timeouts;
    }

    public boolean isDepth() {
        return this.depthItem;
    }

    public void setDepth(boolean isDepth) {
        this.depthItem = isDepth;
    }

    public String toString() {
        return this.getName();
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public Object getAnnex() {
        return this.annex;
    }

    public void setAnnex(Object annex) {
        this.annex = annex;
    }

    public String getEffectiveScene() {
        return this.effectiveScene;
    }

    public void setEffectiveScene(String effectiveScene) {
        this.effectiveScene = effectiveScene;
    }

    public void reset() {
        this.sourceInfo = "";
        this.errorInfo = "";
        this.suggestionInfo = "NA";
        this.checkResult = null;
        this.dumpDir = "";
        this.dump = false;
    }

    public String getDstorageShellPath() {
        return this.dstorageShellPath;
    }

    public void setDstorageShellPath(String dstorageShellPath) {
        this.dstorageShellPath = dstorageShellPath;
    }

    public boolean isUserExpansionRes() {
        return this.isUserExpansionRes;
    }

    public void setUserExpansionRes(boolean userExpansionRes) {
        this.isUserExpansionRes = userExpansionRes;
    }

    private boolean dumpSourceInfo(String sourceInfoStr) {
        boolean success;
        if (StringUtils.isNULLStr((String)sourceInfoStr)) {
            return false;
        }
        if (sourceInfoStr.contains(DUMP_KEY)) {
            this.dump = true;
            return true;
        }
        if (StringUtils.isNULLStr((String)this.dumpDir) || sourceInfoStr.length() <= itemDumpLimit) {
            return false;
        }
        LOGGER.info(String.format(Locale.ROOT, "Record %s source info dump.", this.itemId));
        File recordFile = new File(this.dumpDir + File.separator + this.itemId + DUMP_SUFFIX);
        File dir = recordFile.getParentFile();
        if (!dir.exists()) {
            success = dir.mkdirs();
            LOGGER.info(String.format(Locale.ROOT, "Create dump dir %s result : %s", this.dumpDir, success));
        }
        if (recordFile.exists()) {
            success = recordFile.delete();
            LOGGER.info(String.format(Locale.ROOT, "Delete dump file %s %s result : %s", this.dumpDir, this.itemId, success));
        }
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(recordFile), "UTF-8"));){
            writer.write(sourceInfoStr);
            writer.flush();
        }
        catch (Exception e) {
            LOGGER.error("Record item source info error." + e);
            return false;
        }
        this.dump = true;
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String loadSourceDumpFile() {
        LOGGER.info(String.format(Locale.ROOT, "Load %s source info dump.", this.itemId));
        File sourceFile = new File(this.dumpDir + File.separator + this.itemId + DUMP_SUFFIX);
        if (sourceFile.length() > (long)itemLoadLimit) {
            String pathInTool = FilesUtil.getCanonicalPath((File)sourceFile);
            int index = pathInTool.lastIndexOf("tools");
            if (-1 != index) {
                pathInTool = pathInTool.substring(index);
            }
            String pathInReport = "data" + File.separator + "record" + File.separator + sourceFile.getParentFile().getName() + File.separator + this.itemId + DUMP_SUFFIX;
            if (InspectContext.getInstance().isBackgroundMode()) {
                return ResourceUtil.getStringWithParams((String)"inspsctor.wizard.inspectdetail.dump.info.silence", (Object[])new Object[]{pathInReport});
            }
            return ResourceUtil.getStringWithParams((String)"inspsctor.wizard.inspectdetail.dump.info", (Object[])new Object[]{pathInTool, pathInReport});
        }
        StringBuffer sb = new StringBuffer((int)sourceFile.length());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(sourceFile), "UTF-8"));){
            String temp = "";
            while ((temp = reader.readLine()) != null) {
                sb.append(temp).append(System.lineSeparator());
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Load item source info dump failed." + e);
            return "";
        }
    }

    public void setDumpDir(String dumpDir) {
        this.dumpDir = dumpDir;
    }

    public String getDstorageShellUpdatePath() {
        return this.dstorageShellUpdatePath;
    }

    public void setDstorageShellUpdatePath(String dstorageShellUpdatePath) {
        this.dstorageShellUpdatePath = dstorageShellUpdatePath;
    }

    public void setExtendItemMode(String extendItemMode) {
        this.extendItemMode = extendItemMode;
    }

    public String getExtendItemMode() {
        return this.extendItemMode;
    }

    public boolean isFusionCube() {
        return org.apache.commons.lang3.StringUtils.startsWith((CharSequence)this.itemId, (CharSequence)FUSIONCUBE_PREFIX) || org.apache.commons.lang3.StringUtils.startsWith((CharSequence)this.itemId, (CharSequence)CUBE_PREFIX);
    }

    public String getMethod(ResourceBundle bundle, ResourceBundle defaultBundle, String idPrefix) {
        if (this.configItem != null) {
            return this.configItem.getMethod();
        }
        if ("innercheck".equals(this.itemType)) {
            return this.getString(this.getItemId() + ".method");
        }
        if ("fcvcheck".equals(this.itemType)) {
            return ResourceUtil.getString((String)"MetaVisionDefault.method");
        }
        return ResourceUtil.getString((ResourceBundle)bundle, (ResourceBundle)defaultBundle, (String)(idPrefix + ".method"));
    }

    public String getCriterion(ResourceBundle bundle, ResourceBundle defaultBundle, String idPrefix) {
        if (this.configItem != null) {
            return this.configItem.getCriterion();
        }
        if ("innercheck".equals(this.itemType)) {
            return this.getString(this.getItemId() + ".criterion");
        }
        if ("fcvcheck".equals(this.itemType)) {
            return ResourceUtil.getString((String)"MetaVisionDefault.criterion");
        }
        return ResourceUtil.getString((ResourceBundle)bundle, (ResourceBundle)defaultBundle, (String)(idPrefix + ".criterion"));
    }

    public String getSuggestion(ResourceBundle bundle, ResourceBundle defaultBundle, String idPrefix) {
        if (this.configItem != null) {
            return this.configItem.getSuggestion();
        }
        if ("innercheck".equals(this.itemType)) {
            return this.getString(this.getItemId() + ".suggestion");
        }
        if ("fcvcheck".equals(this.itemType)) {
            return ResourceUtil.getString((String)"MetaVisionDefault.suggestion");
        }
        return ResourceUtil.getString((ResourceBundle)bundle, (ResourceBundle)defaultBundle, (String)(idPrefix + ".suggestion"));
    }

    public boolean isHardWareCheckItem() {
        return ItemCheckType.HARDWARE.equals((Object)this.itemCheckType);
    }

    public ItemCheckType getItemCheckType() {
        return Objects.isNull((Object)this.itemCheckType) ? ItemCheckType.SOFT : this.itemCheckType;
    }

    public String getString(String key) {
        String val = IniResourceUtil.getString((String)"cbb/res/upgrade", (String)"resource_dorado", (String)key);
        if (!"--".equals(val)) {
            return val;
        }
        val = IniResourceUtil.getString((String)key);
        val = "--".equals(val) ? key : val;
        return val;
    }

    public boolean isDisplayItem() {
        return !"HIDDEN".equals(this.tag);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CheckItem)) {
            return false;
        }
        CheckItem other = (CheckItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$itemId = this.getItemId();
        String other$itemId = other.getItemId();
        return !(this$itemId == null ? other$itemId != null : !this$itemId.equals(other$itemId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CheckItem;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $itemId = this.getItemId();
        result = result * 59 + ($itemId == null ? 43 : $itemId.hashCode());
        return result;
    }

    @Generated
    public void setPreInspectionScrip(String preInspectionScrip) {
        this.preInspectionScrip = preInspectionScrip;
    }

    @Generated
    public String getPreInspectionScrip() {
        return this.preInspectionScrip;
    }

    @Generated
    public void setItemCheckType(ItemCheckType itemCheckType) {
        this.itemCheckType = itemCheckType;
    }

    @Generated
    public void setItemType(String itemType) {
        this.itemType = itemType;
    }

    @Generated
    public String getItemType() {
        return this.itemType;
    }

    @Generated
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Generated
    public CheckConfigItem getConfigItem() {
        return this.configItem;
    }

    @Generated
    public void setConfigItem(CheckConfigItem configItem) {
        this.configItem = configItem;
    }

    @Generated
    public String getCheckScript() {
        return this.checkScript;
    }

    @Generated
    public void setCheckScript(String checkScript) {
        this.checkScript = checkScript;
    }

    static {
        try {
            ResourceBundle sysBundle = ResourceBundle.getBundle("config.inspect");
            itemDumpLimit = Integer.parseInt(sysBundle.getString("itemDumpLimit")) / 2 * 1024;
            itemLoadLimit = Integer.parseInt(sysBundle.getString("itemLoadLimit")) / 2 * 1024;
        }
        catch (Exception e) {
            LOGGER.error("Init item dump limit failed,use default value.");
        }
    }

    public static enum ItemCheckType {
        HARDWARE("hardware"),
        SOFT("soft");

        private String type;

        public static ItemCheckType getByType(String type) {
            return Arrays.stream(ItemCheckType.values()).filter(checkType -> checkType.type.equals(type)).findFirst().orElse(SOFT);
        }

        public String getType() {
            return this.type;
        }

        @Generated
        private ItemCheckType(String type) {
            this.type = type;
        }
    }
}

