/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.List;
import lombok.Generated;

public class Config {
    private static final String FUSION_STORAGE_SUFFIX = "_FusionStorage";
    String preItemID;
    String resultItemId;
    List<String> productModels;
    List<String> productVersions;
    List<String> associatedItemIds;
    List<String> hiddenItemIds;
    boolean versionFuzzyMatchSwitch = false;
    boolean isMultiple = false;

    public boolean isMatch(DevNode node) {
        String productModel = node.getProductModel();
        if (node.isFusionCube()) {
            productModel = productModel + FUSION_STORAGE_SUFFIX;
        }
        boolean productModelSupport = this.productModels.contains(productModel);
        boolean productVersionSupport = this.isProductVersionMatch(this.versionFuzzyMatchSwitch, node.getProductVersion());
        return productModelSupport && productVersionSupport;
    }

    private boolean isProductVersionMatch(boolean fuzzyMatch, String productVersion) {
        if (this.productVersions.contains("*")) {
            return true;
        }
        if (fuzzyMatch) {
            return this.productVersions.stream().anyMatch(version -> productVersion.contains((CharSequence)version));
        }
        return this.productVersions.contains(productVersion);
    }

    public boolean isHiddenCheckItem(CheckItem item) {
        return this.hiddenItemIds.contains(item.getItemId());
    }

    public boolean isHiddenCheckItem(String id) {
        return this.hiddenItemIds.contains(id);
    }

    public boolean isPreCheckItem(CheckItem item) {
        return this.preItemID.equals(item.getItemId());
    }

    public void hiddenItem(CheckItem item) {
        if (!this.isHiddenCheckItem(item)) {
            return;
        }
        item.setTag("HIDDEN");
        item.setEnable(false);
    }

    @Generated
    public String getPreItemID() {
        return this.preItemID;
    }

    @Generated
    public String getResultItemId() {
        return this.resultItemId;
    }

    @Generated
    public List<String> getProductModels() {
        return this.productModels;
    }

    @Generated
    public List<String> getProductVersions() {
        return this.productVersions;
    }

    @Generated
    public List<String> getAssociatedItemIds() {
        return this.associatedItemIds;
    }

    @Generated
    public List<String> getHiddenItemIds() {
        return this.hiddenItemIds;
    }

    @Generated
    public boolean isVersionFuzzyMatchSwitch() {
        return this.versionFuzzyMatchSwitch;
    }

    @Generated
    public boolean isMultiple() {
        return this.isMultiple;
    }

    @Generated
    public void setPreItemID(String preItemID) {
        this.preItemID = preItemID;
    }

    @Generated
    public void setResultItemId(String resultItemId) {
        this.resultItemId = resultItemId;
    }

    @Generated
    public void setProductModels(List<String> productModels) {
        this.productModels = productModels;
    }

    @Generated
    public void setProductVersions(List<String> productVersions) {
        this.productVersions = productVersions;
    }

    @Generated
    public void setAssociatedItemIds(List<String> associatedItemIds) {
        this.associatedItemIds = associatedItemIds;
    }

    @Generated
    public void setHiddenItemIds(List<String> hiddenItemIds) {
        this.hiddenItemIds = hiddenItemIds;
    }

    @Generated
    public void setVersionFuzzyMatchSwitch(boolean versionFuzzyMatchSwitch) {
        this.versionFuzzyMatchSwitch = versionFuzzyMatchSwitch;
    }

    @Generated
    public void setMultiple(boolean isMultiple) {
        this.isMultiple = isMultiple;
    }
}

