/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.DiskEnclosure;
import java.util.ArrayList;

public class Disk {
    private static final String SED = "SED";
    private String type;
    private String capacity;
    private String count;
    private String inputCapacity;
    private String inputUnit;
    private String bom;
    private ArrayList<DiskEnclosure> enclosureInfo;

    public Disk() {
    }

    public Disk(String type, String capacity, String count) {
        this.type = type;
        this.capacity = capacity;
        this.count = count;
    }

    public Disk(String type, String capacity, String count, String inputCapacity, String inputUnit) {
        this.type = type;
        this.capacity = capacity;
        this.count = count;
        this.inputCapacity = inputCapacity;
        this.inputUnit = inputUnit;
    }

    public Disk(String type, String capacity, String count, ArrayList<DiskEnclosure> enclosureInfo) {
        this.type = type;
        this.capacity = capacity;
        this.count = count;
        this.enclosureInfo = enclosureInfo;
    }

    public Disk(String type, String capacity, String count, String inputCapacity, String inputUnit, String bom) {
        this.type = type;
        this.capacity = capacity;
        this.count = count;
        this.inputCapacity = inputCapacity;
        this.inputUnit = inputUnit;
        this.bom = bom;
    }

    public String toString() {
        return "type=" + this.type + ", capacity=" + this.capacity + ", count=" + this.count + ", enclosureInfo=" + this.enclosureInfo.toString();
    }

    public Disk partialClone() {
        return new Disk(this.type, this.capacity, this.count, this.inputCapacity, this.inputUnit);
    }

    public Disk partialDiskInfoClone() {
        return new Disk(this.type, this.capacity, this.count, this.enclosureInfo);
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getCapacity() {
        return this.capacity;
    }

    public void setCapacity(String capacity) {
        this.capacity = capacity;
    }

    public String getCount() {
        return this.count;
    }

    public void setCount(String count) {
        this.count = count;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.capacity == null ? 0 : this.capacity.hashCode());
        result = 31 * result + (this.count == null ? 0 : this.count.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Disk other = (Disk)obj;
        if (this.capacity == null ? other.capacity != null : !this.capacity.equals(other.capacity)) {
            return false;
        }
        if (this.count == null ? other.count != null : !this.count.equals(other.count)) {
            return false;
        }
        return !(this.type == null ? other.type != null : !this.type.equals(other.type));
    }

    public String getInputCapacity() {
        return this.inputCapacity;
    }

    public void setInputCapacity(String inputCapacity) {
        this.inputCapacity = inputCapacity;
    }

    public String getInputUnit() {
        return this.inputUnit;
    }

    public void setInputUnit(String inputUnit) {
        this.inputUnit = inputUnit;
    }

    public String getBom() {
        return this.bom;
    }

    public void setBom(String bom) {
        this.bom = bom;
    }

    public ArrayList<DiskEnclosure> getEnclosureInfo() {
        ArrayList<DiskEnclosure> newEnclosureInfo = new ArrayList<DiskEnclosure>();
        for (DiskEnclosure diskEnclosure : this.enclosureInfo) {
            DiskEnclosure newDiskEnclosure = new DiskEnclosure(diskEnclosure.getId(), diskEnclosure.getName(), diskEnclosure.getCount());
            newEnclosureInfo.add(newDiskEnclosure);
        }
        return newEnclosureInfo;
    }

    public void setEnclosureInfo(ArrayList<DiskEnclosure> enclosureInfo) {
        this.enclosureInfo = enclosureInfo;
    }

    public String ignoreSedFlag() {
        if (this.type.endsWith(SED)) {
            return this.type.replace(SED, "").trim();
        }
        return this.type;
    }
}

