/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Config;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DstorageAfterCheckConfig {
    public static final DstorageAfterCheckConfig INS = new DstorageAfterCheckConfig();
    private static final Logger LOGGER = LoggerFactory.getLogger(DstorageAfterCheckConfig.class);
    private static final String PRODUCT_MODEL_TAG = "productModel";
    private static final String PRE_ITEM_ID_TAG = "preItemId";
    private static final String RESULT_ITEM_ID_TAG = "resultItemId";
    private static final String PRODUCT_VERSION_TAG = "productVersion";
    private static final String VERSION_FUZZY_MATCH_SWITCH = "versionFuzzyMatchSwitch";
    private static final String ASSOCIATED_ITEM_ID_TAG = "associatedItemIds";
    private static final String HIDDEN_ITEM_IDS_TAG = "hiddenItems";
    private static final String SPLIT = ",";
    private static final String CONFIG_XQL = "//config";
    private List<Config> configs = new ArrayList<Config>();

    private DstorageAfterCheckConfig() {
        String configPath = InspectConstans.DSTORAGE_EXTENDE_PATH + File.separator + "AfterInspectConfig.xml";
        this.initConfig(configPath);
    }

    private void initConfig(String path) {
        File configFile = new File(path);
        if (!configFile.exists()) {
            LOGGER.warn("Pre inspect config not exists.");
            return;
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            NodeList nodeList = XmlUtils.searchNodeByExp((Document)XmlUtils.parseDocument((InputStream)in), (String)CONFIG_XQL);
            if (nodeList == null) {
                LOGGER.info("nodeList is null!");
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element configEle = (Element)node;
                this.initOneConfig(configEle);
            }
        }
        catch (IOException e) {
            LOGGER.error("Init fusion storage preCheckItem failed.", (Throwable)e);
        }
    }

    private void initOneConfig(Element configEle) {
        Config config = new Config();
        config.preItemID = XmlUtils.getTextContentOfChild((Element)configEle, (String)PRE_ITEM_ID_TAG);
        config.resultItemId = XmlUtils.getTextContentOfChild((Element)configEle, (String)RESULT_ITEM_ID_TAG);
        String productModels = XmlUtils.getTextContentOfChild((Element)configEle, (String)PRODUCT_MODEL_TAG);
        config.productModels = Arrays.asList(productModels.split(SPLIT));
        String versions = XmlUtils.getTextContentOfChild((Element)configEle, (String)PRODUCT_VERSION_TAG);
        config.productVersions = Arrays.asList(versions.split(SPLIT));
        String versionFuzzyMatchSwitch = XmlUtils.getTextContentOfChild((Element)configEle, (String)VERSION_FUZZY_MATCH_SWITCH);
        config.versionFuzzyMatchSwitch = Boolean.valueOf(versionFuzzyMatchSwitch);
        String ids = XmlUtils.getTextContentOfChild((Element)configEle, (String)ASSOCIATED_ITEM_ID_TAG);
        config.associatedItemIds = Arrays.asList(ids.split(SPLIT));
        String hiddenItemIds = XmlUtils.getTextContentOfChild((Element)configEle, (String)HIDDEN_ITEM_IDS_TAG);
        config.hiddenItemIds = Arrays.asList(hiddenItemIds.split(SPLIT));
        this.configs.add(config);
    }

    public List<Config> getConfigs() {
        return this.configs;
    }

    public List<CheckItem> filterAfterCheckItems(CheckDevNode node) {
        if (CollectionUtils.isEmpty(this.configs)) {
            return new ArrayList<CheckItem>();
        }
        List associatedItemIds = this.configs.stream().map(Config::getAssociatedItemIds).flatMap(Collection::stream).collect(Collectors.toList());
        return node.getCheckItems().values().stream().flatMap(Collection::stream).filter(item -> associatedItemIds.contains(item.getItemId())).distinct().collect(Collectors.toList());
    }

    public void removeHiddenItems(CheckDevNode node) {
        if (InspectContext.getInstance().isSoftInspect()) {
            return;
        }
        if (CollectionUtils.isEmpty(this.configs)) {
            return;
        }
        List<Config> configOpt = this.findMatchConfig(node.getDevNode());
        if (CollectionUtils.isEmpty(configOpt)) {
            return;
        }
        List hiddenItemIds = configOpt.stream().flatMap(config -> config.getHiddenItemIds().stream()).distinct().collect(Collectors.toList());
        node.getCheckItems().forEach((checkType, checkItems) -> checkItems.removeIf(item -> hiddenItemIds.contains(item.getItemId())));
    }

    public void hiddenAfterCheckItem(Map<String, List<CheckItem>> checkItems, CheckDevNode checkDevNode) {
        List<Config> configOpt = this.findMatchConfig(checkDevNode.getDevNode());
        if (CollectionUtils.isEmpty(configOpt)) {
            return;
        }
        LOGGER.info("Filter after check item for {}.", (Object)checkDevNode.getDevNode().getIp());
        List hiddenItemIds = configOpt.stream().flatMap(config -> config.getHiddenItemIds().stream()).distinct().collect(Collectors.toList());
        checkItems.values().forEach(checkItemList -> checkItemList.forEach(checkItem -> {
            if (hiddenItemIds.contains(checkItem.getItemId()) && checkItem.isEnable()) {
                checkItem.setTag("HIDDEN");
                checkItem.setEnable(false);
            }
        }));
    }

    public List<Config> findMatchConfig(DevNode devNode) {
        return this.configs.stream().filter(config -> config.isMatch(devNode)).collect(Collectors.toList());
    }

    public boolean isHiddenItem(DevNode devNode, String itemId) {
        if (CollectionUtils.isEmpty(this.configs)) {
            return false;
        }
        List<Config> configOpt = this.findMatchConfig(devNode);
        if (CollectionUtils.isEmpty(configOpt)) {
            return false;
        }
        List hiddenItemIds = configOpt.stream().flatMap(config -> config.getHiddenItemIds().stream()).distinct().collect(Collectors.toList());
        return hiddenItemIds.contains(itemId);
    }
}

