/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.base.utils.XmlUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.Config;
import com.huawei.ism.tool.inspect.utils.InspectConstans;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DstoragePreCheckConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(DstoragePreCheckConfig.class);
    private static final String PRODUCT_MODEL_TAG = "productModel";
    private static final String PRE_ITEM_ID_TAG = "preItemId";
    private static final String RESULT_ITEM_ID_TAG = "resultItemId";
    private static final String PRODUCT_VERSION_TAG = "productVersion";
    private static final String VERSION_FUZZY_MATCH_SWITCH = "versionFuzzyMatchSwitch";
    private static final String IS_MULTIPLE = "isMultiple";
    private static final String ASSOCIATED_ITEM_ID_TAG = "associatedItemIds";
    private static final String HIDDEN_ITEM_IDS_TAG = "hiddenItems";
    private static final String SPLIT = ",";
    private static final String CONFIG_XQL = "//config";
    public static final DstoragePreCheckConfig INS = new DstoragePreCheckConfig();
    private List<Config> configs = new ArrayList<Config>();

    public boolean needPreCheck(CheckDevNode checkDevNode) {
        List<Config> preConfigs = this.findMatchConfigs(checkDevNode.getDevNode());
        if (CollectionUtil.isEmpty(preConfigs)) {
            return false;
        }
        return this.needPreCheck(checkDevNode, preConfigs);
    }

    private boolean needPreCheck(CheckDevNode checkDevNode, List<Config> preConfigs) {
        List<CheckItem> selectedItems = InspectUtils.getAllCheckItem(checkDevNode);
        if (CollectionUtil.isEmpty(preConfigs)) {
            return false;
        }
        List associatedItemIds = preConfigs.stream().flatMap(config -> config.getAssociatedItemIds().stream()).collect(Collectors.toList());
        return selectedItems.stream().map(CheckItem::getItemId).anyMatch(associatedItemIds::contains);
    }

    public void hiddenPreCheckItem(Map<String, List<CheckItem>> checkItems, CheckDevNode checkDevNode) {
        List<Config> preConfigs = this.findMatchConfigs(checkDevNode.getDevNode());
        if (CollectionUtil.isEmpty(preConfigs)) {
            return;
        }
        LOGGER.info("Filter pre check item for {}.", (Object)checkDevNode.getDevNode().getIp());
        preConfigs.forEach(config -> checkItems.values().forEach(checkItemList -> checkItemList.forEach(config::hiddenItem)));
    }

    public static void hiddenPreItems(Map<String, List<CheckItem>> checkItems) {
        checkItems.values().forEach(checkItemList -> checkItemList.forEach(checkItem -> DstoragePreCheckConfig.hiddenPreItem(checkItem)));
    }

    private static void hiddenPreItem(CheckItem item) {
        if (!item.getName().contains("pre_inspect_")) {
            return;
        }
        item.setTag("HIDDEN");
        item.setEnable(false);
    }

    public Optional<Config> findMatchConfig(DevNode node) {
        return this.configs.stream().filter(config -> config.isMatch(node)).findFirst();
    }

    public List<Config> findMatchConfigs(DevNode node) {
        return this.configs.stream().filter(config -> config.isMatch(node)).collect(Collectors.toList());
    }

    public boolean isHiddenItem(DevNode node, String itemId) {
        List<Config> matchConfigs = INS.findMatchConfigs(node);
        if (CollectionUtil.isEmpty(matchConfigs)) {
            return false;
        }
        return matchConfigs.stream().anyMatch(config -> config.isHiddenCheckItem(itemId));
    }

    public Optional<CheckItem> findPreCheckItem(CheckDevNode checkDevNode) {
        Optional<Config> configOpt = this.findMatchConfig(checkDevNode.getDevNode());
        if (!configOpt.isPresent()) {
            return Optional.empty();
        }
        ArrayList allItems = new ArrayList();
        checkDevNode.getCheckItems().values().forEach(allItems::addAll);
        Config config = configOpt.get();
        return allItems.stream().filter(config::isPreCheckItem).findFirst();
    }

    public List<CheckItem> findPreCheckItems(CheckDevNode checkDevNode) {
        List<Config> preConfigs = this.findMatchConfigs(checkDevNode.getDevNode());
        if (preConfigs.isEmpty()) {
            return Collections.emptyList();
        }
        List<CheckItem> selectItems = InspectUtils.getAllCheckItem(checkDevNode);
        List<String> preItemIds = DstoragePreCheckConfig.findPreItemIds(preConfigs, selectItems);
        return checkDevNode.getCheckItems().values().stream().flatMap(Collection::stream).filter(checkItem -> preItemIds.contains(checkItem.getItemId())).distinct().collect(Collectors.toList());
    }

    @NonNull
    private static List<String> findPreItemIds(List<Config> preConfigs, List<CheckItem> selectItems) {
        return selectItems.stream().map(checkItem -> DstoragePreCheckConfig.findPreConfig(preConfigs, checkItem)).flatMap(Collection::stream).distinct().map(Config::getPreItemID).collect(Collectors.toList());
    }

    @NonNull
    private static List<Config> findPreConfig(List<Config> preConfigs, CheckItem checkItem) {
        return preConfigs.stream().filter(preConfig -> preConfig.getAssociatedItemIds().contains(checkItem.getItemId())).collect(Collectors.toList());
    }

    private DstoragePreCheckConfig() {
        String configPath = InspectConstans.DSTORAGE_EXTENDE_PATH + File.separator + "preInspectConfig.xml";
        this.initConfig(configPath);
    }

    private void initConfig(String path) {
        File configFile = new File(path);
        if (!configFile.exists()) {
            LOGGER.warn("Pre inspect config not exists.");
            return;
        }
        try (FileInputStream in = new FileInputStream(configFile);){
            NodeList nodeList = XmlUtils.searchNodeByExp((Document)XmlUtils.parseDocument((InputStream)in), (String)CONFIG_XQL);
            if (nodeList == null) {
                LOGGER.info("nodeList is null!");
                return;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element configEle = (Element)node;
                this.initOneConfig(configEle);
            }
        }
        catch (Exception e) {
            LOGGER.error("Init fusion storage preCheckItem failed.", (Throwable)e);
        }
    }

    public void filterHiddenItems(CheckDevNode checkDevNode) {
        if (InspectContext.getInstance().isSoftInspect()) {
            return;
        }
        List<Config> matchConfigs = this.findMatchConfigs(checkDevNode.getDevNode());
        if (CollectionUtil.isEmpty(matchConfigs)) {
            return;
        }
        matchConfigs.forEach(config -> checkDevNode.getCheckItems().forEach((checkType, checkItems) -> checkItems.removeIf(config::isHiddenCheckItem)));
    }

    public static void removePreItems(CheckDevNode checkDevNode) {
        if (InspectContext.getInstance().isSoftInspect()) {
            return;
        }
        checkDevNode.getCheckItems().forEach((checkType, checkItems) -> checkItems.removeIf(item -> item.getName().contains("pre_inspect_")));
    }

    private void initOneConfig(Element configEle) {
        Config config = new Config();
        config.preItemID = XmlUtils.getTextContentOfChild((Element)configEle, (String)PRE_ITEM_ID_TAG);
        config.resultItemId = XmlUtils.getTextContentOfChild((Element)configEle, (String)RESULT_ITEM_ID_TAG);
        String productModels = XmlUtils.getTextContentOfChild((Element)configEle, (String)PRODUCT_MODEL_TAG);
        config.productModels = Arrays.asList(productModels.split(SPLIT));
        String versions = XmlUtils.getTextContentOfChild((Element)configEle, (String)PRODUCT_VERSION_TAG);
        config.productVersions = Arrays.asList(versions.split(SPLIT));
        String versionFuzzyMatchSwitch = XmlUtils.getTextContentOfChild((Element)configEle, (String)VERSION_FUZZY_MATCH_SWITCH);
        config.versionFuzzyMatchSwitch = Boolean.valueOf(versionFuzzyMatchSwitch);
        String isMultiple = XmlUtils.getTextContentOfChild((Element)configEle, (String)IS_MULTIPLE);
        config.isMultiple = Boolean.parseBoolean(isMultiple);
        String ids = XmlUtils.getTextContentOfChild((Element)configEle, (String)ASSOCIATED_ITEM_ID_TAG);
        config.associatedItemIds = Arrays.asList(ids.split(SPLIT));
        String hiddenItemIds = XmlUtils.getTextContentOfChild((Element)configEle, (String)HIDDEN_ITEM_IDS_TAG);
        config.hiddenItemIds = Arrays.asList(hiddenItemIds.split(SPLIT));
        this.configs.add(config);
    }
}

