/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.utils.FsExpansionUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.ui.component.treetable.TreeTableModel;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class FsNodeExpansionInfo
implements Cloneable {
    private ClusterNode existNode;
    private DevNode newNode;
    private NodeType nodeType;
    private ConfigType configType;
    private List<FsNodeExpansionInfo> children = new ArrayList<FsNodeExpansionInfo>();
    private int mainStorageMaxNumber;
    private int congfigMainStorageNumber;
    private int cacheMaxNumber;
    private int congfigCacheMaxNumber;
    private FusionStorDiskInfo childrenConfigDisk;
    private int childDiskNumber = 0;
    private int childDiskMaxNumber;
    private ChildrenType childrenType;
    private TreeTableModel.SelectType selectType = TreeTableModel.SelectType.UNSELECT;
    private String diskZoneId;

    public FsNodeExpansionInfo() {
        this.configType = ConfigType.TIPS_ROW;
    }

    public FsNodeExpansionInfo(ConfigType configType) {
        this.configType = configType;
    }

    public FsNodeExpansionInfo(ConfigType configType, String diskZoneId) {
        this.configType = configType;
        this.diskZoneId = diskZoneId;
    }

    public FsNodeExpansionInfo(FusionStorDiskInfo disk) {
        this.childrenConfigDisk = disk;
        this.childrenType = ChildrenType.MAIN_STORAGE;
        this.configType = ConfigType.DISK_INFO_ROW;
    }

    public FsNodeExpansionInfo(FusionStorDiskInfo disk, int diskMaxNumber, int diskNumber, ChildrenType childrenType) {
        this.configType = ConfigType.DISK_INFO_ROW;
        this.childrenConfigDisk = disk;
        this.childDiskMaxNumber = diskMaxNumber;
        this.childDiskNumber = diskNumber;
        this.childrenType = childrenType;
        if (diskNumber > 0) {
            this.selectType = TreeTableModel.SelectType.SELECT;
        }
    }

    public FusionStorDiskInfo getChildrenConfigDisk() {
        return this.childrenConfigDisk;
    }

    public boolean isCustomConfig() {
        return this.childrenConfigDisk != null && this.childrenConfigDisk.isCustomConfig();
    }

    public void setChildDiskNumber(int childDiskNumber) {
        this.childDiskNumber = childDiskNumber;
    }

    public int getChildDiskNumber() {
        return this.childDiskNumber;
    }

    public int getChildDiskNumberBySelectType() {
        if (this.selectType == TreeTableModel.SelectType.SELECT) {
            return this.childDiskNumber;
        }
        return 0;
    }

    public int getChildDiskMaxNumber() {
        return this.childDiskMaxNumber;
    }

    public void setChildrenType(ChildrenType childrenType) {
        this.childrenType = childrenType;
    }

    public ChildrenType getChildrenType() {
        return this.childrenType;
    }

    public boolean isMainStorageChild() {
        return this.childrenType == ChildrenType.MAIN_STORAGE;
    }

    public boolean isCacheChild() {
        return this.childrenType == ChildrenType.CACHE;
    }

    public FsNodeExpansionInfo(ClusterNode existNode) {
        this.existNode = existNode;
        this.nodeType = NodeType.EXIST;
        this.configType = ConfigType.NODE_ROW;
    }

    public FsNodeExpansionInfo(DevNode newNode) {
        this.newNode = newNode;
        this.nodeType = NodeType.NEW_EXPANSION;
        this.configType = ConfigType.NODE_ROW;
    }

    public DevNode getNewNode() {
        return this.newNode;
    }

    public ClusterNode getExistNode() {
        return this.existNode;
    }

    public String getIp() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.getManagementIp();
        }
        return this.newNode.getIp();
    }

    public boolean isPacificNode() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.isPacificNode();
        }
        return this.newNode.isPacificNode();
    }

    public boolean isEastOceanSingle() {
        return this.nodeType == NodeType.EXIST ? this.existNode.isEastSeaSingleNode() : this.newNode.isEastSeaSingleNode();
    }

    public boolean isEastOceanDouble() {
        return this.nodeType == NodeType.EXIST ? this.existNode.isEastSeaDoubleNode() : this.newNode.isEastSeaDoubleNode();
    }

    public boolean isEastOcean() {
        return this.isEastOceanDouble() || this.isEastOceanSingle();
    }

    public boolean involveDiskZone() {
        return this.isPacificNode() || this.isEastOcean();
    }

    public int getDiskZoneNum() {
        if (this.isPacificNode()) {
            return 4;
        }
        if (this.isEastOceanDouble()) {
            return 2;
        }
        if (this.isEastOceanSingle()) {
            return 4;
        }
        return 1;
    }

    public List<FusionStorDiskInfo> getAllDiskInfo() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.getAllDiskInfo();
        }
        return this.newNode.getAllDiskInfo();
    }

    public boolean isFreeNode() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.getJoinedStoragePool() == null;
        }
        return true;
    }

    public String getName() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.getName();
        }
        return this.newNode.getDeviceName();
    }

    public String getModel() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.getBmcNode() == null ? "--" : this.existNode.getBmcNode().getProductModel();
        }
        return this.newNode.getProductModel();
    }

    public Map<FusionStorDiskInfo, Integer> getExpansionDisk(ChildrenType childrenType) {
        if (childrenType == ChildrenType.MAIN_STORAGE) {
            return this.getExpansionMainStorageDisk();
        }
        if (childrenType == ChildrenType.CACHE) {
            return this.getExpansionCacheDisk();
        }
        return new HashMap<FusionStorDiskInfo, Integer>();
    }

    public Map<FusionStorDiskInfo, Integer> getExpansionMainStorageDisk() {
        if (this.nodeType == NodeType.EXIST) {
            return InspectContext.getInstance().getFsExpansionConfig(this.existNode).getExpansionMainStorageDisk();
        }
        return InspectContext.getInstance().getFsExpansionConfig(this.newNode).getExpansionMainStorageDisk();
    }

    public List<FusionStorDiskInfo> getMainStorageDisk() {
        if (this.nodeType == NodeType.EXIST) {
            return this.existNode.getMainStorageDisk();
        }
        return new ArrayList<FusionStorDiskInfo>();
    }

    public Map<FusionStorDiskInfo, Integer> getExpansionCacheDisk() {
        if (this.nodeType == NodeType.EXIST) {
            return InspectContext.getInstance().getFsExpansionConfig(this.existNode).getExpansionCacheDisk();
        }
        return InspectContext.getInstance().getFsExpansionConfig(this.newNode).getExpansionCacheDisk();
    }

    public List<FsNodeExpansionInfo> getChildren() {
        return this.children;
    }

    public List<FsNodeExpansionInfo> getAllDiskChildren() {
        ArrayList<FsNodeExpansionInfo> rowList = new ArrayList<FsNodeExpansionInfo>();
        FsNodeExpansionInfo.buildAllDiskRow(this, rowList);
        return rowList;
    }

    private static void buildAllDiskRow(FsNodeExpansionInfo row, List<FsNodeExpansionInfo> rowList) {
        row.getChildren().forEach(subRow -> {
            if (subRow.isDiskInfoRow()) {
                rowList.add((FsNodeExpansionInfo)subRow);
            } else {
                FsNodeExpansionInfo.buildAllDiskRow(subRow, rowList);
            }
        });
    }

    public void setChildren(List<FsNodeExpansionInfo> children) {
        this.children = children;
    }

    public int getCongfigCacheMaxNumber() {
        return this.congfigCacheMaxNumber;
    }

    public void setCongfigCacheMaxNumber(int congfigCacheMaxNumber) {
        this.congfigCacheMaxNumber = congfigCacheMaxNumber;
    }

    public void setCongfigMainStorageNumber(int congfigMainStorageNumber) {
        this.congfigMainStorageNumber = congfigMainStorageNumber;
    }

    public int getCongfigMainStorageNumber() {
        return this.congfigMainStorageNumber;
    }

    public int getCacheMaxNumber() {
        return this.cacheMaxNumber;
    }

    public int getMainStorageMaxNumber() {
        return this.mainStorageMaxNumber;
    }

    public void setCacheMaxNumber(int cacheMaxNumber) {
        this.cacheMaxNumber = cacheMaxNumber;
    }

    public void setMainStorageMaxNumber(int mainStorageMaxNumber) {
        this.mainStorageMaxNumber = mainStorageMaxNumber;
    }

    public boolean isNodeRow() {
        return this.configType == ConfigType.NODE_ROW;
    }

    public boolean isDiskInfoRow() {
        return this.configType == ConfigType.DISK_INFO_ROW;
    }

    public boolean isTips() {
        return this.configType == ConfigType.TIPS_ROW;
    }

    public boolean isDiskZone() {
        return this.configType == ConfigType.DISK_ZONE_ROW;
    }

    public boolean isCacheGroup() {
        return this.configType == ConfigType.CACHE_GROUP_ROW;
    }

    public ConfigType getConfigType() {
        return this.configType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public boolean nodeIsExist() {
        return this.nodeType == NodeType.EXIST;
    }

    public boolean nodeIsNewExpansion() {
        return this.nodeType == NodeType.NEW_EXPANSION;
    }

    public void setChildrenConfigDisk(FusionStorDiskInfo childrenConfigDisk) {
        this.childrenConfigDisk = childrenConfigDisk;
    }

    public Object clone() throws CloneNotSupportedException {
        FsNodeExpansionInfo newConfig = (FsNodeExpansionInfo)super.clone();
        if (this.childrenConfigDisk != null) {
            newConfig.setChildrenConfigDisk((FusionStorDiskInfo)this.childrenConfigDisk.clone());
        }
        if (!this.children.isEmpty()) {
            ArrayList<FsNodeExpansionInfo> newChildren = new ArrayList<FsNodeExpansionInfo>();
            for (FsNodeExpansionInfo child : this.children) {
                newChildren.add((FsNodeExpansionInfo)child.clone());
            }
            newConfig.setChildren(newChildren);
        }
        return newConfig;
    }

    public void setSelectType(TreeTableModel.SelectType selectType) {
        this.selectType = selectType;
    }

    public TreeTableModel.SelectType getSelectType() {
        return this.selectType;
    }

    public boolean isSelect() {
        return this.selectType == TreeTableModel.SelectType.SELECT;
    }

    public boolean isUnSelect() {
        return this.selectType == TreeTableModel.SelectType.UNSELECT;
    }

    public void cleanAndUpdateConfigToNode() {
        if (this.configType != ConfigType.NODE_ROW) {
            return;
        }
        this.cleanNoeConfig();
        this.getAllDiskChildren().forEach(child -> {
            if (!child.isSelect()) {
                if (child.isCustomConfig()) {
                    return;
                }
                child.setChildDiskNumber(0);
            }
            if (child.isMainStorageChild()) {
                this.getExpansionMainStorageDisk().put(child.getChildrenConfigDisk(), child.getChildDiskNumber());
            } else if (child.isCacheChild()) {
                this.getExpansionCacheDisk().put(child.getChildrenConfigDisk(), child.getChildDiskNumber());
            }
        });
    }

    private void cleanNoeConfig() {
        if (this.nodeType == NodeType.EXIST) {
            FsExpansionUtils.cleanExpansionConfig(this.existNode);
        } else {
            FsExpansionUtils.cleanExpansionConfig(this.newNode);
        }
    }

    @Generated
    public String getDiskZoneId() {
        return this.diskZoneId;
    }

    @Generated
    public void setDiskZoneId(String diskZoneId) {
        this.diskZoneId = diskZoneId;
    }

    public static enum ChildrenType {
        MAIN_STORAGE,
        CACHE;


        public String toString() {
            return ResourceUtil.getString((String)("fs.node.expansion.info.children.type." + super.toString()));
        }
    }

    public static enum ConfigType {
        NODE_ROW,
        DISK_INFO_ROW,
        TIPS_ROW,
        DISK_ZONE_ROW,
        CACHE_GROUP_ROW;

    }

    public static enum NodeType {
        EXIST,
        NEW_EXPANSION;


        public String toString() {
            return ResourceUtil.getString((String)("fs.node.expansion.info.node.type." + super.toString()));
        }
    }
}

