/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.CommonValue;
import com.huawei.ism.tool.inspect.entity.ResultItem;
import com.huawei.ism.tool.inspect.logic.result.TemplateFactory;
import com.huawei.ism.tool.obase.constant.ToolConstants;
import com.huawei.ism.tool.obase.log.ToolLoggerFactory;
import com.huawei.ism.tool.obase.utils.KeyOrderedHashMap;
import com.huawei.ism.tool.obase.utils.ListOrderedMap;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringEscapeUtils;

public class RItem
implements Serializable {
    public static final String PASS = "0";
    public static final String UNNORMAL = "1";
    public static final String NOCHECK = "2";
    public static final String NOSUPPORT = "3";
    public static final String WARNING = "4";
    public static final String MANUAL_CONFIRMATION = "5";
    public static final String STOP = "8";
    private static final long serialVersionUID = 1L;
    private static final int NUMBER_TWO = 2;
    private static final int NUMBER_FOUR = 4;
    public static final String VALUE_SPLITER = "\\|\\|";
    public static final String KV_SPLITER = ":";
    private List<CommonValue> commonValues = new ArrayList<CommonValue>();
    private List<CommonValue> errorValues = new ArrayList<CommonValue>();
    private boolean errorRedView = false;
    private List<CommonValue> rawval = new ArrayList<CommonValue>();
    private String cli;
    private String judge;
    private String name;
    private String itemId;

    public String getCommonString() {
        return this.toFormatStr(this.commonValues);
    }

    public String getRawval() {
        StringBuffer destStr = new StringBuffer();
        for (CommonValue val : this.rawval) {
            destStr.append(val.getVal());
        }
        return destStr.toString();
    }

    public String getErrorString() {
        return this.toFormatStr(this.errorValues);
    }

    private String toFormatStr(List<CommonValue> values) {
        ListOrderedMap<String, List<String>> map = this.convertTable(values);
        return this.toHorizotalStr(map);
    }

    private ListOrderedMap<String, List<String>> convertTable(List<CommonValue> values) {
        KeyOrderedHashMap map = new KeyOrderedHashMap();
        for (CommonValue v : values) {
            String str = v.getVal();
            try {
                String[] columns = str.split(VALUE_SPLITER);
                this.addRow((ListOrderedMap<String, List<String>>)map, columns);
            }
            catch (RuntimeException e) {
                ToolLoggerFactory.getLogger(this.getClass()).error("add parser row errror.", (Throwable)e);
            }
        }
        return map;
    }

    public String getInfo2View() {
        HashMap<String, List<List<String>>> data = new HashMap<String, List<List<String>>>(2);
        ListOrderedMap<String, List<String>> commonVals = this.convertTable(this.commonValues);
        ListOrderedMap<String, List<String>> errorVals = this.convertTable(this.errorValues);
        data.put("commonVal", this.toHorizotalHtml(commonVals));
        if (this.errorRedView) {
            data.put("errorValByRed", this.toHorizotalHtml(errorVals));
        } else {
            data.put("errorVal", this.toHorizotalHtml(errorVals));
        }
        return TemplateFactory.processorFtl("cliTemplate.html", data);
    }

    private void addRow(ListOrderedMap<String, List<String>> map, String[] columns) {
        for (String kv : columns) {
            List<String> vals;
            if (StringUtils.isNULLStr((String)kv)) continue;
            String[] val = kv.split(KV_SPLITER, 2);
            String key = StringUtils.safetyGetStr((String[])val, (int)0);
            String value = StringUtils.safetyGetStr((String[])val, (int)1);
            if (map.containsKey((Object)key)) {
                vals = (List)map.get((Object)key);
                vals.add(value);
                continue;
            }
            vals = new ArrayList();
            vals.add(value);
            map.put((Object)key, vals);
        }
    }

    public String getCli() {
        return this.cli;
    }

    public void setCli(String cli) {
        this.cli = cli;
    }

    public String getJudge() {
        return this.judge;
    }

    public void setJudge(String judge) {
        this.judge = judge;
    }

    public List<CommonValue> getCommonValues() {
        return this.commonValues;
    }

    public void setCommonValues(List<CommonValue> commonValues) {
        this.commonValues = commonValues;
    }

    public List<CommonValue> getErrorValues() {
        return this.errorValues;
    }

    public void setErrorValues(List<CommonValue> errorValues) {
        this.errorValues = errorValues;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public boolean isNormal() {
        return PASS.equals(this.judge);
    }

    public boolean isFailed() {
        return UNNORMAL.equals(this.judge);
    }

    public boolean isNoCheck() {
        return NOCHECK.equals(this.judge);
    }

    public boolean isNoSupport() {
        return NOSUPPORT.equals(this.judge);
    }

    public boolean isWarning() {
        return WARNING.equals(this.judge);
    }

    public boolean isManualConfirmation() {
        return MANUAL_CONFIRMATION.equals(this.judge);
    }

    public boolean isStop() {
        return STOP.equals(this.judge);
    }

    public void setRawval(List<CommonValue> rawval) {
        this.rawval = rawval;
    }

    private List<List<String>> toHorizotalHtml(ListOrderedMap<String, List<String>> values) {
        ArrayList<List<String>> table = new ArrayList<List<String>>();
        List columnNames = values.keyList();
        if (!columnNames.isEmpty()) {
            table.add(columnNames);
        }
        int listDeep = this.getlistDeep(columnNames, values);
        for (int i = 0; i < listDeep; ++i) {
            table.add(this.getRow(columnNames, values, i));
        }
        return table;
    }

    public List<String> getRow(List<String> columnNames, ListOrderedMap<String, List<String>> values, int i) {
        ArrayList<String> row = new ArrayList<String>();
        for (String key : columnNames) {
            ArrayList list = new ArrayList((Collection)values.get((Object)key));
            String cellVal = "";
            if (i <= list.size() - 1) {
                cellVal = (String)list.get(i);
            }
            row.add(cellVal);
        }
        return row;
    }

    public int getlistDeep(List<String> columnNames, ListOrderedMap<String, List<String>> values) {
        int listDeep = 0;
        for (String key : columnNames) {
            ArrayList tmpList = new ArrayList((Collection)values.get((Object)key));
            if (listDeep >= tmpList.size()) continue;
            listDeep = tmpList.size();
        }
        return listDeep;
    }

    private String toHorizotalStr(ListOrderedMap<String, List<String>> values) {
        List keys = values.keyList();
        StringBuffer destStr = new StringBuffer();
        int listDeep = 0;
        for (String key : keys) {
            ArrayList<String> tmpList = new ArrayList<String>((Collection)values.get((Object)key));
            listDeep = tmpList.size() > listDeep ? tmpList.size() : listDeep;
            tmpList.add(key);
            int colomunMaxWidth = this.getMaxWidth(tmpList);
            destStr.append(StringUtils.fillStr((String)key, (int)colomunMaxWidth, (String)" ")).append(StringUtils.fillStr((String)"", (int)4, (String)" "));
        }
        destStr.append(ToolConstants.ENTER);
        for (int i = 0; i < listDeep; ++i) {
            StringBuffer row = new StringBuffer();
            for (String key : keys) {
                ArrayList<String> list = new ArrayList<String>((Collection)values.get((Object)key));
                list.add(key);
                int colomunMaxWidth = this.getMaxWidth(list);
                list.remove(list.size() - 1);
                String column = "";
                if (i < list.size()) {
                    column = (String)list.get(i);
                    column = StringEscapeUtils.unescapeHtml4((String)column);
                }
                row.append(StringUtils.fillStr((String)column, (int)colomunMaxWidth, (String)" ")).append(StringUtils.fillStr((String)"", (int)4, (String)" "));
            }
            row.append(ToolConstants.ENTER);
            destStr.append(row);
        }
        return destStr.toString();
    }

    private int getMaxWidth(List<String> tmpList) {
        int maxLength = 0;
        for (String s : tmpList) {
            if (maxLength >= s.length()) continue;
            maxLength = s.length();
        }
        return maxLength;
    }

    public void syncResult(ResultItem resultItem) {
        if (resultItem.isNoSupport()) {
            this.setJudge(NOSUPPORT);
        } else if (resultItem.isNoCheck()) {
            this.setJudge(NOCHECK);
        } else if (resultItem.isWarning()) {
            this.setJudge(WARNING);
        } else if (resultItem.isNormal()) {
            this.setJudge(PASS);
        } else if (resultItem.isManualConfirmation()) {
            this.setJudge(MANUAL_CONFIRMATION);
        } else if (resultItem.isStop()) {
            this.setJudge(STOP);
        } else {
            this.setJudge(UNNORMAL);
        }
    }

    public void setErrorRedView(boolean errorRedView) {
        this.errorRedView = errorRedView;
    }
}

