/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.RItem;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.utils.InspectCommonResBundle;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Record
implements Serializable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Record.class);
    private static final long serialVersionUID = 1L;
    private static final String NEW_LINE = "\n";
    private static final String NEW_LINE_HTML = "<br>";
    protected Date date;
    protected Date endTime;
    protected String message;
    protected RecordStatus status;
    protected int progress = 0;
    private RItem item;
    private CheckDevNode checkDevNode;
    private CheckItem checkItem;

    public Date getDate() {
        if (this.date != null) {
            return (Date)this.date.clone();
        }
        return null;
    }

    public void setDate(Date date) {
        this.date = date != null ? (Date)date.clone() : null;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public CheckDevNode getCheckDevNode() {
        return this.checkDevNode;
    }

    public void setCheckDevNode(CheckDevNode checkDevNode) {
        this.checkDevNode = checkDevNode;
    }

    public RItem getItem() {
        return this.item;
    }

    public void setItem(RItem item) {
        this.item = item;
    }

    public CheckItem getCheckItem() {
        return this.checkItem;
    }

    public void setCheckItem(CheckItem checkItem) {
        this.checkItem = checkItem;
    }

    public RecordStatus getStatus() {
        return this.status;
    }

    public void setStatus(RecordStatus status) {
        if (!status.isRunning()) {
            this.endTime = new Date();
        }
        this.status = status;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public boolean isCommonStep() {
        return this.item == null;
    }

    public String getItemResourceId() {
        if (this.item.getItemId() == null) {
            return this.checkItem.getItemId();
        }
        return this.checkItem.getItemId() + "." + this.item.getItemId();
    }

    public String getMethod() {
        String idPrefix = this.getItemResourceId();
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        String method = "--";
        for (ResourceBundle resourceBundle : this.checkDevNode.getBatchResourceBundle()) {
            if (this.isValidResource(method)) break;
            method = this.checkItem.getMethod(resourceBundle, dftResBundle, idPrefix);
        }
        if (this.checkDevNode.getDevNode().isA3000()) {
            method = this.checkItem.getMethod(null, dftResBundle, idPrefix);
        }
        return method;
    }

    public String getCriterion() {
        String idPrefix = this.getItemResourceId();
        ResourceBundle dftResBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        String criterion = "--";
        for (ResourceBundle resourceBundle : this.checkDevNode.getBatchResourceBundle()) {
            if (this.isValidResource(criterion)) break;
            criterion = this.checkItem.getCriterion(resourceBundle, dftResBundle, idPrefix);
        }
        if (this.checkDevNode.getDevNode().isA3000()) {
            criterion = this.checkItem.getCriterion(null, dftResBundle, idPrefix);
        }
        return criterion;
    }

    public String getSuggestion() {
        String idPrefix = this.getItemResourceId();
        ResourceBundle bundle = this.checkDevNode.getResourceBundle();
        ResourceBundle defaultBundle = InspectCommonResBundle.INS.getUnifiedResBundle();
        String suggestion = this.checkItem.getSuggestionInfo();
        for (ResourceBundle resourceBundle : this.checkDevNode.getBatchResourceBundle()) {
            if (this.isValidResource(suggestion)) break;
            suggestion = this.checkItem.getSuggestion(resourceBundle, defaultBundle, idPrefix);
        }
        if (this.checkDevNode.getDevNode().isA3000()) {
            return suggestion;
        }
        return InspectUtils.replaceKeysByMap(suggestion.replaceAll(NEW_LINE, NEW_LINE_HTML), Record.getScriptPath(this), InspectUtils.getHelpKeys(Record.getHelpKey(idPrefix, bundle)));
    }

    private boolean isValidResource(String suggestion) {
        return !"NA".equals(suggestion) && !"--".equals(suggestion);
    }

    private static String getHelpKey(String id, ResourceBundle bundle) {
        String helpKey = "";
        String helpKeyKey = id + ".helphref";
        try {
            helpKey = bundle.getString(helpKeyKey);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return helpKey;
    }

    private static String getScriptPath(Record rec) {
        if (rec.getCheckDevNode().getScriptDir() == null) {
            return "";
        }
        String scriptPath = rec.getCheckDevNode().getScriptDir().getParent();
        int index = scriptPath.indexOf("packages");
        scriptPath = scriptPath.substring(index);
        return scriptPath;
    }

    public String getRecordId() {
        if (this.isCommonStep()) {
            return this.message;
        }
        return this.checkItem.getItemId();
    }

    public String getOriginalInfo() {
        String originalInfo;
        if (this.isCommonStep()) {
            return "";
        }
        if (this.checkItem.getCheckResult().getItems().isEmpty()) {
            String sourceInfoPath = this.checkItem.getSourceInfoPath() == null ? "" : this.checkItem.getSourceInfoPath();
            originalInfo = this.checkItem.getSourceInfo() + sourceInfoPath;
        } else if (this.checkItem.getCheckResult().getItems().get(0).isNoCheck() && this.checkItem.getSourceInfo().equals(ResourceUtil.getString((String)"inspect.undetected.timeout.msg"))) {
            originalInfo = this.checkItem.getSourceInfo();
        } else {
            originalInfo = this.item.getInfo2View();
            if (this.item.isNoCheck() && !StringUtils.isNULLStr((String)this.item.getCli())) {
                originalInfo = this.item.getCli();
            }
        }
        return originalInfo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Record)) {
            return false;
        }
        Record other = (Record)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Record;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    @Generated
    public Date getEndTime() {
        return this.endTime;
    }
}

