/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.alibaba.fastjson.JSON;
import com.huawei.ism.tool.inspect.entity.DevInfo4Exp;
import com.huawei.ism.tool.inspect.entity.Disk;
import com.huawei.ism.tool.inspect.entity.DiskEnclosure;
import com.huawei.ism.tool.inspect.entity.EngineDiskInfo;
import com.huawei.ism.tool.inspect.entity.ExtendModel;
import com.huawei.ism.tool.inspect.ui.wizard.StrategySettingCard;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.ui.swing.dialog.DialogUtils;
import com.huawei.ism.util.Utils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JDialog;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedundantEnclosure {
    private static final Logger LOG = LoggerFactory.getLogger(StrategySettingCard.class);
    public boolean enclosureRedundant = this.hasEnclosureRedundant();
    public boolean addOneColumn;

    public RedundantEnclosure(ExtendModel configMode) {
        this.addOneColumn = this.needAddOneColumn(configMode);
    }

    public boolean hasEnclosureRedundant() {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        HashMap<String, String> domainRedundancyStrategy = devInfo.getDomainRedundancyStrategy();
        for (String key : domainRedundancyStrategy.keySet()) {
            if (!domainRedundancyStrategy.get(key).equals("Enclosure")) continue;
            return true;
        }
        return false;
    }

    public boolean needAddOneColumn(ExtendModel configMode) {
        return this.enclosureRedundant && configMode.getKey().equals("ddExpInspect");
    }

    public boolean checkCapacityEnclosureRedundant(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        String poolId = key.split("#")[0];
        String engineId = key.split("#")[1];
        if (expDisks.size() > 2) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.expDiskTypeNumber", (Object[])new Object[]{poolId, engineId, 2});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        if (expDisks.size() == 2) {
            return this.checkExpWithTwoTypeWhenEnc(expDisks, devDisks, key);
        }
        if (devDisks.size() == 1) {
            return this.checkExpOnOneType(expDisks, devDisks, key);
        }
        return this.checkExpOnTwoType(expDisks, devDisks, key);
    }

    private boolean checkExpWithTwoTypeWhenEnc(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        InnerParameter innerParameter = new InnerParameter();
        innerParameter.poolId = key.split("#")[0];
        innerParameter.engineId = key.split("#")[1];
        innerParameter.devMaxCapacity = 0.0;
        innerParameter.devMaxType = "";
        ArrayList<Double> devCapacityList = new ArrayList<Double>();
        innerParameter.devInputCapacity = "";
        innerParameter.devInputUnit = "";
        for (Disk devDisk : devDisks) {
            Double diskCapacity = Double.parseDouble(devDisk.getCapacity());
            if (diskCapacity > innerParameter.devMaxCapacity) {
                innerParameter.devMaxCapacity = diskCapacity;
                innerParameter.devMaxType = devDisk.getType();
                innerParameter.devInputCapacity = devDisk.getInputCapacity();
                innerParameter.devInputUnit = devDisk.getInputUnit();
            }
            boolean capNeedAdd = true;
            for (double capacity : devCapacityList) {
                if (!this.isSameDiskCapacity(capacity, diskCapacity)) continue;
                capNeedAdd = false;
                break;
            }
            if (!capNeedAdd) continue;
            devCapacityList.add(diskCapacity);
        }
        return this.compareCapacity(expDisks, devDisks, devCapacityList, innerParameter);
    }

    private boolean compareCapacity(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, ArrayList<Double> devCapacityList, InnerParameter innerParameter) {
        double expMaxCapacity = 0.0;
        double expSecondCapacity = 0.0;
        for (Disk disk : expDisks) {
            if (!this.checkDiskType(disk.getType(), innerParameter.devMaxType, innerParameter.poolId)) {
                String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskType", (Object[])new Object[]{innerParameter.poolId, innerParameter.engineId});
                JDialog mainDialog = InspectContext.getInstance().getMainDialog();
                DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
                return false;
            }
            if (this.isSameDiskCapacity(expMaxCapacity, Double.parseDouble(disk.getCapacity())) || !(Double.parseDouble(disk.getCapacity()) > expMaxCapacity)) continue;
            if (!this.isSameDiskCapacity(expMaxCapacity, expSecondCapacity) && expMaxCapacity > expSecondCapacity) {
                expSecondCapacity = expMaxCapacity;
            }
            expMaxCapacity = Double.parseDouble(disk.getCapacity());
        }
        LOG.info("expMaxCapacity={}", (Object)expMaxCapacity);
        LOG.info("expSecondCapacity={}", (Object)expSecondCapacity);
        return this.showWrongMsg(devDisks, devCapacityList, expMaxCapacity, expSecondCapacity, innerParameter);
    }

    public boolean checkDiskType(String expType, String devType, String poolId) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        Object[] encryptionDomainList = devInfo.getEncryptionDiskDomainList();
        LOG.info("encryptionDomainList={}", Arrays.asList(encryptionDomainList));
        if (Utils.isNullArray((Object[])encryptionDomainList)) {
            return expType.equalsIgnoreCase(devType);
        }
        String domainId = devInfo.getDevPoolAndDiskDomainMapping().get(poolId);
        LOG.info("domainId={}", (Object)domainId);
        if (!Arrays.asList(encryptionDomainList).contains(domainId)) {
            return expType.equalsIgnoreCase(devType);
        }
        return expType.equalsIgnoreCase(devType) || expType.equalsIgnoreCase(devType + " SED") || devType.equalsIgnoreCase(expType + " SED");
    }

    private boolean showWrongMsg(ArrayList<Disk> devDisks, ArrayList<Double> devCapacityList, double expMaxCapacity, double expSecondCapacity, InnerParameter innerParameter) {
        boolean hasSecondCapacity;
        boolean checkMaxCapResult = devDisks.size() == 1 ? this.isSameDiskCapacity(expMaxCapacity, innerParameter.devMaxCapacity) || expMaxCapacity > innerParameter.devMaxCapacity : this.isSameDiskCapacity(expMaxCapacity, innerParameter.devMaxCapacity);
        if (!checkMaxCapResult) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = "";
            boolean hasMaxCapacity = this.hasCapacity(devCapacityList, expMaxCapacity);
            errMsg = this.getErrMsg(devDisks, hasMaxCapacity, innerParameter, true);
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        BigDecimal expense = new BigDecimal("0.0");
        BigDecimal income = new BigDecimal(Double.toString(expSecondCapacity));
        if (expense.subtract(income).abs().compareTo(new BigDecimal("0.000001")) >= 0 && !(hasSecondCapacity = this.hasCapacity(devCapacityList, expSecondCapacity))) {
            String errMsg = this.getErrMsg(devDisks, true, innerParameter, false);
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private String getErrMsg(ArrayList<Disk> devDisks, boolean hasMaxCapacity, InnerParameter innerParameter, boolean isMax) {
        String errMsg;
        if (isMax) {
            if (devDisks.size() < 2) {
                errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskCapacity", (Object[])new Object[]{innerParameter.poolId, innerParameter.engineId, innerParameter.devMaxType});
            } else if (hasMaxCapacity) {
                String diskMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.disk", (Object[])new Object[]{innerParameter.devMaxType, innerParameter.devInputCapacity + innerParameter.devInputUnit});
                errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.onlyDisk", (Object[])new Object[]{innerParameter.poolId, innerParameter.engineId, diskMsg});
            } else {
                errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.enclosureRedundant.capacityNum", (Object[])new Object[]{innerParameter.poolId, innerParameter.engineId});
            }
        } else {
            errMsg = devDisks.size() < 2 ? ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.withoutSmallDisk", (Object[])new Object[]{innerParameter.poolId, innerParameter.engineId}) : ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.enclosureRedundant.capacityNum", (Object[])new Object[]{innerParameter.poolId, innerParameter.engineId});
        }
        return errMsg;
    }

    private boolean hasCapacity(ArrayList<Double> devCapacityList, Double expCapacity) {
        for (double capacity : devCapacityList) {
            if (!this.isSameDiskCapacity(capacity, expCapacity)) continue;
            return true;
        }
        return false;
    }

    private boolean checkExpOnOneType(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        String poolId = key.split("#")[0];
        String engineId = key.split("#")[1];
        String expType = expDisks.get(0).getType();
        Double expCapacity = Double.parseDouble(expDisks.get(0).getCapacity());
        String devType = devDisks.get(0).getType();
        Double devCapacity = Double.parseDouble(devDisks.get(0).getCapacity());
        if (!this.checkDiskType(expType, devType, poolId)) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskType", (Object[])new Object[]{poolId, engineId});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        if (expCapacity < devCapacity) {
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.diskCapacity", (Object[])new Object[]{poolId, engineId, expType});
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean checkExpOnTwoType(ArrayList<Disk> expDisks, ArrayList<Disk> devDisks, String key) {
        String poolId = key.split("#")[0];
        String engineId = key.split("#")[1];
        Double devMaxCapacity = 0.0;
        String devMaxType = "";
        String devInputCapacity = "";
        String devInputUnit = "";
        for (Disk devDisk : devDisks) {
            Double diskCapacity = Double.parseDouble(devDisk.getCapacity());
            if (!(diskCapacity > devMaxCapacity)) continue;
            devMaxCapacity = diskCapacity;
            devMaxType = devDisk.getType();
            devInputCapacity = devDisk.getInputCapacity();
            devInputUnit = devDisk.getInputUnit();
        }
        String expType = expDisks.get(0).getType();
        Double expCapacity = Double.parseDouble(expDisks.get(0).getCapacity());
        if (!expType.equalsIgnoreCase(devMaxType) || !this.isSameDiskCapacity(devMaxCapacity, expCapacity)) {
            String diskMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.disk", (Object[])new Object[]{devMaxType, devInputCapacity + devInputUnit});
            String errMsg = ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.onlyDisk", (Object[])new Object[]{poolId, engineId, diskMsg});
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private boolean isSameDiskCapacity(double diskCapacity1, double diskCapacity2) {
        double deltaCapacty = Math.abs(diskCapacity1 - diskCapacity2);
        return deltaCapacty <= 10.0;
    }

    public boolean checkEnclosureRedundantRules(HashMap<String, EngineDiskInfo> totalEngineDiskInfo) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        HashMap<String, String> domainRedundancyStrategy = devInfo.getDomainRedundancyStrategy();
        HashMap<String, String> devPoolAndDiskDomainMap = devInfo.getDevPoolAndDiskDomainMapping();
        LOG.info("totalEngineDiskInfo:{}", (Object)JSON.toJSONString(totalEngineDiskInfo));
        ArrayList<String> capacityNumProblemDdEng = new ArrayList<String>();
        ArrayList<String> capacityDiskNumProblemDdEng = new ArrayList<String>();
        ArrayList<String> enclosureNumProblemDdEng = new ArrayList<String>();
        for (String key : totalEngineDiskInfo.keySet()) {
            String poolId = key.split("#")[0];
            String ddId = devPoolAndDiskDomainMap.get(poolId);
            if (!domainRedundancyStrategy.get(ddId).equals("Enclosure")) continue;
            EngineDiskInfo newEngineInfo = totalEngineDiskInfo.get(key);
            List<Disk> disks = newEngineInfo.getDisks();
            if ((disks = this.combineSoftEncryptedDisks(disks, poolId)).size() > 2) {
                capacityNumProblemDdEng.add(key);
                continue;
            }
            int enclosureNum = 0;
            boolean checkResult = true;
            for (Disk disk : disks) {
                if (disk.getEnclosureInfo().size() > enclosureNum) {
                    enclosureNum = disk.getEnclosureInfo().size();
                }
                if (Integer.parseInt(disk.getCount()) >= 3) continue;
                capacityDiskNumProblemDdEng.add(key + "#" + disk.getInputCapacity() + disk.getInputUnit());
                checkResult = false;
                break;
            }
            if (!checkResult || enclosureNum >= 4) continue;
            enclosureNumProblemDdEng.add(key);
        }
        if (capacityNumProblemDdEng.size() != 0 || capacityDiskNumProblemDdEng.size() != 0 || enclosureNumProblemDdEng.size() != 0) {
            String errMsg = this.getEnclosureRedundantErrMsg(capacityNumProblemDdEng, capacityDiskNumProblemDdEng, enclosureNumProblemDdEng);
            JDialog mainDialog = InspectContext.getInstance().getMainDialog();
            DialogUtils.showErrorDialog((JDialog)mainDialog, (String)errMsg);
            return false;
        }
        return true;
    }

    private List<Disk> combineSoftEncryptedDisks(List<Disk> disks, String poolId) {
        if (this.filterNotEncryptionPool(poolId)) {
            return disks;
        }
        List<Disk> encryptedDisks = disks.stream().filter(disk -> disk.getType().contains("SED")).map(Disk::partialDiskInfoClone).peek(disk -> disk.setType(disk.getType().split("SED")[0].trim())).collect(Collectors.toList());
        List<Disk> newDisks = disks.stream().filter(disk -> !disk.getType().contains("SED")).map(Disk::partialDiskInfoClone).collect(Collectors.toList());
        this.combineSsdDisks(encryptedDisks, newDisks);
        LOG.info("newDisks is {}", newDisks);
        return newDisks;
    }

    private boolean filterNotEncryptionPool(String errPool) {
        DevInfo4Exp devInfo = InspectContext.getInstance().getDevInfo();
        Object[] encryptionDomainList = devInfo.getEncryptionDiskDomainList();
        if (Utils.isNullArray((Object[])encryptionDomainList)) {
            return true;
        }
        String domainId = devInfo.getDevPoolAndDiskDomainMapping().get(errPool);
        return !Arrays.stream(encryptionDomainList).anyMatch(encryDomain -> encryDomain.equals(domainId));
    }

    private void combineSsdDisks(List<Disk> encryptedDisks, List<Disk> newDisks) {
        encryptedDisks.forEach(encryptedDisk -> this.combineDisks(newDisks, (Disk)encryptedDisk));
    }

    private void combineDisks(List<Disk> newDisks, Disk encryptedDisk) {
        for (Disk tempDisk : newDisks) {
            if (!this.needCombine(encryptedDisk, tempDisk)) continue;
            tempDisk.setEnclosureInfo(this.getTempDiskEnclosureInfo(tempDisk, encryptedDisk));
            tempDisk.setCount(this.getTempDiskCount(tempDisk, encryptedDisk));
            return;
        }
        newDisks.add(encryptedDisk);
    }

    private String getTempDiskCount(Disk tempDisk, Disk encryptedDisk) {
        return String.valueOf(Integer.parseInt(tempDisk.getCount()) + Integer.parseInt(encryptedDisk.getCount()));
    }

    private ArrayList<DiskEnclosure> getTempDiskEnclosureInfo(Disk tempDisk, Disk encryptedDisk) {
        ArrayList<DiskEnclosure> diskEnclosures = new ArrayList<DiskEnclosure>(tempDisk.getEnclosureInfo());
        diskEnclosures.addAll(encryptedDisk.getEnclosureInfo());
        return diskEnclosures;
    }

    private boolean needCombine(Disk encryptedDisk, Disk tempDisk) {
        return encryptedDisk.getType().equals(tempDisk.getType()) && this.isSameDiskCapacity(Double.parseDouble(encryptedDisk.getCapacity()), Double.parseDouble(tempDisk.getCapacity()));
    }

    private String getEnclosureRedundantErrMsg(ArrayList<String> capacityNumProblemDdEng, ArrayList<String> capacityDiskNumProblemDdEng, ArrayList<String> enclosureNumProblemDdEng) {
        Object[] keys;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ResourceUtil.getString((String)"inspect.wizard.strategysetting.checkDiskConfig.enclosureRedundant"));
        if (capacityNumProblemDdEng.size() != 0) {
            for (String problemKey : capacityNumProblemDdEng) {
                keys = problemKey.split("#");
                stringBuilder.append(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.enclosureRedundant.capacityNum", (Object[])keys));
            }
        }
        if (capacityDiskNumProblemDdEng.size() != 0) {
            for (String problemKey : capacityDiskNumProblemDdEng) {
                keys = problemKey.split("#");
                stringBuilder.append(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.enclosureRedundant.capacityDiskNum", (Object[])keys));
            }
        }
        if (enclosureNumProblemDdEng.size() != 0) {
            for (String problemKey : enclosureNumProblemDdEng) {
                keys = problemKey.split("#");
                stringBuilder.append(ResourceUtil.getStringWithParams((String)"inspect.wizard.strategysetting.checkDiskConfig.enclosureRedundant.enclosureNum", (Object[])keys));
            }
        }
        return stringBuilder.toString();
    }

    private class InnerParameter {
        String crossEngs = "";
        String diskDd = "";
        String ctrls = "";
        String diskModelDisplay = "";
        String diskWorkMode;
        String expDiskMode;
        String diskType;
        String diskCap;
        String capUnit;
        String diskNum;
        String diskEnclosureId = ResourceUtil.getString((String)"inspect.wizard.strategysetting.diskenclosure.noneed");
        boolean isolation = false;
        String diskExpMode;
        double devMaxCapacity;
        String devInputUnit;
        String devInputCapacity;
        String devMaxType;
        String poolId;
        String engineId;

        private InnerParameter() {
        }
    }
}

