/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public enum RiskIdPrefixEnum {
    DISTRIBUTED("storage_distributed", Arrays.asList(ItDeviceType.DStorage, ItDeviceType.FUSIONCUBE, ItDeviceType.DATATURBO)),
    HOST("storage_host", Collections.singletonList(ItDeviceType.Host)),
    DPA("storage_dpa", Collections.singletonList(ItDeviceType.DPA)),
    SWITCH("storage_switch", Collections.singletonList(ItDeviceType.Switch)),
    UNIFIED("storage_unified", Collections.singletonList(ItDeviceType.Storage));

    private final String prefix;
    private final List<ItDeviceType> itDeviceTypes;

    public static String getRiskPrefixByDevType(DevNode devNode) {
        return Arrays.stream(RiskIdPrefixEnum.values()).filter(value -> value.getItDeviceTypes().contains(devNode.getItDeviceType())).findFirst().orElse(UNIFIED).getPrefix();
    }

    @Generated
    private RiskIdPrefixEnum(String prefix, List<ItDeviceType> itDeviceTypes) {
        this.prefix = prefix;
        this.itDeviceTypes = itDeviceTypes;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public List<ItDeviceType> getItDeviceTypes() {
        return this.itDeviceTypes;
    }
}

