/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.entity;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.logic.inspector.IProgressObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiUpdatePair
implements IProgressObserver {
    private static final Logger LOG = LoggerFactory.getLogger(UiUpdatePair.class);
    private InspectStatus inspectStatus;
    private InspectStatus itemStatus;
    private boolean finished;
    private CheckDevNode checkDevNode;
    private int progress;
    private final List<Record> runningRecords = Collections.synchronizedList(new ArrayList());
    private DefaultListModel listMode = new DefaultListModel();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateProgress(int progrezz) {
        if (0 > progrezz || 100 < progrezz) {
            LOG.error("invalid progress form script: " + progrezz);
            return;
        }
        List<Record> list = this.runningRecords;
        synchronized (list) {
            if (!this.runningRecords.isEmpty() && this.runningRecords.get(0).getProgress() == progrezz) {
                return;
            }
            for (Record record : this.runningRecords) {
                record.setProgress(progrezz);
            }
        }
        this.updateUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateProgress(Map<String, Integer> progressMap) {
        List<Record> list = this.runningRecords;
        synchronized (list) {
            for (Record record : this.runningRecords) {
                CheckItem item = record.getCheckItem();
                if (item == null) {
                    LOG.error("item is empty.");
                    continue;
                }
                Integer pro = progressMap.get(item.getItemId());
                if (null == pro || 0 > pro || 100 < pro) {
                    LOG.error("invalid progress form script: " + pro);
                    continue;
                }
                record.setProgress(pro);
            }
        }
        this.updateUI();
    }

    private void updateUI() {
        if (InspectContext.getInstance().isBackgroundMode()) {
            return;
        }
        SwingUtilities.invokeLater(() -> InspectContext.getInstance().getPerformInspectCard().updateDetailList(this.checkDevNode));
    }

    public void updateNodeTabelStatus(String batchRadioDesc, Map<String, Integer> ipBatchMap, Map<String, String> ipStatusMap) {
        if (InspectContext.getInstance().isBackgroundMode()) {
            return;
        }
        SwingUtilities.invokeLater(() -> InspectContext.getInstance().getPerformInspectCard().updateNodeTabelStatus(this.checkDevNode, batchRadioDesc, ipBatchMap, ipStatusMap));
    }

    public InspectStatus getInspectStatus() {
        return this.inspectStatus;
    }

    public void setInspectStatus(InspectStatus inspectStatus) {
        this.inspectStatus = inspectStatus;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public DefaultListModel getListMode() {
        return this.listMode;
    }

    public void setListMode(DefaultListModel listMode) {
        this.listMode = listMode;
    }

    public CheckDevNode getCheckDevNode() {
        return this.checkDevNode;
    }

    public void setCheckDevNode(CheckDevNode checkDevNode) {
        this.checkDevNode = checkDevNode;
    }

    public Record getRecord(int index) {
        return this.runningRecords.get(index);
    }

    public int getRecordSize() {
        return this.runningRecords.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllRecords() {
        List<Record> list = this.runningRecords;
        synchronized (list) {
            this.runningRecords.clear();
        }
    }

    public boolean isRecordsEmpty() {
        return this.runningRecords.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAllRecords(List<Record> list) {
        List<Record> list2 = this.runningRecords;
        synchronized (list2) {
            return this.runningRecords.addAll(list);
        }
    }

    public void addRecords(Record record) {
        this.runningRecords.add(record);
    }

    @Generated
    public InspectStatus getItemStatus() {
        return this.itemStatus;
    }

    @Generated
    public void setItemStatus(InspectStatus itemStatus) {
        this.itemStatus = itemStatus;
    }
}

