/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.broker.client.BrokerClient;
import com.huawei.fitframework.exception.FitException;
import com.huawei.fitframework.plugin.Plugin;
import com.huawei.fitframework.plugin.PluginManager;
import com.huawei.fitframework.runtime.PluginActivator;
import com.huawei.ism.thread.AsyncExcutor;
import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.devicemanager.service.implement.DefaultNodeProviderImpl;
import com.huawei.ism.tool.framework.init.FrameworkInitiator;
import com.huawei.ism.tool.framework.platform.util.LanguageManager;
import com.huawei.ism.tool.inspect.fit.service.device.ClusterNodeObserver;
import com.huawei.ism.tool.inspect.fit.util.BrokerClientUtil;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.inspect.ui.logic.SilentUpdateHelpFileRunnable;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.sdk.unified.log.UnifiedLogConfigurator;
import com.huawei.ism.tool.sdk.unified.log.exception.UnifiedLogException;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class PluginActivatorImpl
implements PluginActivator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PluginActivatorImpl.class);
    private static final String PLUGIN_ID = "inspector";
    @Fit
    PluginManager manager;
    @Fit
    BrokerClient brokerClient;

    public void start() {
        try {
            UnifiedLogConfigurator.initializeWithDefaultConfig();
        }
        catch (UnifiedLogException exception) {
            log.error("initialize unified log config failed", (Throwable)exception);
        }
        Optional opt = this.manager.get(PLUGIN_ID);
        if (!opt.isPresent()) {
            throw new FitException("can not find plugin inspector");
        }
        File file = ((Plugin)opt.get()).getBaseDirectory();
        try {
            FrameworkInitiator.init((String)file.getCanonicalPath());
            LanguageManager.getInstance().setCurrentLanguage(PluginActivatorImpl.getLan(System.getenv("language")));
            BrokerClientUtil.setBrokerClient(this.brokerClient);
            AsyncExcutor.submit((Runnable)new SilentUpdateHelpFileRunnable());
            SysConfiguration.getInstance().initSysconf();
            DefaultNodeProviderImpl.getInstance().addNodeObservers((INodeObserver)new ClusterNodeObserver());
            FrameworkInitiator.loadServiceFromCfg();
        }
        catch (IOException e) {
            throw new FitException("inspector init failed.", (Throwable)e);
        }
    }

    private static Locale getLan(String language) {
        Locale lan = Locale.ENGLISH;
        if (!StringUtils.isNULLStr((String)language) && language.startsWith("zh")) {
            lan = Locale.SIMPLIFIED_CHINESE;
        }
        return lan;
    }

    public void stop() {
        log.info("Exit plugin {}", (Object)PLUGIN_ID);
        InspectContext.getInstance().destroyContext();
    }
}

