/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit;

import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.CheckItem;
import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import com.huawei.ism.tool.inspect.entity.UiUpdatePair;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.fit.util.TaskInfoUtil;
import com.huawei.ism.tool.inspect.logic.inspector.IUiObserver;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.inspect.utils.InspectUIUtil;
import com.huawei.ism.tool.inspect.utils.InspectUtils;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.DefaultListModel;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunningObserver
implements IUiObserver {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskRunningObserver.class);
    private static final int MAX_PROGRESS = 100;
    private volatile ResultStatus status = ResultStatus.WAITED;
    private final InspectWorktaker workTaker;

    public TaskRunningObserver(InspectWorktaker workTaker) {
        this.workTaker = workTaker;
    }

    @Override
    public void init() {
        this.status = ResultStatus.WAITED;
    }

    @Override
    public void start() {
        this.status = ResultStatus.RUNNING;
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String message, int step, Calendar calendar) {
        this.update(checkDev, checkItem, message, step, calendar, RecordStatus.NORMAL);
    }

    @Override
    public void update(CheckDevNode checkDev, CheckItem checkItem, String message, int step, Calendar time, RecordStatus status) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        List<Record> records = InspectUIUtil.initRecords(checkDev, checkItem, message, time, status);
        ui = InspectUIUtil.initUiUpdatePair(ui, checkDev, step);
        InspectUIUtil.updateRecordStatus(ui, checkItem, status, records);
        DefaultListModel model = ui.getListMode();
        records.forEach(rec -> {
            rec.setStatus(status);
            model.addElement(rec);
        });
    }

    @Override
    public void finished(CheckDevNode checkDev) {
        log.info("Dev inspect {} finished.", (Object)checkDev.getDevNodeSafe().getIp());
        UiUpdatePair ui = InspectUIUtil.updateUiUpdatePairWhenFinished(checkDev);
        InspectUIUtil.syncItemFailedWhenExecFailed(this, checkDev, ui);
        ui.setFinished(true);
        ui.setProgress(100);
        if (!checkDev.isExecuteSuc()) {
            ui.setInspectStatus(InspectStatus.EXEFALID);
            return;
        }
        int faultNum = InspectUtils.checkFaultItemNum(checkDev);
        ui.setInspectStatus(faultNum == 0 ? InspectStatus.EXECPASS : InspectStatus.EXECNOTPASS);
    }

    @Override
    public void finishAll(long during) {
        try {
            List<DevNode> devNodes = this.workTaker.getSelectedDevNodes();
            if (devNodes == null || devNodes.isEmpty()) {
                this.status = ResultStatus.FAILED;
                return;
            }
            List<CheckDevNode> checkDevNodes = devNodes.stream().map(this.workTaker::matchCheckDevNode).filter(Objects::nonNull).collect(Collectors.toList());
            this.status = TaskInfoUtil.calcTotalStatus(checkDevNodes);
        }
        catch (Exception e) {
            log.error("Finished task exception", (Throwable)e);
        }
    }

    @Override
    public boolean isFinished() {
        return this.status.isFinished();
    }

    @Override
    public void updateAllStatus(InspectStatus status) {
        List<DevNode> devNodes = this.workTaker.getSelectedDevNodes();
        if (devNodes == null || devNodes.isEmpty()) {
            return;
        }
        devNodes.stream().map(this.workTaker::matchCheckDevNode).filter(Objects::nonNull).map(this::getUiUpdatePair).forEach(uiUpdatePair -> uiUpdatePair.setInspectStatus(status));
    }

    private UiUpdatePair getUiUpdatePair(CheckDevNode checkDevNode) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDevNode);
        if (ui == null) {
            InspectUIUtil.initUiUpdatePair(null, checkDevNode, 0);
        }
        return InspectContext.getInstance().getUiUpdatePair(checkDevNode);
    }

    @Override
    public void updateReporttingMsg(String msg) {
    }

    @Override
    public void updateCurrentStatus(CheckDevNode checkDev, RecordStatus status) {
        UiUpdatePair ui = InspectContext.getInstance().getUiUpdatePair(checkDev);
        if (!ui.isRecordsEmpty()) {
            ui.getRecord(ui.getRecordSize() - 1).setStatus(status);
        }
    }

    @Override
    public void updateChildItems(CheckDevNode checkDev, Map<String, Object> jsonMsg) {
        List<CheckItem> checkItems = InspectUIUtil.convertMsg2CheckItems(jsonMsg);
        for (CheckItem checkItem : checkItems) {
            RecordStatus recordStatus = checkItem.getCheckResult().getRecordStatus();
            Calendar time = Calendar.getInstance();
            String name = checkItem.getName();
            this.update(checkDev, checkItem, name, 0, time, recordStatus);
            if (recordStatus.isRunning()) continue;
            InspectContext.getInstance().setInnerCheckResult(checkDev.getDevNode().getIp(), checkItem);
        }
    }
}

