/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.common;

import com.huawei.ism.tool.inspect.logic.config.InspectSceneValue;
import com.huawei.ism.tool.inspect.utils.HtmlResUtils;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.service.patch.dstorage.Context;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public enum InspectScene {
    REAL_TIME_CHECK("realTimed_check"),
    BUREAU_CHECK("bureau_check"),
    BUREAU_CHECK_NFV("bureau_check_nfv"),
    PRE_UPGRADE_CHECK("pre_upgrade_check"),
    AFTER_UPGRADE_CHECK("after_upgrade_check"),
    DISTRIBUTED_EXPANSION("FsExpansion"),
    STORAGE_CONFIG("storage_config");

    static Map<InspectScene, String> itemScene;
    static Map<InspectScene, String> reportScene;
    String sceneId;

    public static InspectScene of(String name) {
        return Arrays.stream(InspectScene.values()).filter(scene -> scene.getSceneId().equals(name)).findFirst().orElse(REAL_TIME_CHECK);
    }

    public static boolean support(String name) {
        return Arrays.stream(InspectScene.values()).anyMatch(scene -> scene.getSceneId().equals(name));
    }

    public void initContextScene() {
        if (this == DISTRIBUTED_EXPANSION) {
            InspectScene.initDistributedExpansion();
            return;
        }
        if (this == BUREAU_CHECK) {
            InspectSceneValue sceneValue = new InspectSceneValue("Opening Delivery", "Quality Checks", "Storage");
            InspectContext.getInstance().setInspectSceneValue(sceneValue);
            InspectContext.getInstance().setBureauCheckSelected(true);
            return;
        }
        if (this == BUREAU_CHECK_NFV) {
            InspectSceneValue sceneValue = new InspectSceneValue("Opening Delivery", "Quality Checks", "Storage");
            InspectContext.getInstance().setInspectSceneValue(sceneValue);
            InspectContext.getInstance().setNfvMode(true);
            Context.INS.setNfvMode(true);
            InspectContext.getInstance().setBureauCheckSelected(true);
            return;
        }
        if (this == STORAGE_CONFIG) {
            HtmlResUtils.init(this);
            InspectSceneValue sceneValue = new InspectSceneValue("Opening Delivery", "Storage Config", "Storage");
            InspectContext.getInstance().setInspectSceneValue(sceneValue);
            InspectContext.getInstance().initToolScene();
            InspectContext.getInstance().setNfvMode(false);
            Context.INS.setNfvMode(false);
            InspectContext.getInstance().setBureauCheckSelected(false);
            return;
        }
        this.initDefault();
    }

    public String getItemScene() {
        return itemScene.getOrDefault((Object)this, "realTimed_check");
    }

    public String getReportScene() {
        return reportScene.getOrDefault((Object)this, "realTimed_check");
    }

    private static void initDistributedExpansion() {
        InspectSceneValue sceneValue = new InspectSceneValue("Expansion", "Fusionstorage Expansion Evaluation", "Storage");
        InspectContext.getInstance().setInspectSceneValue(sceneValue);
        HtmlResUtils.init();
        InspectContext.getInstance().initToolScene();
    }

    private void initDefault() {
        InspectContext.getInstance().setInspectSceneValue(null);
        HtmlResUtils.init();
        InspectContext.getInstance().initToolScene();
        InspectContext.getInstance().setNfvMode(false);
        Context.INS.setNfvMode(false);
        InspectContext.getInstance().setBureauCheckSelected(false);
    }

    @Generated
    private InspectScene(String sceneId) {
        this.sceneId = sceneId;
    }

    @Generated
    public String getSceneId() {
        return this.sceneId;
    }

    static {
        itemScene = new HashMap<InspectScene, String>();
        reportScene = new HashMap<InspectScene, String>();
        itemScene.put(REAL_TIME_CHECK, "realTimed_check");
        itemScene.put(BUREAU_CHECK, "site_deployment_check");
        itemScene.put(PRE_UPGRADE_CHECK, "pre_upgrade_check");
        itemScene.put(AFTER_UPGRADE_CHECK, "realTimed_check");
        itemScene.put(DISTRIBUTED_EXPANSION, "realTimed_check");
        itemScene.put(BUREAU_CHECK_NFV, "site_deployment_check");
        itemScene.put(STORAGE_CONFIG, "storage_config");
        reportScene.put(REAL_TIME_CHECK, "realTimed_check");
        reportScene.put(BUREAU_CHECK, "bureau_check");
        reportScene.put(PRE_UPGRADE_CHECK, "realTimed_check");
        reportScene.put(AFTER_UPGRADE_CHECK, "realTimed_check");
        reportScene.put(DISTRIBUTED_EXPANSION, "realTimed_check");
        reportScene.put(BUREAU_CHECK_NFV, "bureau_check");
        reportScene.put(STORAGE_CONFIG, "storage_config");
    }
}

