/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.entity.task;

import com.huawei.ism.tool.inspect.entity.InspectStatus;
import com.huawei.ism.tool.inspect.entity.RecordStatus;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public enum ResultStatus {
    WAITED("waited"),
    RUNNING("running"),
    SUCCESS("success"),
    PART_SUCCESS("part_success"),
    FAILED("failed"),
    INFO("info"),
    CONFIGURED("configured"),
    NOT_CONFIGURED("not_configured"),
    UNKNOWN("unknown"),
    PASS("pass"),
    NOT_PASS("not_pass"),
    NOT_SUPPORT("not_support"),
    NO_CHECK("no_check"),
    WARING("warning"),
    MANUAL_CONFIRM("manual_confirm");

    private static final EnumSet<ResultStatus> FINISHED_STATUS;
    private static final EnumSet<ResultStatus> RUNNING_STATUS;
    private static final EnumSet<ResultStatus> WAITING_STATUS;
    private static final EnumSet<ResultStatus> SUCCESS_STATUS;
    private static final EnumSet<ResultStatus> FAILED_STATUS;
    private static final Map<String, ResultStatus> STATUS_COVER;
    private final String key;

    private ResultStatus(String status) {
        this.key = status;
    }

    public static String of(String statusKey, ResultStatus defaultStatus) {
        return STATUS_COVER.getOrDefault(statusKey, defaultStatus).getKey();
    }

    public static String of(String statusKey) {
        return ResultStatus.of(statusKey, UNKNOWN);
    }

    public static ResultStatus from(String statusStr) {
        String standStatus = ResultStatus.of(statusStr);
        return Arrays.stream(ResultStatus.values()).filter(status -> status.getKey().equals(standStatus)).findFirst().orElse(UNKNOWN);
    }

    public boolean isFinished() {
        return FINISHED_STATUS.contains((Object)this);
    }

    public boolean isRunning() {
        return RUNNING_STATUS.contains((Object)this);
    }

    public boolean isWaiting() {
        return WAITING_STATUS.contains((Object)this);
    }

    public boolean isSuccess() {
        return SUCCESS_STATUS.contains((Object)this);
    }

    public boolean isFailed() {
        return FAILED_STATUS.contains((Object)this);
    }

    @Generated
    public String getKey() {
        return this.key;
    }

    static {
        FINISHED_STATUS = EnumSet.of(SUCCESS, new ResultStatus[]{FAILED, INFO, PASS, NOT_PASS, NOT_SUPPORT, NO_CHECK, WARING, MANUAL_CONFIRM, PART_SUCCESS});
        RUNNING_STATUS = EnumSet.of(RUNNING);
        WAITING_STATUS = EnumSet.of(WAITED);
        SUCCESS_STATUS = EnumSet.of(SUCCESS, PASS);
        FAILED_STATUS = EnumSet.of(PART_SUCCESS, FAILED, NOT_PASS, NO_CHECK);
        ConcurrentHashMap<String, ResultStatus> temp = new ConcurrentHashMap<String, ResultStatus>();
        temp.put(InspectStatus.WAITING.getKey(), WAITED);
        temp.put(InspectStatus.EXECUTING.getKey(), RUNNING);
        temp.put(InspectStatus.EXESUC.getKey(), SUCCESS);
        temp.put(InspectStatus.EXEFALID.getKey(), FAILED);
        temp.put(InspectStatus.EXECPASS.getKey(), PASS);
        temp.put(InspectStatus.EXECNOTPASS.getKey(), NOT_PASS);
        temp.put(RecordStatus.NORMAL.toString(), SUCCESS);
        temp.put(FAILED.toString(), FAILED);
        temp.put(RecordStatus.INTERRUPPED.toString(), FAILED);
        temp.put(INFO.toString(), INFO);
        temp.put(RUNNING.toString(), RUNNING);
        temp.put(RecordStatus.RETRY.toString(), RUNNING);
        temp.put(RecordStatus.PROCESSING.toString(), RUNNING);
        temp.put("0", PASS);
        temp.put("1", NOT_PASS);
        temp.put("2", NO_CHECK);
        temp.put("3", NOT_SUPPORT);
        temp.put("4", WARING);
        temp.put("5", MANUAL_CONFIRM);
        STATUS_COVER = Collections.unmodifiableMap(temp);
    }
}

