/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.CheckDevNodeUtil;
import com.huawei.ism.tool.inspect.fit.validator.IValidator;
import com.huawei.ism.tool.inspect.fit.validator.impl.DevExistValidator;
import com.huawei.ism.tool.inspect.fit.validator.impl.TaskExistValidator;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItems;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.QueryItemParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.item.entity.DeviceCheckItemTreeNodeDTO;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class CheckItemServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CheckItemServerImpl.class);
    @Fit
    private TaskWorkerManager workerManager;
    @Fit
    private CheckDevNodeUtil checkDevNodeUtil;
    private List<IValidator> paramValidators;

    public CheckItemServerImpl(TaskWorkerManager workerManager, CheckDevNodeUtil checkDevNodeUtil) {
        this.workerManager = workerManager;
        this.checkDevNodeUtil = checkDevNodeUtil;
        this.paramValidators = Arrays.asList(new TaskExistValidator(this.workerManager), new DevExistValidator(this.workerManager));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Fitable(generic=QueryItems.class, id="5d80a19dd7b848d19cae64ee925350f5")
    public synchronized Response<DeviceCheckItemTreeNodeDTO> queryItems(QueryItemParams params) {
        try {
            this.validateParams(params);
            InspectScene inspectScene = InspectScene.of(params.getScene());
            inspectScene.initContextScene();
            DeviceCheckItemTreeNodeDTO checkItemTreeNodeDto = this.checkDevNodeUtil.getDeviceCheckItemTreeNodeDto(params.getTaskId(), params.getDevId(), params.getScene());
            Response response = ResponseUtil.success((Object)checkItemTreeNodeDto);
            return response;
        }
        catch (ToolException e) {
            log.error("Query items error. ", (Throwable)e);
            Response response = ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
            return response;
        }
        catch (Exception e) {
            log.error("Query items error. ", (Throwable)e);
            Response response = ResponseUtil.failed((String)ResourceUtil.getString((String)"inspector.unknown.error"), (String)"");
            return response;
        }
        finally {
            InspectScene.REAL_TIME_CHECK.initContextScene();
        }
    }

    public void validateParams(QueryItemParams params) throws ToolException {
        for (IValidator validator : this.paramValidators) {
            validator.validator(params.getTaskId(), params.getDevId());
        }
    }

    @Generated
    public void setWorkerManager(TaskWorkerManager workerManager) {
        this.workerManager = workerManager;
    }

    @Generated
    public void setCheckDevNodeUtil(CheckDevNodeUtil checkDevNodeUtil) {
        this.checkDevNodeUtil = checkDevNodeUtil;
    }

    @Generated
    public void setParamValidators(List<IValidator> paramValidators) {
        this.paramValidators = paramValidators;
    }
}

