/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.inspect.fit.service.device.ClusterNodeObserver;
import com.huawei.ism.tool.inspect.fit.service.device.auth.entity.AuthStatusEnum;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.validator.IValidator;
import com.huawei.ism.tool.inspect.fit.validator.impl.DevExistValidator;
import com.huawei.ism.tool.inspect.fit.validator.impl.TaskExistValidator;
import com.huawei.ism.tool.inspect.utils.CheckItemUtils;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.AuthStatus;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryClusterNodes;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.device.entity.ClusterTreeNodeDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.device.entity.ClusterTreeNodesDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.QueryClusterNodesParams;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ClusterNodeServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterNodeServerImpl.class);
    @Fit
    private QueryServer queryServer;
    @Fit
    private final TaskWorkerManager workerManager;
    @Fit
    private final DevUtil devUtil;
    private List<IValidator> paramValidators;

    ClusterNodeServerImpl(TaskWorkerManager workerManager, DevUtil devUtil) {
        this.workerManager = workerManager;
        this.devUtil = devUtil;
        this.paramValidators = Arrays.asList(new TaskExistValidator(this.workerManager), new DevExistValidator(this.workerManager));
    }

    @Fitable(generic=QueryClusterNodes.class, id="db5da4fb47fe4824acd90eeb8d3adc95")
    public Response<ClusterTreeNodesDTO> queryClusterNodes(QueryClusterNodesParams params) {
        try {
            this.validate(params);
            DevNode node = this.devUtil.findDevNode(params.getTaskId(), params.getDevId());
            this.initClusterNode(node);
            return ResponseUtil.success((Object)this.buildClusterTreeNodesDto(node, node.getClusterNodes()));
        }
        catch (ToolException e) {
            return ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
        }
        catch (Exception e) {
            log.error("Query cluster node error. ", (Throwable)e);
            return ResponseUtil.failed((String)ResourceUtil.getString((String)"inspector.unknown.error"), (String)"");
        }
    }

    private void initClusterNode(DevNode node) throws ToolException {
        if (!this.devUtil.initDistributedDevNode(node, true)) {
            return;
        }
        new ClusterNodeObserver().fireNodeAdd(node);
    }

    private void validate(QueryClusterNodesParams params) throws ToolException {
        for (IValidator validator : this.paramValidators) {
            validator.validator(params.getTaskId(), params.getDevId());
        }
    }

    ClusterTreeNodesDTO buildClusterTreeNodesDto(DevNode node, List<ClusterNode> clusterNodes) {
        return ClusterTreeNodesDTO.builder().clusterTreeNodeDTO(clusterNodes.stream().map(clusterNode -> {
            String uid = DevUtil.getClusterNodeUid(node, clusterNode);
            Server server = this.queryServer.process(uid);
            return ClusterTreeNodeDTO.builder().uid(uid).id(Integer.valueOf(clusterNode.getId())).hostName(clusterNode.getName()).managerIp(clusterNode.getManagementIp()).roles(new ArrayList(clusterNode.getRoles())).bmcIp(clusterNode.getBmcIp()).selected(Boolean.valueOf(clusterNode.isSelected())).serialNumber(clusterNode.getSerialNumber()).bmcAuthStatus(ClusterNodeServerImpl.getBmcAuthStatus(clusterNode, server)).osAuthStatus(ClusterNodeServerImpl.getOsAuthStatus(clusterNode, server)).nodeStatus(clusterNode.getStatus().getStatus()).build();
        }).collect(Collectors.toList())).build();
    }

    private static AuthStatus getOsAuthStatus(ClusterNode clusterNode, Server server) {
        if (!CheckItemUtils.needAuth(clusterNode) || clusterNode.isDirectPlanesNode()) {
            return AuthStatus.builder().status(AuthStatusEnum.NOT_SUPPORT.getKey()).description("").build();
        }
        if (server == null || server.getOsAuthStatus() == null) {
            return AuthStatus.builder().status(AuthStatusEnum.UN_AUTH.getKey()).description("").build();
        }
        return server.getOsAuthStatus();
    }

    private static AuthStatus getBmcAuthStatus(ClusterNode clusterNode, Server server) {
        if (!CheckItemUtils.needAuth(clusterNode)) {
            return AuthStatus.builder().status(AuthStatusEnum.NOT_SUPPORT.getKey()).description("").build();
        }
        if (server == null || server.getBmcAuthStatus() == null) {
            return AuthStatus.builder().status(AuthStatusEnum.UN_AUTH.getKey()).description("").build();
        }
        return server.getBmcAuthStatus();
    }

    @Generated
    public void setQueryServer(QueryServer queryServer) {
        this.queryServer = queryServer;
    }
}

