/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.UpdateDevOsIp;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.UpdateOsIpParam;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class DeployQualityInspectionServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeployQualityInspectionServiceImpl.class);
    @Fit
    private final DevUtil devUtil;

    @Fitable(generic=UpdateDevOsIp.class, id="ceb7a0db953e4f1fb818d67e4b3875f1")
    public Response<Boolean> updateDevOsIp(UpdateOsIpParam param) {
        String validateMsg = this.validateUpdateParam(param);
        if (!StringUtils.isNULLStr((String)validateMsg)) {
            return ResponseUtil.failed((String)validateMsg, (String)"");
        }
        DevNode devNode = this.devUtil.findDevNode(param.getTaskId(), param.getDevId());
        if (Objects.isNull(devNode)) {
            return ResponseUtil.failed((String)ResourceUtil.getString((String)"update.os.ip.not.find.dev"), (String)"");
        }
        devNode.getClusterNodes().stream().filter(clusterNode -> Objects.equals(param.getId(), clusterNode.getId())).findFirst().ifPresent(clusterNode -> clusterNode.setManagementIp(param.getOsIp()));
        return ResponseUtil.success((Object)true);
    }

    private String validateUpdateParam(UpdateOsIpParam param) {
        if (StringUtils.hasNULLStr((String[])new String[]{param.getTaskId(), param.getDevId(), param.getOsIp()}) || param.getId() <= 0) {
            return ResourceUtil.getString((String)"update.os.ip.param.invalid");
        }
        if (!StringUtils.isValidIPV4((String)param.getOsIp()) && !StringUtils.isIpv6Address((String)param.getOsIp())) {
            return ResourceUtil.getString((String)"update.os.ip.invalid");
        }
        return "";
    }

    @Generated
    public DeployQualityInspectionServiceImpl(DevUtil devUtil) {
        this.devUtil = devUtil;
    }
}

