/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.base.utils.AESEncrypt;
import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.inspect.entity.FsNodeExpansionConfig;
import com.huawei.ism.tool.inspect.fit.common.ExpansionNodesManager;
import com.huawei.ism.tool.inspect.fit.service.StoragePoolInfoService;
import com.huawei.ism.tool.inspect.fit.service.expansion.ExpansionConfigManager;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.util.ExpansionUtils;
import com.huawei.ism.tool.inspect.fit.util.VerifyLld;
import com.huawei.ism.tool.inspect.utils.InspectContext;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.DiskTypeEnum;
import com.huawei.ism.tool.obase.entity.FusionStorDiskInfo;
import com.huawei.ism.tool.obase.entity.FusionStorStoragePool;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.inspect.entity.ExpansionModeEnum;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryExpansionConfig;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.QueryExpansionNodes;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionConfig;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.ExpansionNode;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiExpansionConfig;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.entity.MultiExpansionNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class ExpansionImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExpansionImpl.class);
    private static final int SUCCESS = 0;
    private static final String DOUBLE_HORIZONTAL_BAR = "--";
    @Fit
    ExpansionConfigManager expansionConfigManager;
    @Fit
    ExpansionNodesManager expansionNodesManager;
    @Fit
    ExpansionUtils expansionUtils;
    @Fit
    StoragePoolInfoService storagePoolInfoService;
    @Fit
    QueryExpansionConfig queryExpansionConfig;
    @Fit
    QueryExpansionNodes queryExpansionNodes;
    @Fit
    DevUtil devUtil;
    private Set<String> errorInfos = new HashSet<String>();
    private final Map<ExpansionModeEnum, BiFunction<DevNode, ExpansionConfig, String>> executeMode = new ConcurrentHashMap<ExpansionModeEnum, BiFunction<DevNode, ExpansionConfig, String>>();

    public ExpansionImpl() {
        this.executeMode.put(ExpansionModeEnum.EXPANSION_DISK, this::expansionDisk);
        this.executeMode.put(ExpansionModeEnum.EXPANSION_NODE, this::expansionNode);
        this.executeMode.put(ExpansionModeEnum.CREAT_STORAGE_POOL, this::creatStoragePools);
        this.executeMode.put(ExpansionModeEnum.CREAT_STORAGE_DISK_POOL, this::creatDiskPools);
    }

    public void bindingExpansionInformation(String taskId, List<DevNode> devNodes) throws ToolException {
        for (DevNode devNode2 : devNodes) {
            VerifyLld verify = new VerifyLld();
            List<ExpansionConfig> expansionConfigs = this.getExpansionConfigs(taskId, devNode2);
            verify.verifyExpansionInfo(expansionConfigs, devNode2);
            this.initStoragePool(devNode2, taskId);
            verify.verifyExistDiskPoolName(expansionConfigs, devNode2);
            verify.verifyNewExpansionNodes(expansionConfigs, devNode2);
            verify.verifyExistExpansionNodes(expansionConfigs, devNode2);
        }
        List errors = devNodes.stream().flatMap(devNode -> this.configExpansionInformation(taskId, (DevNode)devNode).stream()).filter(error -> !DOUBLE_HORIZONTAL_BAR.equals(error)).collect(Collectors.toList());
        if (!CollectionUtil.isEmpty(errors)) {
            log.error("Failed to bind cluster expansion information.");
            throw new ToolException(String.join((CharSequence)";", errors), false);
        }
        log.info("The capacity expansion information is bound successfully.");
    }

    private void initDevNodeTaskId(DevNode devNode, String taskId) {
        devNode.setTaskId(taskId);
        devNode.getClusterNodes().forEach(clusterNode -> clusterNode.setTaskId(taskId));
    }

    private void initStoragePool(DevNode devNode, String taskId) throws ToolException {
        devNode.setClusterNodes(Collections.emptyList());
        devNode.getStoragePools().clear();
        this.devUtil.initDistributedDevNode(devNode);
        this.initDevNodeTaskId(devNode, taskId);
        if (!this.storagePoolInfoService.queryStorageInfo(devNode)) {
            log.error("Failed to set the capacity expansion information.");
            throw new ToolException(ResourceUtil.getString((String)"fit.query.storage.info.error"));
        }
    }

    private Set<String> configExpansionInformation(String taskId, DevNode devNode) {
        this.errorInfos.clear();
        try {
            this.updateExpansionNode(taskId, devNode);
            List<ExpansionConfig> expansionConfigs = this.getExpansionConfigs(taskId, devNode);
            List errors = expansionConfigs.stream().map(expansionConfig -> this.expansionDateDetail(devNode, (ExpansionConfig)expansionConfig)).collect(Collectors.toList());
            this.errorInfos.addAll(errors);
            VerifyLld.afterBindVerifyBlockDiskPool(devNode);
        }
        catch (ToolException e) {
            this.errorInfos.add(e.getErrorLocaleDescription());
        }
        return this.errorInfos;
    }

    private String expansionDateDetail(DevNode devNode, ExpansionConfig expansionConfig) {
        try {
            return this.executeMode.get(ExpansionModeEnum.of((String)expansionConfig.getExpansionMode())).apply(devNode, expansionConfig);
        }
        catch (ToolException e) {
            log.error("Start to set the expansion details failed. bmcIp:{}", (Object)expansionConfig.getManagerIp(), (Object)e);
            return e.getErrorLocaleDescription();
        }
    }

    private void updateExpansionNode(String taskId, DevNode devNode) throws ToolException {
        Response multiExpansionNode = this.queryExpansionNodes.process(taskId, devNode.getIp());
        if (multiExpansionNode.getResult().getCode() != 0) {
            log.error("Failed to query the expansion node. devIp: {}", (Object)devNode.getIp());
            throw new ToolException("fit.update.expansion.node.error");
        }
        this.expansionNodesManager.update(devNode.getIp(), (MultiExpansionNode)multiExpansionNode.getData());
    }

    private List<ExpansionConfig> getExpansionConfigs(String taskId, DevNode devNode) throws ToolException {
        String splicingId = this.expansionConfigManager.splicing(taskId, devNode.getDevKey());
        Response multiExpansionConfigResponse = this.queryExpansionConfig.process(splicingId);
        if (multiExpansionConfigResponse.getResult().getCode() != 0) {
            log.error("Failed to query the node capacity expansion configuration. devIp: {}", (Object)devNode.getIp());
            throw new ToolException("fit.update.expansion.node.error");
        }
        if (devNode.isFusionCube()) {
            List storagePools = devNode.getStoragePools();
            ((MultiExpansionConfig)multiExpansionConfigResponse.getData()).getExpansionConfig().forEach(info -> this.setDiskName((ExpansionConfig)info, storagePools));
        }
        this.expansionConfigManager.update(splicingId, (MultiExpansionConfig)multiExpansionConfigResponse.getData());
        return ((MultiExpansionConfig)multiExpansionConfigResponse.getData()).getExpansionConfig();
    }

    private void setDiskName(ExpansionConfig info, List<FusionStorStoragePool> storagePools) {
        if (ExpansionModeEnum.CREAT_STORAGE_DISK_POOL.getScene().equals(info.getExpansionMode())) {
            info.setParentDiskPool(info.getParentStoragePool() + "1");
            return;
        }
        storagePools.stream().filter(pool -> pool.getName().equals(info.getParentStoragePool())).findFirst().ifPresent(pool -> this.setDiskPool(info, (FusionStorStoragePool)pool));
    }

    private void setDiskPool(ExpansionConfig info, FusionStorStoragePool storagePool) {
        storagePool.getDiskPools().stream().findFirst().ifPresent(pool -> info.setParentDiskPool(pool.getName()));
    }

    private String expansionDisk(DevNode devNode, ExpansionConfig expansionConfig) {
        try {
            FusionStorStoragePool fusionStoragePool = this.getFusionStoragePool(devNode, expansionConfig);
            VerifyLld.verifyDiskTypeInPool(fusionStoragePool, expansionConfig);
            ClusterNode clusterNode = this.getClusterNode(fusionStoragePool, expansionConfig);
            this.setFsNodeExpansionConfig(expansionConfig, fusionStoragePool, () -> InspectContext.getInstance().getFsExpansionConfig(clusterNode));
        }
        catch (ToolException e) {
            log.error("Expansion disk error. devIp: {}", (Object)devNode.getIp(), (Object)e);
            return e.getErrorLocaleDescription();
        }
        return DOUBLE_HORIZONTAL_BAR;
    }

    private String expansionNode(DevNode devNode, ExpansionConfig expansionConfig) {
        try {
            FusionStorStoragePool fusionStoragePool = this.getFusionStoragePool(devNode, expansionConfig);
            VerifyLld.verifyDiskTypeInPool(fusionStoragePool, expansionConfig);
            if (fusionStoragePool.isExpansionCreate()) {
                return ResourceUtil.getStringWithParams((String)"fit.new.pools.error", (Object[])new Object[]{fusionStoragePool.getName()});
            }
            this.bindExpansionNode(devNode, expansionConfig, fusionStoragePool);
            this.addNewNodes(devNode.getDevKey() + fusionStoragePool.getName(), fusionStoragePool.getExpansionNodeList());
        }
        catch (ToolException e) {
            log.error("Expansion node error. devIp: {}", (Object)devNode.getIp(), (Object)e);
            return e.getErrorLocaleDescription();
        }
        return DOUBLE_HORIZONTAL_BAR;
    }

    private String creatStoragePools(DevNode devNode, ExpansionConfig expansionConfig) {
        try {
            if (!VerifyLld.isFusionStorage(devNode) && !devNode.isFusionCube()) {
                return ResourceUtil.getStringWithParams((String)"fit.creat.storage.pool.error", (Object[])new Object[]{devNode.getIp()});
            }
            Optional<FusionStorStoragePool> matchStoragePool = this.getMatchPool(devNode.getStoragePools(), expansionConfig.getParentStoragePool());
            if (!matchStoragePool.isPresent()) {
                this.creatNewStoragePool(devNode, expansionConfig);
                return DOUBLE_HORIZONTAL_BAR;
            }
            if (matchStoragePool.get().isExisted()) {
                return ResourceUtil.getStringWithParams((String)"fit.storage.pool.exist.error", (Object[])new Object[]{matchStoragePool.get().getName()});
            }
            this.bindExpansionNode(devNode, expansionConfig, matchStoragePool.get());
            this.addNewNodes(devNode.getDevKey() + matchStoragePool.get().getName(), matchStoragePool.get().getExpansionNodeList());
            return DOUBLE_HORIZONTAL_BAR;
        }
        catch (ToolException e) {
            log.error("Creat storage pool error. devIp: {}", (Object)devNode.getIp(), (Object)e);
            return e.getErrorLocaleDescription();
        }
    }

    private void bindExpansionNode(DevNode devNode, ExpansionConfig expansionConfig, FusionStorStoragePool storagePool) throws ToolException {
        if (!this.expansionUtils.isNewNode(expansionConfig)) {
            ExpansionImpl.bindClusterNode(devNode, expansionConfig).ifPresent(clusterNode -> this.addClusterNode(storagePool, (ClusterNode)clusterNode, expansionConfig));
            return;
        }
        DevNode expansionNode = this.buildDevNode(devNode.getTaskId(), devNode.getDevKey(), expansionConfig);
        this.addDevNode(storagePool, expansionNode, expansionConfig);
    }

    private void addClusterNode(FusionStorStoragePool storagePool, ClusterNode clusterNode, ExpansionConfig expansionConfig) {
        storagePool.getExpansionClusterNode().add(clusterNode);
        this.setFsNodeExpansionConfig(expansionConfig, storagePool, () -> InspectContext.getInstance().getFsExpansionConfig(clusterNode));
    }

    private void addDevNode(FusionStorStoragePool storagePool, DevNode expansionNode, ExpansionConfig expansionConfig) {
        storagePool.getExpansionNodeList().add(expansionNode);
        this.setFsNodeExpansionConfig(expansionConfig, storagePool, () -> InspectContext.getInstance().getFsExpansionConfig(expansionNode));
    }

    private static Optional<ClusterNode> bindClusterNode(DevNode devNode, ExpansionConfig expansionNode) {
        return devNode.getClusterNodes().stream().filter(clusterNode -> clusterNode.getManagementIp().equals(expansionNode.getManagerIp())).findFirst();
    }

    private void creatNewStoragePool(DevNode devNode, ExpansionConfig expansionConfig) throws ToolException {
        FusionStorStoragePool fusionStorStoragePool = this.buildStoragePool(expansionConfig, () -> ((ExpansionConfig)expansionConfig).getParentStoragePool(), null);
        this.bindExpansionNode(devNode, expansionConfig, fusionStorStoragePool);
        this.addNewNodes(devNode.getDevKey() + fusionStorStoragePool.getName(), fusionStorStoragePool.getExpansionNodeList());
        devNode.getStoragePools().add(fusionStorStoragePool);
    }

    private String creatDiskPools(DevNode devNode, ExpansionConfig expansionConfig) {
        try {
            if (VerifyLld.isFusionStorage(devNode)) {
                return ResourceUtil.getStringWithParams((String)"fit.creat.disk.pool.error", (Object[])new Object[]{devNode.getIp()});
            }
            Optional<FusionStorStoragePool> storagePool = this.getMatchPool(devNode.getStoragePools(), expansionConfig.getParentStoragePool());
            if (!storagePool.isPresent()) {
                return this.creatStoragePoolsAndDiskPools(devNode, expansionConfig);
            }
            return this.creatDiskPoolsOnStoragePools(devNode, expansionConfig, storagePool.get());
        }
        catch (ToolException e) {
            log.error("Creat disk pools error. devIp: {}", (Object)devNode.getIp(), (Object)e);
            return e.getErrorLocaleDescription();
        }
    }

    private Optional<FusionStorStoragePool> getMatchPool(List<FusionStorStoragePool> storagePools, String poolName) {
        return storagePools.stream().filter(storagePool -> poolName.equals(storagePool.getName())).findFirst();
    }

    private String creatDiskPoolsOnStoragePools(DevNode devNode, ExpansionConfig expansionConfig, FusionStorStoragePool storagePool) throws ToolException {
        Optional<FusionStorStoragePool> matchDiskPool = this.getMatchPool(storagePool.getDiskPools(), expansionConfig.getParentDiskPool());
        if (!matchDiskPool.isPresent()) {
            this.creatNewDiskPool(devNode, expansionConfig, storagePool);
            return DOUBLE_HORIZONTAL_BAR;
        }
        if (matchDiskPool.get().isExisted()) {
            return ResourceUtil.getStringWithParams((String)"fit.disk.pool.name.exist.error", (Object[])new Object[]{matchDiskPool.get().getName()});
        }
        this.bindExpansionNode(devNode, expansionConfig, matchDiskPool.get());
        return DOUBLE_HORIZONTAL_BAR;
    }

    private void creatNewDiskPool(DevNode devNode, ExpansionConfig expansionConfig, FusionStorStoragePool storagePool) throws ToolException {
        FusionStorStoragePool newDiskPool = this.buildStoragePool(expansionConfig, () -> ((ExpansionConfig)expansionConfig).getParentDiskPool(), storagePool);
        this.bindExpansionNode(devNode, expansionConfig, newDiskPool);
        storagePool.getDiskPools().add(newDiskPool);
        this.addNewNodes(devNode.getDevKey() + newDiskPool.getName(), newDiskPool.getExpansionNodeList());
    }

    String creatStoragePoolsAndDiskPools(DevNode devNode, ExpansionConfig expansionConfig) throws ToolException {
        List storagePools = devNode.getStoragePools();
        if (!CollectionUtil.isEmpty((Collection)storagePools) && this.isFusionServiceType(storagePools) && !this.isSupportMultipleStoragePools(devNode)) {
            throw new ToolException("fit.exist.service.type.error", (Object[])new String[]{devNode.getIp()});
        }
        if (CollectionUtil.isEmpty((Collection)storagePools) && StringUtils.isNULLStr((String)expansionConfig.getServiceType())) {
            throw new ToolException("fit.service.type.error", (Object[])new String[]{devNode.getIp()});
        }
        FusionStorStoragePool storagePool = this.buildStoragePool(expansionConfig, () -> ((ExpansionConfig)expansionConfig).getParentStoragePool(), null);
        if (CollectionUtil.isEmpty((Collection)storagePools) && !StringUtils.isNULLStr((String)expansionConfig.getServiceType())) {
            storagePool.setServiceTypeByToString(expansionConfig.getServiceType());
        }
        FusionStorStoragePool diskPool = this.buildStoragePool(expansionConfig, () -> ((ExpansionConfig)expansionConfig).getParentDiskPool(), storagePool);
        this.bindExpansionNode(devNode, expansionConfig, diskPool);
        storagePool.getDiskPools().add(diskPool);
        devNode.getStoragePools().add(storagePool);
        this.addNewNodes(devNode.getDevKey() + diskPool.getName(), diskPool.getExpansionNodeList());
        return DOUBLE_HORIZONTAL_BAR;
    }

    private boolean isSupportMultipleStoragePools(DevNode devNode) {
        String configVersion = ResourceBundle.getBundle("config.inspect").getString("support.multiple.storage.pool");
        if (StringUtils.isNULLStr((String)configVersion)) {
            return false;
        }
        if (devNode.isOceanStorA310()) {
            return true;
        }
        return Arrays.stream(configVersion.split(",")).anyMatch(version -> devNode.getProductVersion().startsWith((String)version));
    }

    private boolean isFusionServiceType(List<FusionStorStoragePool> storagePools) {
        return storagePools.stream().anyMatch(storagePool -> !storagePool.isBlock());
    }

    private FusionStorStoragePool getFusionStoragePool(DevNode devNode, ExpansionConfig expansionConfig) throws ToolException {
        FusionStorStoragePool matchStoragePool = devNode.getStoragePools().stream().filter(fusionStoragePool -> expansionConfig.getParentStoragePool().equals(fusionStoragePool.getName())).findFirst().orElseThrow(() -> {
            log.error("Failed to obtain the node storage pool information. devIp:{}", (Object)devNode.getIp());
            return new ToolException("fit.storage.pool.error", (Object[])new String[]{expansionConfig.getParentStoragePool()});
        });
        if (CollectionUtil.isEmpty((Collection)matchStoragePool.getDiskPools())) {
            return matchStoragePool;
        }
        return matchStoragePool.getDiskPools().stream().filter(fusionStoragePool -> expansionConfig.getParentDiskPool().equals(fusionStoragePool.getName())).findFirst().orElseThrow(() -> {
            log.error("Failed to obtain the node storage pool information. devIp:{}", (Object)devNode.getIp());
            if (StringUtils.isNULLStr((String)expansionConfig.getParentDiskPool())) {
                return new ToolException("fit.disk.pool.error.with.ip", (Object[])new String[]{expansionConfig.getManagerIp()});
            }
            return new ToolException("fit.disk.pool.error", (Object[])new String[]{expansionConfig.getParentDiskPool()});
        });
    }

    private ClusterNode getClusterNode(FusionStorStoragePool storagePool, ExpansionConfig expansionConfig) throws ToolException {
        return storagePool.getJoinedClusterNode().stream().filter(joinedClusterNode -> expansionConfig.getManagerIp().equals(joinedClusterNode.getManagementIp())).findFirst().orElseThrow(() -> {
            log.error("Failed to obtain the cluster node. managementIp: {}", (Object)expansionConfig.getManagerIp());
            return new ToolException("fit.pool.node.error", (Object[])new String[]{expansionConfig.getManagerIp(), storagePool.getName()});
        });
    }

    private DevNode buildDevNode(String taskId, String devId, ExpansionConfig expansionConfig) throws ToolException {
        Optional<MultiExpansionNode> multiExpansionNode = this.expansionNodesManager.getExpansionNodeByDevId(devId);
        if (!multiExpansionNode.isPresent()) {
            log.error("Creat a devNode failed. bmcIP: {}", (Object)expansionConfig.getManagerIp());
            throw new ToolException("fit.get.expansion.node.error", (Object[])new String[]{expansionConfig.getManagerIp()});
        }
        return multiExpansionNode.get().getExpansionNode().stream().filter(expansionNode -> expansionConfig.getBmcIp().equals(expansionNode.getBmcIp())).map(expansionNode -> this.creatDevNode((ExpansionNode)expansionNode, expansionConfig)).peek(expansionNode -> expansionNode.setTaskId(taskId)).findFirst().orElseThrow(() -> {
            log.error("Creat a devNode failed. bmcIP: {}", (Object)expansionConfig.getManagerIp());
            return new ToolException("fit.build.dev.error", (Object[])new String[]{expansionConfig.getManagerIp()});
        });
    }

    private DevNode creatDevNode(ExpansionNode node, ExpansionConfig expansionConfig) {
        DevNode newNode = new DevNode();
        newNode.setIp(expansionConfig.getManagerIp());
        newNode.setRootUser(this.buildUser("root", AESEncrypt.encrypt((String)Base64EncodeUtils.encode((String)AESEncrypt.decrypt((String)node.getRootUserOriginPassword()))), AESEncrypt.encrypt((String)Base64EncodeUtils.encode((String)AESEncrypt.decrypt((String)node.getRootUserNewPassword())))));
        newNode.setLoginUser(this.buildUser(node.getOsUserName(), node.getOsUserOriginPassword(), node.getOsUserNewPassword()));
        newNode.setBaseBoardTypeByDevType(expansionConfig.getDevType());
        newNode.setDeviceName(expansionConfig.getNodeName());
        return newNode;
    }

    private User buildUser(String userName, String originPassword, String newPassword) {
        User user = new User();
        user.setUserName(userName);
        String loginPassword = StringUtils.isNULLStr((String)newPassword) ? originPassword : newPassword;
        user.setEcptPassword(loginPassword);
        return user;
    }

    private void setFsNodeExpansionConfig(ExpansionConfig expansionConfig, FusionStorStoragePool fusionStoragePool, Supplier<FsNodeExpansionConfig> fsNodeExpansionConfigSupplier) {
        FsNodeExpansionConfig fsExpansionConfig = fsNodeExpansionConfigSupplier.get();
        if (StringUtils.isNULLStr((String)expansionConfig.getMainStorageConfigure())) {
            return;
        }
        this.setStorageConfig(expansionConfig, fsExpansionConfig, true);
        if (StringUtils.isNULLStr((String)expansionConfig.getCacheStorageConfigure())) {
            return;
        }
        this.setStorageConfig(expansionConfig, fsExpansionConfig, false);
        fsExpansionConfig.setExpansionJoinStoragePool(fusionStoragePool);
    }

    private void setStorageConfig(ExpansionConfig expansionConfig, FsNodeExpansionConfig fsExpansionConfig, boolean isMainDisk) {
        String[] storageConfigures = isMainDisk ? expansionConfig.getMainStorageConfigure().split(",") : expansionConfig.getCacheStorageConfigure().split(",");
        Map<FusionStorDiskInfo, Integer> expansionDisk = isMainDisk ? fsExpansionConfig.getExpansionMainStorageDisk() : fsExpansionConfig.getExpansionCacheDisk();
        expansionDisk.clear();
        Arrays.stream(storageConfigures).forEach(storageConfigure -> {
            FusionStorDiskInfo storageDiskInfo = this.createDiskInfo(expansionConfig, (String)storageConfigure, isMainDisk);
            expansionDisk.put(storageDiskInfo, this.expansionUtils.getDiskQuantity((String)storageConfigure));
        });
    }

    private FusionStorDiskInfo createDiskInfo(ExpansionConfig expansionConfig, String diskConfig, boolean isMainDisk) {
        DiskTypeEnum diskType = isMainDisk ? DiskTypeEnum.getDiskTypeEnum((String)expansionConfig.getMainStorageType()) : DiskTypeEnum.getDiskTypeEnum((String)expansionConfig.getCacheStorageType());
        FusionStorDiskInfo fusionStorDiskInfo = new FusionStorDiskInfo();
        fusionStorDiskInfo.setSn(expansionConfig.getSn());
        FusionStorDiskInfo.CapacityUnit capacityUnit = FusionStorDiskInfo.CapacityUnit.mappingEnum((String)this.expansionUtils.getCapacityUnit(diskConfig));
        fusionStorDiskInfo.setCapacityAndUnit(this.expansionUtils.getCapacity(diskConfig), capacityUnit);
        fusionStorDiskInfo.setType(diskType);
        return fusionStorDiskInfo;
    }

    private FusionStorStoragePool buildStoragePool(ExpansionConfig expansionConfig, Supplier<String> poolName, FusionStorStoragePool fusionStoragePool) {
        FusionStorStoragePool storagePool = new FusionStorStoragePool();
        storagePool.setPoolType(FusionStorStoragePool.PoolType.EXPANSION_CREAT);
        storagePool.setMainStorageDiskType(DiskTypeEnum.getDiskTypeEnum((String)expansionConfig.getMainStorageType()));
        storagePool.setCacheDiskType(DiskTypeEnum.getDiskTypeEnum((String)expansionConfig.getCacheStorageType()));
        storagePool.setId("N/A");
        storagePool.setStatus("N/A");
        storagePool.setName(poolName.get());
        storagePool.setParentPool(fusionStoragePool);
        return storagePool;
    }

    private void addNewNodes(String devId, List<DevNode> newNodes) {
        ExpansionNodesManager.getInstance().getNewAddNode().put(devId, newNodes);
    }

    @Generated
    public void setExpansionConfigManager(ExpansionConfigManager expansionConfigManager) {
        this.expansionConfigManager = expansionConfigManager;
    }

    @Generated
    public void setExpansionNodesManager(ExpansionNodesManager expansionNodesManager) {
        this.expansionNodesManager = expansionNodesManager;
    }

    @Generated
    public void setExpansionUtils(ExpansionUtils expansionUtils) {
        this.expansionUtils = expansionUtils;
    }

    @Generated
    public void setStoragePoolInfoService(StoragePoolInfoService storagePoolInfoService) {
        this.storagePoolInfoService = storagePoolInfoService;
    }

    @Generated
    public void setQueryExpansionConfig(QueryExpansionConfig queryExpansionConfig) {
        this.queryExpansionConfig = queryExpansionConfig;
    }

    @Generated
    public void setQueryExpansionNodes(QueryExpansionNodes queryExpansionNodes) {
        this.queryExpansionNodes = queryExpansionNodes;
    }

    @Generated
    public void setDevUtil(DevUtil devUtil) {
        this.devUtil = devUtil;
    }

    @Generated
    public void setErrorInfos(Set<String> errorInfos) {
        this.errorInfos = errorInfos;
    }

    @Generated
    public Map<ExpansionModeEnum, BiFunction<DevNode, ExpansionConfig, String>> getExecuteMode() {
        return this.executeMode;
    }
}

