/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.ClusterDtoBuilder;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.validator.IValidator;
import com.huawei.ism.tool.inspect.fit.validator.impl.TaskExistValidator;
import com.huawei.ism.tool.inspect.worktaker.InspectWorktaker;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.drop.entity.storage.entity.MultiStroageNodeDto;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.Inspect;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryDevice;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.CheckDevParams;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.StartInspectParams;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class InspectServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InspectServerImpl.class);
    @Fit
    private final TaskWorkerManager workerManager;
    @Fit
    private final DevUtil devUtil;
    @Fit
    private final ClusterDtoBuilder clusterDtoBuilder;
    private List<IValidator> paramValidators;

    public InspectServerImpl(TaskWorkerManager workerManager, DevUtil devUtil, ClusterDtoBuilder clusterDtoBuilder) {
        this.workerManager = workerManager;
        this.devUtil = devUtil;
        this.clusterDtoBuilder = clusterDtoBuilder;
        this.paramValidators = Collections.singletonList(new TaskExistValidator(this.workerManager));
    }

    @Fitable(generic=QueryDevice.class, id="edff59dd3524495e89f87a6060a62175")
    public synchronized Response<MultiStroageNodeDto> queryDevice(String taskId, String scene) {
        try {
            InspectWorktaker workTaker = this.workerManager.registerTask(taskId);
            InspectScene inspectScene = InspectScene.of(scene);
            List<DevNode> nodes = this.devUtil.getAllSupportedDevs(workTaker, inspectScene);
            return ResponseUtil.success((Object)this.clusterDtoBuilder.builder(taskId, nodes, inspectScene));
        }
        catch (ToolException e) {
            log.error("query task {} scene {} node info failed {}.", new Object[]{taskId, scene, e.getErrorLocaleDescription()});
            return ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
        }
        catch (Exception e) {
            log.error("query task {} scene {} node info failed.", new Object[]{taskId, scene, e});
            return ResponseUtil.failed((String)ResourceUtil.getString((String)"inspector.unknown.error"), (String)"");
        }
    }

    @Fitable(generic=Inspect.class, id="a2bcc22eb38c4e679e186b2f1687c03a")
    public Response<String> inspect(StartInspectParams params) {
        try {
            this.recordParamsLog(params);
            this.validate(params);
            this.bindClusterAndClusterNode(params.getTaskId(), params.getCheckDevParams());
            this.workerManager.submitTask(params);
            return ResponseUtil.success((Object)"");
        }
        catch (ToolException e) {
            log.error("Start inspect failed. task info {}", (Object)params, (Object)e);
            return ResponseUtil.failed((Object)e.getErrorLocaleDescription());
        }
        catch (Exception e) {
            log.error("Start inspect failed. task info {}", (Object)params, (Object)e);
            return ResponseUtil.failed((Object)"submit inspect task failed.");
        }
    }

    private void recordParamsLog(StartInspectParams params) {
        log.info("inspect start by fit with taskId:{} and scene:{}", (Object)params.getTaskId(), (Object)params.getScene());
        for (CheckDevParams checkDevParam : params.getCheckDevParams()) {
            log.info("inspect start by fit with devId:{}, clusterNodeIds:{}, itemIds:{}", new Object[]{checkDevParam.getDevId(), checkDevParam.getClusterNodeIds(), checkDevParam.getItemIds()});
        }
    }

    private void bindClusterAndClusterNode(String taskId, List<CheckDevParams> checkDevParams) {
        this.bindDevNodes(taskId, checkDevParams);
        this.bindClusterNode(taskId, checkDevParams);
    }

    private void bindDevNodes(String taskId, List<CheckDevParams> checkDevParams) {
        List selectDevs = checkDevParams.stream().map(devConf -> this.devUtil.findDevNode(taskId, devConf.getDevId())).collect(Collectors.toList());
        this.workerManager.getTaskWorker(taskId).get().put("select_dev_nodes", selectDevs);
    }

    private void bindClusterNode(String taskId, List<CheckDevParams> checkDevParams) {
        checkDevParams.forEach(devConf -> this.devUtil.bindSelectedClusterNodes(this.devUtil.findDevNode(taskId, devConf.getDevId()), devConf.getClusterNodeIds()));
    }

    private void validate(StartInspectParams params) throws ToolException {
        for (IValidator validator : this.paramValidators) {
            validator.validator(params.getTaskId(), "");
        }
    }
}

