/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.framework.platform.exception.SignException;
import com.huawei.ism.tool.inspect.logic.fusionstor.inspector.ExpansionTaskUtils;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ApplicationContext;
import com.huawei.ism.tool.pyengine.engine.JythonExecuter;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import utils.FilesUtil;

@Fitable
public class StoragePoolInfoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StoragePoolInfoService.class);

    public boolean queryStorageInfo(DevNode devNode) {
        List<File> pyClassPaths = this.getFiles();
        Map<String, Object> env = this.setDependencyParameter(Collections.singletonList(devNode));
        return this.executeScript(pyClassPaths, env);
    }

    @NotNull
    private List<File> getFiles() {
        File expansionDir = new File(ExpansionTaskUtils.PY_SCRIPTS_DIR);
        File file = Paths.get(expansionDir.toURI()).getParent().getParent().toFile();
        String pyFramePath = FilesUtil.getCanonicalPath((File)file) + File.separator + "pyframe";
        ArrayList<File> pyClassPaths = new ArrayList<File>();
        pyClassPaths.add(new File(pyFramePath));
        pyClassPaths.add(expansionDir);
        return pyClassPaths;
    }

    @NotNull
    private Map<String, Object> setDependencyParameter(List<DevNode> addNodes) {
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("lang", ApplicationContext.getInstance().getCurrentLanguage().getLanguage());
        env.put("devInfoList", addNodes);
        env.put("logger", log);
        return env;
    }

    private boolean executeScript(List<File> pyClassPaths, Map<String, Object> env) {
        File pythonScriptFile = new File(ExpansionTaskUtils.PY_SCRIPTS_DIR, "query_dstorage_info.py");
        if (!pythonScriptFile.exists()) {
            log.error("The script file does not exist.");
            return false;
        }
        try {
            JythonExecuter jythonExecuter = new JythonExecuter(pyClassPaths);
            jythonExecuter.set("py_java_env", env);
            jythonExecuter.compileScript(pythonScriptFile);
            jythonExecuter.invokeFunction("execute_storage", new Object[0]);
        }
        catch (SignException | ToolException | FileNotFoundException e) {
            log.error("Failed to query the capacity expansion information.", e);
            return false;
        }
        return true;
    }
}

