/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.inspect.fit.switchcheck.login.impl.LoginSwitchService;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.util.SwitchCheckUtil;
import com.huawei.ism.tool.inspect.logic.config.Product;
import com.huawei.ism.tool.inspect.logic.config.SysConfiguration;
import com.huawei.ism.tool.obase.connection.ICliConnection;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.SwitchNode;
import com.huawei.ism.tool.obase.entity.SwitchPort;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.CollectionUtil;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.protocol.factory.SftpConnector;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.BatchDeleteSwitchs;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.ConfigSwitchPorts;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.LoginSwitch;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QuerySwitchs;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.ConfigSwitchPortsParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.DeleteSwitchParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchLoginParam;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchNodeDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchPortDTO;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.SwitchResponseDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class SwitchLoginServiceImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SwitchLoginServiceImpl.class);
    @Fit
    private final DevUtil devUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Fitable(generic=LoginSwitch.class, id="2ba4bc4e91b54ec3af8e278829ee329c")
    public Response<String> loginSwitch(SwitchLoginParam switchLoginParam) {
        SftpConnector sftpConnector = null;
        ICliConnection ssh = null;
        DevNode devNode = this.devUtil.findDevNode(switchLoginParam.getTaskId(), switchLoginParam.getFloatIp());
        if (!SwitchCheckUtil.isNeedSwitchCheck(devNode)) {
            return ResponseUtil.failed((Object)ResourceUtil.getStringWithParams((String)"not.support.dev.node", (Object[])new Object[]{switchLoginParam.getFloatIp()}));
        }
        try {
            DevNode authedNode = DevUtil.findAuthedStorageNode(devNode);
            sftpConnector = this.buildSftpConnector(authedNode);
            ssh = this.buildSshConnection(authedNode);
            LoginSwitchService loginSwitchService = new LoginSwitchService(sftpConnector, ssh, authedNode.getIp());
            List<SwitchNode> switchNodes = loginSwitchService.batchLoginSwitch(switchLoginParam.getSwitchLoginInfos());
            List<SwitchNode> authedSwitch = this.getAuthedSwitch(switchNodes);
            devNode.addSwitchNodes(this.getSupportNodes(authedSwitch));
            Response<String> response = this.buildResponse(switchLoginParam, switchNodes, authedSwitch);
            this.releaseConnection(sftpConnector, ssh);
            return response;
        }
        catch (ToolException toolException) {
            try {
                log.error("login switch error", (Throwable)toolException);
                Response response = ResponseUtil.failed((String)toolException.getDes(), (String)"");
                this.releaseConnection(sftpConnector, ssh);
                return response;
            }
            catch (Throwable throwable) {
                this.releaseConnection(sftpConnector, ssh);
                throw throwable;
            }
        }
    }

    private List<SwitchNode> getSupportNodes(List<SwitchNode> authedSwitch) {
        Set product = SysConfiguration.getInstance().getSwitchProducts().stream().map(Product::getProductName).collect(Collectors.toSet());
        return authedSwitch.stream().filter(switchNode -> this.modelContainsName(product, (SwitchNode)switchNode)).collect(Collectors.toList());
    }

    private boolean modelContainsName(Set<String> product, SwitchNode switchNode) {
        return product.stream().anyMatch(switchNode.getModel()::contains);
    }

    private Response<String> buildResponse(SwitchLoginParam switchLoginParam, List<SwitchNode> switchNodes, List<SwitchNode> authedSwitch) {
        List<SwitchNode> notSupportNodes = this.getNotSupportNodes(authedSwitch);
        List<SwitchNode> unAuthNode = this.getAuthedFailNode(switchNodes);
        if (CollectionUtil.isEmpty(unAuthNode) && CollectionUtil.isEmpty(notSupportNodes)) {
            return ResponseUtil.success((Object)"");
        }
        ArrayList<String> errorMsg = new ArrayList<String>();
        if (!CollectionUtil.isEmpty(unAuthNode)) {
            errorMsg.add(this.buildAuthFailInfo(switchLoginParam.getFloatIp(), unAuthNode));
        }
        if (!CollectionUtil.isEmpty(notSupportNodes)) {
            errorMsg.add(this.buildNotSupportInfo(switchLoginParam.getFloatIp(), notSupportNodes));
        }
        return ResponseUtil.failed((String)String.join((CharSequence)System.lineSeparator(), errorMsg), (String)"");
    }

    private String buildNotSupportInfo(String floatIp, List<SwitchNode> notSupportNodes) {
        return ResourceUtil.getStringWithParams((String)"not.support.auth.fail", (Object[])new Object[]{floatIp, notSupportNodes.stream().map(SwitchNode::getIp).collect(Collectors.joining(","))});
    }

    private List<SwitchNode> getNotSupportNodes(List<SwitchNode> authedSwitch) {
        Set product = SysConfiguration.getInstance().getSwitchProducts().stream().map(Product::getProductName).collect(Collectors.toSet());
        return authedSwitch.stream().filter(switchNode -> !this.modelContainsName(product, (SwitchNode)switchNode)).collect(Collectors.toList());
    }

    @Fitable(generic=QuerySwitchs.class, id="d324612e0ed848ccb50e8592a73670e8")
    public Response<SwitchResponseDTO> querySwitches(String taskId, String floatIp) {
        return ResponseUtil.success((Object)this.buildSwitchData(this.devUtil.findDevNode(taskId, floatIp)));
    }

    @Fitable(generic=ConfigSwitchPorts.class, id="16efda4f9f1b496783341c4153f89751")
    public Response<String> configSwitchPorts(ConfigSwitchPortsParam param) {
        DevNode devNode = this.devUtil.findDevNode(param.getTaskId(), param.getFloatIp());
        param.getSwitchNodeDTO().stream().map(this::mapToSwitchNode).forEach(arg_0 -> ((DevNode)devNode).updateSwitchConfig(arg_0));
        return ResponseUtil.success((Object)"");
    }

    private String buildAuthFailInfo(String floatIp, List<SwitchNode> unAuthNode) {
        return ResourceUtil.getStringWithParams((String)"switch.auth.fail", (Object[])new Object[]{floatIp, unAuthNode.stream().map(SwitchNode::getIp).collect(Collectors.joining(","))});
    }

    private List<SwitchNode> getAuthedFailNode(List<SwitchNode> switchInfo) {
        return switchInfo.stream().filter(switchNode -> !switchNode.isAuth()).collect(Collectors.toList());
    }

    private List<SwitchNode> getAuthedSwitch(List<SwitchNode> switchInfo) {
        return switchInfo.stream().filter(SwitchNode::isAuth).collect(Collectors.toList());
    }

    private void releaseConnection(SftpConnector sftpConnector, ICliConnection ssh) {
        if (sftpConnector != null) {
            sftpConnector.getConnection().closeSshConnection();
        }
        if (ssh != null) {
            SshConnectionManager.releaseConnection((ICliConnection)ssh);
        }
    }

    private ICliConnection buildSshConnection(DevNode devNode) throws ToolException {
        return SshConnectionManager.getSshConnection((DevNode)devNode);
    }

    private SftpConnector buildSftpConnector(DevNode devNode) {
        return new SftpConnector(devNode);
    }

    private SwitchResponseDTO buildSwitchData(DevNode devNode) {
        return SwitchResponseDTO.builder().switchNodeDTO(devNode.getSwitchNodes().stream().map(this::buildSwitchDTO).collect(Collectors.toList())).build();
    }

    private SwitchNodeDTO buildSwitchDTO(SwitchNode switchNode) {
        return SwitchNodeDTO.builder().ip(switchNode.getIp()).model(switchNode.getModel()).switchPortDTO(switchNode.getSwitchPort().stream().map(this::buildPort).collect(Collectors.toList())).configdPorts(Boolean.valueOf(switchNode.isConfigdPorts())).build();
    }

    private SwitchPortDTO buildPort(SwitchPort switchPort) {
        return SwitchPortDTO.builder().portName(switchPort.getPortName()).status(switchPort.getStatus()).selected(Boolean.valueOf(switchPort.isSelected())).build();
    }

    private SwitchNode mapToSwitchNode(SwitchNodeDTO switchNodeDTO) {
        return SwitchNode.builder().ip(switchNodeDTO.getIp()).switchPort(this.mapToSwitchPort(switchNodeDTO.getSwitchPortDTO())).build();
    }

    private List<SwitchPort> mapToSwitchPort(List<SwitchPortDTO> switchPortDTO) {
        return switchPortDTO.stream().map(this::buildPort).collect(Collectors.toList());
    }

    private SwitchPort buildPort(SwitchPortDTO port) {
        return SwitchPort.builder().portName(port.getPortName()).status(port.getStatus()).selected(Objects.isNull(port.getSelected()) || port.getSelected() != false).build();
    }

    @Fitable(generic=BatchDeleteSwitchs.class, id="f95a30da2fad4273b99e69ae6733b914")
    public Response<String> batchDeleteSwitchs(DeleteSwitchParam deleteSwitchParam) {
        DevNode devNode = this.devUtil.findDevNode(deleteSwitchParam.getTaskId(), deleteSwitchParam.getFloatIp());
        devNode.removeSwitchNodes(this.buildSwitchNode(deleteSwitchParam.getFloatIp(), deleteSwitchParam.getSwitchIps()));
        return ResponseUtil.success((Object)"");
    }

    private List<SwitchNode> buildSwitchNode(String floatIp, List<String> switchIps) {
        return switchIps.stream().map(switchIp -> SwitchNode.builder().ip(switchIp).floatIp(floatIp).build()).collect(Collectors.toList());
    }

    @Generated
    public SwitchLoginServiceImpl(DevUtil devUtil) {
        this.devUtil = devUtil;
    }
}

