/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.entity.CheckDevNode;
import com.huawei.ism.tool.inspect.entity.Record;
import com.huawei.ism.tool.inspect.fit.entity.task.ResultStatus;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.util.TaskInfoUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.item.entity.ItemConf;
import com.huawei.yinglong.drop.entity.item.entity.MultiRunningDetailDTO;
import com.huawei.yinglong.drop.entity.item.entity.ResultDetailDTO;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryInspectOverview;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItemResultDetail;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.QueryItemRunningDetail;
import com.huawei.yinglong.river.inspection.storage.distribution.inspect.entity.TaskOverviewDTO;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class TaskInfoServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TaskInfoServerImpl.class);
    public static final String UNKNOWN_ERROR = ResourceUtil.getString((String)"inspector.unknown.error");
    @Fit
    private final TaskInfoUtil util;
    @Fit
    private final DevUtil devUtil;

    @Fitable(generic=QueryInspectOverview.class, id="f63e84122d8b4462b065fecec36d656e")
    public Response<TaskOverviewDTO> queryInspectOverview(String taskId) {
        try {
            List<CheckDevNode> checkDevNodes = this.devUtil.findAllCheckDevNodes(taskId);
            List<DevNode> devNodes = this.devUtil.findExceptionDevNodes(taskId);
            if (CollectionUtils.isEmpty(checkDevNodes) && CollectionUtils.isNotEmpty(devNodes)) {
                return ResponseUtil.failed((Object)this.buildErrorOverview(devNodes));
            }
            TaskOverviewDTO taskOverview = this.util.buildTaskOverview(checkDevNodes);
            this.updateExceptionDevNodesOverView(taskOverview, devNodes);
            return ResponseUtil.success((Object)taskOverview);
        }
        catch (Exception e) {
            log.error("Query task {} over view failed.", (Object)taskId, (Object)e);
            return ResponseUtil.failed((String)UNKNOWN_ERROR, (String)"");
        }
    }

    private void updateExceptionDevNodesOverView(TaskOverviewDTO taskOverview, List<DevNode> devNodes) {
        if (CollectionUtils.isNotEmpty(devNodes)) {
            taskOverview.getOverviews().addAll(this.buildErrorOverview(devNodes).getOverviews());
            if (ResultStatus.SUCCESS.getKey().equals(taskOverview.getStatus())) {
                taskOverview.setStatus(ResultStatus.PART_SUCCESS.getKey());
            }
        }
    }

    private TaskOverviewDTO buildErrorOverview(List<DevNode> devNodes) {
        return this.util.buildFailedTaskOverview(devNodes);
    }

    @Fitable(generic=QueryItemRunningDetail.class, id="063cdc4d1d1c44a79374b3ff95165859")
    public Response<MultiRunningDetailDTO> queryItemRunningDetail(String taskId, String devId) {
        try {
            CheckDevNode checkDevNode = this.devUtil.findCheckDevNode(taskId, devId);
            return ResponseUtil.success((Object)this.util.buildMultiRunningDetail(checkDevNode));
        }
        catch (ToolException e) {
            String error = e.getErrorLocaleDescription();
            log.error("query task info error,task id {} dev id {}.", new Object[]{taskId, devId, e});
            if (error.startsWith("can not find dev ") && this.isDevNodeHasException(taskId, devId)) {
                return ResponseUtil.failed((String)ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{devId}), (String)"");
            }
            return ResponseUtil.failed((String)error, (String)"");
        }
        catch (Exception e) {
            log.error("query task info error,task id {} dev id {}.", new Object[]{taskId, devId, e});
            return ResponseUtil.failed((String)UNKNOWN_ERROR, (String)"");
        }
    }

    private boolean isDevNodeHasException(String taskId, String devId) {
        return this.devUtil.findExceptionDevNodes(taskId).stream().anyMatch(devNode -> devNode.getIp().equals(devId));
    }

    @Fitable(generic=QueryItemResultDetail.class, id="8147d0208d8341a99483b193b2dd64ab")
    public Response<ResultDetailDTO> queryItemResultDetail(String taskId, String devId, String itemId) {
        try {
            CheckDevNode checkDevNode = this.devUtil.findCheckDevNode(taskId, devId);
            if ("importPatch".equals(itemId)) {
                return ResponseUtil.success((Object)this.createDetailDTO(checkDevNode));
            }
            Record record = this.util.findTargetItemRecord(checkDevNode, itemId);
            return ResponseUtil.success((Object)this.util.buildResultDetail(record));
        }
        catch (ToolException e) {
            log.error("Query result detail failed. task {} dev {} item {}", new Object[]{taskId, devId, itemId, e});
            return ResponseUtil.failed((String)e.getErrorLocaleDescription(), (String)"");
        }
        catch (Exception e) {
            log.error("Query result detail failed. task {} dev {} item {}", new Object[]{taskId, devId, itemId, e});
            return ResponseUtil.failed((String)UNKNOWN_ERROR, (String)"");
        }
    }

    ResultDetailDTO createDetailDTO(CheckDevNode checkDevNode) {
        String errMsg = checkDevNode.getImportPatchErrorMsg();
        return ResultDetailDTO.builder().errorMsg(errMsg).originInfo(this.parseAndCreateOriginInfo(errMsg, checkDevNode.getDevNode().getClusterNodes())).status("failed").itemConf(ItemConf.builder().build()).build();
    }

    private String parseAndCreateOriginInfo(String errorMsg, List<ClusterNode> clusterNodes) {
        String[] errMsgTemp = errorMsg.split("\\(");
        if (errMsgTemp.length < 2) {
            log.error("errorMsg does not meet expectations. errorMsg is {}.", (Object)errorMsg);
            return "";
        }
        String ids = errMsgTemp[1].split("\\)")[0];
        if (StringUtils.isNULLStr((String)ids.trim())) {
            log.info("node id is empty.");
            return "";
        }
        return Arrays.stream(ids.split(",")).map(String::trim).map(id -> this.getNodeInfo(clusterNodes, (String)id)).collect(Collectors.joining("\n"));
    }

    private String getNodeInfo(List<ClusterNode> clusterNodes, String id) {
        return clusterNodes.stream().filter(node -> node.getId() == Integer.parseInt(id)).map(node -> ResourceUtil.getStringWithParams((String)"inspector.import.patch.error.nodes.info", (Object[])new Object[]{id, node.getManagementIp(), node.getRoles()})).findFirst().orElse("");
    }

    @Generated
    public TaskInfoServerImpl(TaskInfoUtil util, DevUtil devUtil) {
        this.util = util;
        this.devUtil = devUtil;
    }
}

