/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.device;

import com.huawei.ism.tool.devicemanager.service.INodeObserver;
import com.huawei.ism.tool.inspect.fit.util.BrokerClientUtil;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Cluster;
import java.util.Optional;

public class ClusterNodeObserver
implements INodeObserver {
    private CacheCluster cacheCluster = (CacheCluster)BrokerClientUtil.getBrokerClient().getProxy(CacheCluster.class);
    private CacheServer cacheServer = (CacheServer)BrokerClientUtil.getBrokerClient().getProxy(CacheServer.class);

    public void fireNodeAdd(DevNode dev) {
        if (dev.getClusterNodes() == null || dev.getClusterNodes().isEmpty()) {
            return;
        }
        this.initBmcNode(dev);
        this.cacheCluster(dev);
        this.cacheClusterNodes(dev);
    }

    private void initBmcNode(DevNode dev) {
        dev.getClusterNodes().stream().filter(node -> node.getBmcNode() == null).forEach(node -> {
            DevNode bmcNode = new DevNode();
            bmcNode.setIp(node.getBmcIp());
            bmcNode.setDeviceSerialNumber(DevUtil.getClusterNodeUid(dev, node));
            node.setBmcNode(bmcNode);
        });
    }

    private void cacheClusterNodes(DevNode dev) {
        dev.getClusterNodes().forEach(clusterNode -> this.cacheServer.process(DevUtil.buildServerByCluster(dev, clusterNode)));
    }

    private void cacheCluster(DevNode devNode) {
        String model = devNode.getDeviceType() == null ? devNode.getProductModel() : devNode.getDeviceType().toString();
        Cluster cluster = Cluster.builder().uid(devNode.getDevKey()).clusterName(devNode.getDeviceName()).ip(devNode.getIp()).sn(devNode.getDeviceSerialNumber()).loginUser(ClusterNodeObserver.buildUser(devNode.getLoginUser())).clusterModel(model).clusterVersion(devNode.getProductVersion()).clusterPatchVersion(devNode.getHotPatchVersion()).itDeviceType(devNode.getItDeviceType().getName()).build();
        ClusterNodeObserver.buildFusionCubeUser(devNode.getFusionCubeLoginUser()).ifPresent(arg_0 -> ((Cluster)cluster).setFusionCubeLoginUser(arg_0));
        ClusterNodeObserver.buildFusionCubeUser(devNode.getRootUser()).ifPresent(arg_0 -> ((Cluster)cluster).setRootUser(arg_0));
        this.cacheCluster.process(cluster);
    }

    private static LoginUser buildUser(User user) {
        return LoginUser.builder().name(user.getUserName()).pwd(user.getEcptPassword()).build();
    }

    private static Optional<LoginUser> buildFusionCubeUser(User user) {
        if (user == null) {
            return Optional.empty();
        }
        return Optional.of(LoginUser.builder().name(user.getUserName()).pwd(user.getEcptPassword()).port(Integer.valueOf(user.getPort())).build());
    }

    public void fireNodeDelete(DevNode dev) throws ToolException {
    }

    public void fireNodeModify(DevNode dev) throws ToolException {
    }
}

