/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.device;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.base.utils.Base64EncodeUtils;
import com.huawei.ism.tool.devicemanager.service.DeviceAddService;
import com.huawei.ism.tool.devicemanager.service.DeviceOpr;
import com.huawei.ism.tool.devicemanager.service.INodeTypeQuery;
import com.huawei.ism.tool.devicemanager.service.dev.infoqry.DSstorageInfoQryServiceImpl;
import com.huawei.ism.tool.devicemanager.ui.dialog.DeviceQueryErrorParser;
import com.huawei.ism.tool.framework.pubservice.entity.ItDeviceType;
import com.huawei.ism.tool.framework.pubservice.listener.INodeSupport;
import com.huawei.ism.tool.inspect.fit.common.InspectScene;
import com.huawei.ism.tool.inspect.fit.service.device.auth.bmc.BmcAuthServerImpl;
import com.huawei.ism.tool.inspect.fit.service.device.auth.os.OsAuthServerImpl;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.util.filter.InspectNodeFilter;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.entity.User;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.taskexecutor.TaskResult;
import com.huawei.ism.tool.obase.threadpool.ThreadPoolHelper;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.ism.tool.service.rest.common.Constants;
import com.huawei.ism.tool.service.sanbox.ISandBoxService;
import com.huawei.ism.tool.service.sanbox.SandBoxService;
import com.huawei.yinglong.drop.entity.auth.entity.StorageAuthForm;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.AddCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BatchAuthBmc;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BatchAuthOs;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.BmcConnectivityTest;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.OsConnectivityTest;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.ConnectivityTestParam;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiBmcAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiOsAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class DeviceAuthServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceAuthServerImpl.class);
    private static final int MAX_AUTH_POOL_SIZE = 20;
    @Fit
    private CacheCluster cacheCluster;
    @Fit
    private QueryCluster queryCluster;
    @Fit
    private QueryServer queryServer;
    @Fit
    private DevUtil devUtil;
    @Fit
    private BmcAuthServerImpl bmcAuthServer;
    @Fit
    private OsAuthServerImpl osAuthServer;
    private DSstorageInfoQryServiceImpl queryImpl = new DSstorageInfoQryServiceImpl();
    private DeviceAddService addService = new DeviceAddService((INodeTypeQuery)this.queryImpl);
    private ISandBoxService sandBoxService = new SandBoxService();

    @Fitable(generic=AddCluster.class, id="38e27be6e3f14ac597acf61bd5fb9fe9")
    public synchronized Response<String> addCluster(StorageAuthForm authForm) {
        DevNode devNode = this.buildDevNode(authForm);
        if (!devNode.isDsStorage()) {
            return ResponseUtil.failed((Object)Constants.Device.UN_SUPPORT_MSG);
        }
        this.queryImpl.setNodeSupport((INodeSupport)new InspectNodeFilter(InspectScene.of(authForm.getScene())));
        boolean hasDirectPlanes = Objects.equals("bureau_check", authForm.getScene());
        log.info("add cluster current scene is : {}.", (Object)authForm.getScene());
        TaskResult result = DeviceQueryErrorParser.parseErrorInfo((TaskResult)this.addService.addDeviceByRest(devNode, DeviceOpr.ADD, hasDirectPlanes));
        if (result.getResult() == TaskResult.Result.FAILED) {
            return ResponseUtil.failed((Object)result.getErrorLocaleDescription());
        }
        return ResponseUtil.success((Object)"");
    }

    @Fitable(generic=BatchAuthOs.class, id="8db5643d98e44234823707dddc5a0ce4")
    public synchronized Response<String> batchAuthOs(MultiOsAuthParams param) {
        ExecutorService pool = ThreadPoolHelper.getFixedNumThreadPool((int)Math.min(param.getUids().size(), 20), (String)"node_ssh_auth_pool");
        try {
            List<Server> serverList = this.osAuthServer.queryAndInitServer(param);
            ((CompletableFuture)CompletableFuture.runAsync(() -> this.queryServerSandboxStatus(param), pool).thenRun(() -> this.submitOsAuth(serverList, param, pool))).whenComplete((ret, ex) -> pool.shutdown());
            return ResponseUtil.success((Object)"");
        }
        catch (Exception e) {
            pool.shutdown();
            log.error("batch os auth error.", (Throwable)e);
            return ResponseUtil.failed((String)"inspector.unknown.error", (String)"");
        }
    }

    @Fitable(generic=OsConnectivityTest.class, id="4af2508f98444ccb86a94414880bb0f7")
    public Response<String> osConnectivityTest(ConnectivityTestParam param) {
        ExecutorService pool = ThreadPoolHelper.getFixedNumThreadPool((int)Math.min(param.getUids().size(), 20), (String)"node_ssh_auth_pool");
        try {
            List<Server> servers = this.osAuthServer.queryAndInitServer(param.getUids());
            servers.forEach(server -> this.submitOsAuth(param, pool, (Server)server));
            pool.shutdown();
            return ResponseUtil.success((Object)"");
        }
        catch (Exception e) {
            pool.shutdown();
            log.error("batch os auth error.", (Throwable)e);
            return ResponseUtil.failed((String)"inspector.unknown.error", (String)"");
        }
    }

    @Fitable(generic=BmcConnectivityTest.class, id="37e4cd1b6e50413fb7fa56fec9c34aea")
    public Response<String> bmcConnectivityTest(ConnectivityTestParam param) {
        ExecutorService pool = ThreadPoolHelper.getFixedNumThreadPool((int)Math.min(param.getUids().size(), 20), (String)"node_ssh_auth_pool");
        try {
            List<Server> servers = this.bmcAuthServer.queryAndInitServer(param.getUids());
            servers.forEach(server -> this.submitBmcAuth(param, pool, (Server)server));
            pool.shutdown();
            return ResponseUtil.success((Object)"");
        }
        catch (Exception e) {
            pool.shutdown();
            log.error("batch bmc auth error.", (Throwable)e);
            return ResponseUtil.failed((String)"inspector.unknown.error", (String)"");
        }
    }

    @NonNull
    private CompletableFuture<Void> submitOsAuth(ConnectivityTestParam param, ExecutorService pool, Server server) {
        return CompletableFuture.runAsync(() -> this.osAuthServer.osConnectivityTest(server, param.getPort()), pool);
    }

    @NonNull
    private CompletableFuture<Void> submitBmcAuth(ConnectivityTestParam param, ExecutorService pool, Server server) {
        return CompletableFuture.runAsync(() -> this.bmcAuthServer.bmcConnectivityTest(server, param.getPort()), pool);
    }

    private void submitOsAuth(List<Server> serverList, MultiOsAuthParams param, ExecutorService pool) {
        serverList.forEach(server -> CompletableFuture.supplyAsync(() -> this.osAuthServer.osAuth((Server)server, param), pool).thenApply(authServer -> this.osAuthServer.syncAuthInfo2ClusterNode(param, (Server)authServer)));
    }

    private void queryServerSandboxStatus(MultiOsAuthParams param) {
        if (StringUtils.isNULLStr((String)param.getClusterId())) {
            return;
        }
        DevNode devNode = DevUtil.buildClusterDevNode(this.queryCluster.process(param.getClusterId()));
        Map sandboxStatusMap = this.sandBoxService.queryServersSandboxStatus(devNode);
        sandboxStatusMap.keySet().forEach(serverIp -> this.findServerUidByServerIp(param, (String)serverIp).ifPresent(serverUid -> this.queryServer.process(serverUid).setSandboxStatus(Integer.valueOf(((SandboxStatus)sandboxStatusMap.get(serverIp)).getCode()))));
    }

    private Optional<String> findServerUidByServerIp(MultiOsAuthParams param, String serverIp) {
        return param.getUids().stream().filter(uid -> uid.endsWith(serverIp)).findFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Fitable(generic=BatchAuthBmc.class, id="14339fffd2cf4af3b7f3d205fad76627")
    public synchronized Response<String> batchBmcAuth(MultiBmcAuthParams param) {
        ExecutorService pool = ThreadPoolHelper.getFixedNumThreadPool((int)Math.min(param.getUids().size(), 20), (String)"node_bmc_auth_pool");
        try {
            this.bmcAuthServer.queryAndInitServer(param).forEach(server -> CompletableFuture.supplyAsync(() -> this.bmcAuthServer.bmcAuth((Server)server, param), pool).thenApply(authServer -> this.bmcAuthServer.syncAuthInfo2ClusterNode(param, (Server)authServer)));
            Response response = ResponseUtil.success((Object)"");
            return response;
        }
        catch (Exception e) {
            log.error("batch bmc auth error.", (Throwable)e);
            Response response = ResponseUtil.failed((String)ResourceUtil.getString((String)"inspector.unknown.error"), (String)"");
            return response;
        }
        finally {
            pool.shutdown();
        }
    }

    private DevNode buildDevNode(StorageAuthForm authForm) {
        DevNode devNode = new DevNode();
        devNode.setIp(authForm.getIp());
        devNode.setPort(authForm.getPort().intValue());
        devNode.setLoginUser(new User(authForm.getLoginUser().getName(), authForm.getLoginUser().getPwd()));
        devNode.setItDeviceType(ItDeviceType.of((String)authForm.getItDeviceType()));
        if (ItDeviceType.FUSIONCUBE.getName().equals(authForm.getItDeviceType())) {
            devNode.setFusionCubeLoginUser(new User(authForm.getBackstageUsername(), authForm.getBackstagePassword(), authForm.getSshPort().intValue()));
            devNode.setRootUser(new User("root", Base64EncodeUtils.encode((String)authForm.getRootUser().getPwd()), authForm.getSshPort().intValue()));
        }
        return devNode;
    }

    @Generated
    public void setAddService(DeviceAddService addService) {
        this.addService = addService;
    }
}

