/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.device;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.obase.utils.StringUtils;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.FireServerAdded;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryMultiCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryMultiServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.RemoveCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.RemoveServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.RemoveServerByClusterId;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Cluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.MultiCluster;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.MultiServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class DeviceCacheImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DeviceCacheImpl.class);
    @Fit(alias="fireServerAdded\u7684\u5b9e\u73b0")
    private FireServerAdded deployServerObs;
    private Map<String, Server> serverMap = new ConcurrentHashMap<String, Server>();
    private Map<String, Cluster> clusterMap = new ConcurrentHashMap<String, Cluster>();

    @Fitable(generic=QueryMultiServer.class, id="1bf2298b349d43abbf772b885bb83ddd")
    public MultiServer queryMultiServer(String clusterId) {
        return MultiServer.builder().server(this.filterServerByClusterId(clusterId)).build();
    }

    private List<Server> filterServerByClusterId(String clusterId) {
        return this.serverMap.values().stream().filter(server -> clusterId.equals(server.getClusterId())).sorted(this::compareServer).collect(Collectors.toList());
    }

    private int compareServer(Server server, Server nextServer) {
        return server.getBmcIp().compareTo(nextServer.getBmcIp());
    }

    @Fitable(generic=QueryMultiCluster.class, id="d8f9ca855b974924b95bdaae92369621")
    public MultiCluster queryMultiCluster() {
        return MultiCluster.builder().cluster(new ArrayList<Cluster>(this.clusterMap.values())).build();
    }

    @Fitable(generic=CacheServer.class, id="d793772a83e24c478d80f55e4d37a0c8")
    public synchronized void cacheServer(Server server) {
        log.info("cache server, uid : {},server bmc ip {} .", (Object)server.getUid(), (Object)server.getBmcIp());
        if (this.serverMap.containsKey(server.getUid())) {
            log.info("over write server, uid : {},server bmc ip {} .", (Object)server.getUid(), (Object)server.getBmcIp());
        }
        this.serverMap.put(server.getUid(), server);
    }

    @Fitable(generic=QueryServer.class, id="79201e2ac80d4d28baa48382c70084dd")
    public Server queryServer(String uid) {
        return this.serverMap.get(uid);
    }

    @Fitable(generic=RemoveServer.class, id="8d4a5abc3325490e8b70dba35971b336")
    public synchronized boolean removeServer(String uid) {
        if (this.serverMap.containsKey(uid)) {
            Server server = this.serverMap.remove(uid);
            log.info("remove server success, uid : {}, bmc ip {} .", (Object)uid, (Object)server.getBmcIp());
            return true;
        }
        return false;
    }

    @Fitable(generic=CacheCluster.class, id="4242585aa2f24f2a8dcfe210ad26cf13")
    public Boolean cacheCluster(Cluster cluster) {
        log.info("cache cluster, uid : {},cluster ip {} .", (Object)cluster.getUid(), (Object)cluster.getIp());
        if (this.clusterMap.containsKey(cluster.getUid())) {
            log.info("over write cluster, uid : {},cluster ip {} .", (Object)cluster.getUid(), (Object)cluster.getIp());
        }
        this.clusterMap.put(cluster.getUid(), cluster);
        return true;
    }

    @Fitable(generic=QueryCluster.class, id="d9dea641eb8e4e77947047567c1177cf")
    public Cluster queryCluster(String uid) {
        return this.clusterMap.get(uid);
    }

    @Fitable(generic=RemoveCluster.class, id="ccf5551886fc46c7baa9a60cb85e8dd7")
    public synchronized boolean removeCluster(String uid) {
        if (this.clusterMap.containsKey(uid)) {
            this.clusterMap.remove(uid);
            return true;
        }
        return false;
    }

    private void fireServerAdded(Server server) {
        List<FireServerAdded> obs = Arrays.asList(this.deployServerObs);
        obs.stream().filter(Objects::nonNull).forEach(addObs -> addObs.process(server));
    }

    @Fitable(generic=RemoveServerByClusterId.class, id="72734692f7e44c9490d7f7897b00947a")
    public Boolean removeServerByClusterId(String clusterId) {
        if (StringUtils.isNULLStr((String)clusterId)) {
            log.info("no clusterId for remover");
            return false;
        }
        this.serverMap.entrySet().stream().filter(entry -> clusterId.equals(((Server)entry.getValue()).getClusterId())).map(Map.Entry::getKey).forEach(key -> this.serverMap.remove(key));
        return true;
    }
}

