/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.device.auth.bmc;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.fit.service.device.auth.bmc.IServerQueryTask;
import com.huawei.ism.tool.inspect.fit.service.device.auth.bmc.ProductUidQueryTask;
import com.huawei.ism.tool.inspect.fit.service.device.auth.entity.AuthStatusEnum;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.obase.entity.ClusterNode;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.rest.service.device.RedfishConnectionManager;
import com.huawei.uMate.common.rest.RedfishConnestion;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.AuthStatus;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiBmcAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class BmcAuthServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BmcAuthServerImpl.class);
    @Fit(alias="cacheServer\u7684\u5b9e\u73b0")
    private CacheServer cacheServer;
    @Fit(alias="queryServer\u7684\u5b9e\u73b0")
    private QueryServer queryServer;
    @Fit
    private DevUtil devUtil;
    private List<IServerQueryTask> tasks = new ArrayList<IServerQueryTask>();

    public BmcAuthServerImpl() {
        this.tasks.add(new ProductUidQueryTask());
    }

    public List<Server> queryAndInitServer(MultiBmcAuthParams param) {
        return param.getUids().stream().map(uid -> this.queryServer.process(uid)).filter(Objects::nonNull).peek(BmcAuthServerImpl::initServer).collect(Collectors.toList());
    }

    public List<Server> queryAndInitServer(List<String> uids) {
        return uids.stream().map(uid -> this.queryServer.process(uid)).peek(BmcAuthServerImpl::initServer).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server bmcAuth(Server server, MultiBmcAuthParams param) {
        DevNode devNode = DevUtil.buildBmcDevNode(server, param);
        try {
            this.updateAuthStatus(server, AuthStatusEnum.AUTHING.getKey(), "");
            RedfishConnestion redfishConn = RedfishConnectionManager.INS.getRedFishConnection(devNode);
            this.tasks.forEach(task -> task.queryInfo(redfishConn, server));
            BmcAuthServerImpl.updateLoginInfo(server, devNode);
            this.updateAuthStatus(server, AuthStatusEnum.AUTHED.getKey(), "");
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed.", (Object)server.getUid(), (Object)e);
            this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{server.getBmcIp()}));
        }
        finally {
            RedfishConnectionManager.INS.releaseConn(devNode);
        }
        return server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server bmcConnectivityTest(Server server, int port) {
        DevNode devNode = DevUtil.buildBmcDevNode(server, port);
        try {
            this.authBmcWithDevNode(server, devNode);
            this.updateAuthStatus(server, AuthStatusEnum.AUTHED.getKey(), "");
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed.", (Object)server.getUid(), (Object)e);
            this.authBmcWithNewPwd(devNode, server);
        }
        finally {
            RedfishConnectionManager.INS.releaseConn(devNode);
        }
        return server;
    }

    private void authBmcWithNewPwd(DevNode devNode, Server server) {
        if (StringUtils.isNULLStr((String)server.getLoginUser().getNewPwd())) {
            log.info("no new bmc pwd found for node :{}", (Object)server.getUid());
            this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{server.getBmcIp()}));
            return;
        }
        devNode.getLoginUser().setEcptPassword(server.getLoginUser().getNewPwd());
        try {
            this.authBmcWithDevNode(server, devNode);
            this.updateNewPwdToPwd(server.getLoginUser());
            this.updateAuthStatus(server, AuthStatusEnum.AUTHED.getKey(), "");
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed with new pwd.", (Object)server.getUid(), (Object)e);
            this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{server.getBmcIp()}));
        }
    }

    private void updateNewPwdToPwd(LoginUser loginUser) {
        loginUser.setPwd(loginUser.getNewPwd());
    }

    private void authBmcWithDevNode(Server server, DevNode devNode) throws ToolException {
        this.updateAuthStatus(server, AuthStatusEnum.AUTHING.getKey(), "");
        RedfishConnectionManager.INS.getRedFishConnection(devNode);
    }

    public Server syncAuthInfo2ClusterNode(MultiBmcAuthParams param, Server server) {
        if (StringUtils.isNULLStr((String)param.getClusterId()) || StringUtils.isNULLStr((String)param.getTaskId())) {
            return server;
        }
        this.devUtil.findTargetClusterNode(param.getTaskId(), param.getClusterId(), server.getUid()).ifPresent(clusterNode -> this.updateClusterAndServerInfo(param, server, (ClusterNode)clusterNode));
        return server;
    }

    private void updateClusterAndServerInfo(MultiBmcAuthParams param, Server server, ClusterNode clusterNode) {
        clusterNode.setBmcNode(DevUtil.buildBmcDevNode(server, param));
        server.setModel(clusterNode.getModel());
    }

    private static void initServer(Server server) {
        server.setBmcAuthStatus(AuthStatus.builder().status(AuthStatusEnum.AUTHING.getKey()).build());
    }

    private static void updateLoginInfo(Server server, DevNode devNode) {
        server.setLoginUser(LoginUser.builder().name(devNode.getLoginUser().getUserName()).pwd(devNode.getLoginUser().getEcptPassword()).build());
    }

    private void updateAuthStatus(Server server, String status, String description) {
        server.setBmcAuthStatus(AuthStatus.builder().status(status).description(description).build());
        if (Objects.nonNull(this.queryServer.process(server.getUid()))) {
            this.cacheServer.process(server);
        }
    }
}

