/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.device.auth.os;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.ism.tool.base.utils.StringUtils;
import com.huawei.ism.tool.inspect.fit.service.device.auth.entity.AuthStatusEnum;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.obase.connection.SshConnectionManager;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.enums.SandboxStatus;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.yinglong.drop.entity.auth.entity.LoginUser;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.AuthStatus;
import com.huawei.yinglong.river.devicemanager.storage.distribution.auth.entity.MultiOsAuthParams;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.CacheServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.QueryServer;
import com.huawei.yinglong.river.devicemanager.storage.distribution.devicecache.entity.Server;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Fitable
public class OsAuthServerImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OsAuthServerImpl.class);
    @Fit
    private QueryServer queryServer;
    @Fit
    private CacheServer cacheServer;
    @Fit
    private DevUtil devUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Server osAuth(Server server, MultiOsAuthParams param) {
        DevNode devNode = DevUtil.buildOsDevNode(server, param);
        try {
            this.checkOsSandboxStatus(server);
            this.updateAuthStatus(server, AuthStatusEnum.AUTHING.getKey(), "");
            SshConnectionManager.getSshConnection((DevNode)devNode);
            OsAuthServerImpl.updateLoginInfo(server, devNode);
            this.updateAuthStatus(server, AuthStatusEnum.AUTHED.getKey(), "");
        }
        catch (ToolException e) {
            log.error("Cluster node {} auth failed.", (Object)server.getUid(), (Object)e);
            this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), e.getErrorLocaleDescription());
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed.", (Object)server.getUid(), (Object)e);
            this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{server.getOsIp()}));
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)devNode);
        }
        return server;
    }

    public Server osConnectivityTest(Server server, int port) {
        DevNode devNode = DevUtil.buildOsDevNode(server, port);
        this.updateAuthStatus(server, AuthStatusEnum.AUTHING.getKey(), "");
        this.authOs(server, devNode, false);
        if (AuthStatusEnum.AUTHED.getKey().equals(server.getOsAuthStatus().getStatus())) {
            return server;
        }
        if (this.needTryWithNewPwd(server)) {
            devNode = DevUtil.buildOsNodeWithNewPwd(server, port);
            this.authOs(server, devNode, true);
            this.updateNewPwdToPwd(devNode, server);
        } else {
            this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), "");
        }
        return server;
    }

    private void updateNewPwdToPwd(DevNode devNode, Server server) {
        if (!AuthStatusEnum.AUTHED.getKey().equals(server.getOsAuthStatus().getStatus())) {
            return;
        }
        server.getOsUser().setPwd(devNode.getLoginUser().getEcptPassword());
        if (server.getOsRootUser() != null) {
            server.getOsRootUser().setPwd(devNode.getRootUser().getEcptPassword());
        }
    }

    private boolean needTryWithNewPwd(Server server) {
        return !StringUtils.isNULLStr((String)server.getOsUser().getNewPwd()) || !StringUtils.isNULLStr((String)server.getOsRootUser().getNewPwd());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void authOs(Server server, DevNode devNode, boolean failedUpdateStatus) {
        try {
            SshConnectionManager.getSshConnection((DevNode)devNode);
            this.updateAuthStatus(server, AuthStatusEnum.AUTHED.getKey(), "");
        }
        catch (ToolException e) {
            log.error("Cluster node {} auth failed.", (Object)server.getUid(), (Object)e);
            if (failedUpdateStatus) {
                this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), e.getErrorLocaleDescription());
            }
        }
        catch (Exception e) {
            log.error("Cluster node {} auth failed.", (Object)server.getUid(), (Object)e);
            if (failedUpdateStatus) {
                this.updateAuthStatus(server, AuthStatusEnum.AUTH_FAILED.getKey(), ResourceUtil.getStringWithParams((String)"device.cluster.auth.failed", (Object[])new Object[]{server.getOsIp()}));
            }
        }
        finally {
            SshConnectionManager.releaseConnection((DevNode)devNode);
        }
    }

    private void checkOsSandboxStatus(Server server) throws ToolException {
        if (SandboxStatus.getStatusByCode((int)server.getSandboxStatus()) == SandboxStatus.OPEN) {
            throw new ToolException("server.sandbox.open.auth.failed");
        }
    }

    public List<Server> queryAndInitServer(MultiOsAuthParams param) {
        return param.getUids().stream().map(uid -> this.queryServer.process(uid)).peek(OsAuthServerImpl::initServer).collect(Collectors.toList());
    }

    public List<Server> queryAndInitServer(List<String> uids) {
        return uids.stream().map(uid -> this.queryServer.process(uid)).peek(OsAuthServerImpl::initServer).collect(Collectors.toList());
    }

    public Server syncAuthInfo2ClusterNode(MultiOsAuthParams param, Server server) {
        if (StringUtils.isNULLStr((String)param.getClusterId()) || StringUtils.isNULLStr((String)param.getTaskId())) {
            return server;
        }
        this.devUtil.findTargetClusterNode(param.getTaskId(), param.getClusterId(), server.getUid()).ifPresent(clusterNode -> clusterNode.setOsNode(DevUtil.buildOsDevNode(server, param)));
        return server;
    }

    private static void initServer(Server server) {
        server.setOsAuthStatus(AuthStatus.builder().status(AuthStatusEnum.AUTHING.getKey()).description("").build());
    }

    private static void updateLoginInfo(Server server, DevNode devNode) {
        server.setOsUser(LoginUser.builder().name(devNode.getLoginUser().getUserName()).pwd(devNode.getLoginUser().getEcptPassword()).build());
        if (devNode.getRootUser() != null) {
            server.setOsRootUser(LoginUser.builder().name(devNode.getRootUser().getUserName()).pwd(devNode.getRootUser().getEcptPassword()).build());
        }
    }

    private void updateAuthStatus(Server server, String status, String description) {
        server.setOsAuthStatus(AuthStatus.builder().status(status).description(description).build());
        if (Objects.nonNull(this.queryServer.process(server.getUid()))) {
            this.cacheServer.process(server);
        }
    }
}

