/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.tool.inspect.fit.service.expansion;

import com.huawei.fitframework.annotation.Fit;
import com.huawei.fitframework.annotation.Fitable;
import com.huawei.fitframework.annotation.FitableSuite;
import com.huawei.ism.tool.inspect.fit.service.ExpansionImpl;
import com.huawei.ism.tool.inspect.fit.service.expansion.ExpansionConfigManager;
import com.huawei.ism.tool.inspect.fit.service.task.TaskWorkerManager;
import com.huawei.ism.tool.inspect.fit.util.DevUtil;
import com.huawei.ism.tool.inspect.fit.validator.impl.TaskExistValidator;
import com.huawei.ism.tool.obase.entity.DevNode;
import com.huawei.ism.tool.obase.exception.ToolException;
import com.huawei.ism.tool.obase.utils.ResourceUtil;
import com.huawei.ism.tool.service.fit.util.ResponseUtil;
import com.huawei.yinglong.drop.entity.rest.entity.Response;
import com.huawei.yinglong.river.expansion.storage.distribution.expansion.ConfirmExpansionInfo;
import java.util.Collections;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@FitableSuite
public class ConfirmExpansionInfoImpl {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConfirmExpansionInfoImpl.class);
    @Fit
    TaskWorkerManager taskWorkerManager;
    @Fit
    ExpansionImpl expansion;
    @Fit
    TaskExistValidator taskExistValidator;
    @Fit
    DevUtil devUtil;
    @Fit
    ExpansionConfigManager manager;

    @Fitable(generic=ConfirmExpansionInfo.class, id="b06fce1ad4d648efa81312220398e83b")
    public Response<String> confirmExpansionInfo(String taskId, String devId) {
        try {
            this.taskExistValidator.validator(taskId, devId);
            DevNode devNode = this.devUtil.findDevNode(taskId, devId);
            this.expansion.bindingExpansionInformation(taskId, Collections.singletonList(devNode));
        }
        catch (ToolException e) {
            log.error("Failed to bind the capacity expansion information. devIp: {}", (Object)devId, (Object)e);
            this.manager.removeConfigById(taskId, devId);
            return ResponseUtil.failed((Object)e.getErrorLocaleDescription());
        }
        catch (Exception e) {
            log.error("Failed to bind the capacity expansion information. devIp: {}", (Object)devId, (Object)e);
            this.manager.removeConfigById(taskId, devId);
            return ResponseUtil.failed((Object)ResourceUtil.getString((String)"fit.bind.failed"));
        }
        return ResponseUtil.success((Object)"");
    }

    @Generated
    public void setTaskWorkerManager(TaskWorkerManager taskWorkerManager) {
        this.taskWorkerManager = taskWorkerManager;
    }

    @Generated
    public void setExpansion(ExpansionImpl expansion) {
        this.expansion = expansion;
    }

    @Generated
    public void setTaskExistValidator(TaskExistValidator taskExistValidator) {
        this.taskExistValidator = taskExistValidator;
    }

    @Generated
    public void setDevUtil(DevUtil devUtil) {
        this.devUtil = devUtil;
    }

    @Generated
    public void setManager(ExpansionConfigManager manager) {
        this.manager = manager;
    }
}

